/* vudu.c -- ihelp intuition voodoo	*/

/*
Copyright (c) 1987, 1988, 1989 Jim Mackraz and I&I Computing.

Executables based on this information may be used in software
for Commodore Amiga computers.  All other rights reserved.
This information is provided "as is"; no warranties are made.
All use is at your own risk, and no liability or responsibility
is assumed.
*/

/*** NOTICE: THIS IS BY NO MEANS A SUPPORTED BAG OF TRICKS
 *** USE AT OWN RISK AND BE PREPARED TO THROW IT AWAY IF
 *** A FUTURE VERSION OF THE OS CAUSES IT TO BREAK.
 ***/

#include "ihelp.h"

#define D(x)	;

struct IntuitionBase *IntuitionBase;

#define	IMINWIDTH	40
#define	IMINHEIGHT	30
#define	MIN(A,B)	(((A)<(B))?(A):(B))
#define	MAX(A,B)	(((A)>(B))?(A):(B))

makesize(command)
{
	ULONG			ilock;
	struct Window	*awindow;
	struct Screen	*ascreen;
	SHORT			deltaw;
	SHORT			deltah;

	ilock = LockIBase(0L);
	awindow = IntuitionBase->ActiveWindow;
	ascreen = awindow->WScreen;

	switch (command)
	{
	case MAKESMALL:
		deltaw = MAX(awindow->MinWidth, IMINWIDTH) - awindow->Width;
		deltah = MAX(awindow->MinHeight, IMINHEIGHT) - awindow->Height;
		break;

	case MAKEBIG:
		deltaw =
			MIN(ascreen->Width - awindow->LeftEdge, (unsigned) awindow->MaxWidth)
			- awindow->Width;
		deltah =
			MIN(ascreen->Height-awindow->TopEdge, (unsigned) awindow->MaxHeight)
			- awindow->Height;
		break;
	default:
		deltaw = 0;
		deltah = 0;
	}

#if DEBUG
	kprintf("current w/h: %d/%d\n", awindow->Width, awindow->Height);
	kprintf("min w/h: %d/%d\n", awindow->MinWidth, awindow->MinHeight);
	kprintf("delta w/h: %ld/%ld\n", deltaw, deltah);
#endif

	SizeWindow(awindow, (LONG) deltaw, (LONG) deltah);

	UnlockIBase(ilock);
}


cyclebackward()
{
	;
#if PSEUDOCODE
	lock intuition base
	find active window
	get its screen
	get frontmost layer from layer info
	get second layer too (not WBENCHWINDOW)
	unlock ibase

	is active window frontmost?
		if second is not backdrop
			active window to back
			activate second window
		else
			abort
	else
		activate frontmost
#endif
}

cycleforward()
{
	LONG			ilock;
	struct Window	*awindow;
	struct Screen	*ascreen;
	struct Layer	*rearlayer;		/* rearmost so far		*/
	struct Layer	*layer;			/* runs through layers	*/
	struct Window	*lwindow;		/* layer->Window		*/


	ilock = LockIBase(0L);
	awindow = IntuitionBase->ActiveWindow;
	ascreen = awindow->WScreen;

	D( kprintf("active window/screen: %lx/%lx\n", awindow, ascreen) );

	/* for now, only pull this shit on the workbench	*/
	if ((ascreen->Flags & SCREENTYPE) != WBENCHSCREEN)
	{
		D( kprintf("not wbscreen\n") );
		UnlockIBase(ilock);
		goto OUT;
	}

	/* find rearmost layer which is not a backdrop window,
	 * nor the bar layer, nor a WBENCHWINDOW
	 */
	rearlayer = NULL;
	for (layer = ascreen->LayerInfo.top_layer;layer; layer = layer->back)
	{
		lwindow = (struct Window *) layer->Window;
		D( kprintf("layer %lx window %lx\n",layer, lwindow) );
		if (layer == ascreen->BarLayer)	
		{
			D( kprintf("is bar layer\n") );
			continue;
		}
		if (layer->Flags & LAYERBACKDROP)
		{
			D( kprintf("backdrop layer\n") );
			continue;
		}
		if (lwindow->Flags & WBENCHWINDOW)
		{
			D( kprintf("skipping wbench window\n") );
			continue;
		}

		rearlayer = layer;
	}
	D( kprintf("let's try it\n") );
	UnlockIBase(ilock);
	D( kprintf("unlocked\n") );

	if (rearlayer)
	{
		lwindow = (struct Window *) rearlayer->Window;
		D( kprintf("window of choice: %lx\n") );
		WindowToFront(lwindow);
		if (lwindow != awindow) ActivateWindow(lwindow);
	}

OUT:
	D( kprintf("cycleback done\n") );
	return;

}

ihelp_init()
{
	/* returns 0 if problem	*/
	IntuitionBase=(struct IntuitionBase *) OpenLibrary("intuition.library",33L);
	if (!IntuitionBase) return (0);
	return (1);
}
ihelp_shutdown()
{
	if (IntuitionBase) CloseLibrary(IntuitionBase);
}
