/* ixusr.c -- InputXpression routine examples	*/

/*
Copyright (c) 1987, 1988, 1989 Jim Mackraz and I&I Computing.

Executables based on this information may be used in software
for Commodore Amiga computers.  All other rights reserved.
This information is provided "as is"; no warranties are made.
All use is at your own risk, and no liability or responsibility
is assumed.
*/

#define INTERNALSTUFF	0	/* requires pieces of system to link	*/

#include "cx/cxusr.h"

#if INTERNALSTUFF
IX *
CreateIX()
{
	IX *ix;
	ix =  (IX *) AllocMem( (ULONG) sizeof (IX), (ULONG) MEMF_CLEAR);
	if (ix) InitIX(ix);
	return (ix);
}

DeleteIX(ix)
IX *ix;
{
	FreeMem( ix, (ULONG) sizeof (IX) ); 
}
#endif


/* sets up an input expression to
 * trigger on (shift or caps) downstrokes
 */
DownstrokeIX(code, only_caps, ix)
ULONG	code;
ULONG	only_caps;
IX		*ix;
{
	ix->ix_Class = IECLASS_RAWKEY;
	ix->ix_Code = code;			/* note that IECODE_UPPREFIX not set	*/
	ix->ix_CodeMask = 0xFFFF;	/* .. and I care about it			*/

	/* trigger on just one of synonyms */
	ix->ix_QualMask = IEQUALIFIER_LSHIFT | IEQUALIFIER_REPEAT;

	ix->ix_QualSame =	IXSYM_SHIFT;

	ix->ix_Qualifier =  only_caps? IEQUALIFIER_LSHIFT: 0;
}


#if INTERNALSTUFF
LONG
SubsetIX(ix, template)
register IX	*ix;
register IX	*template;
{
	/* TRUE return if every ievent which would match ix 
	 * also would match template
	 */

	LONG	success = 0;
	UWORD	tmpqual;

	if (NULL_IX(template)) goto SUCCESS;
	if (ix->ix_Class != template->ix_Class) goto FAIL;

	/* code	*/
	if (~ix->ix_CodeMask & template->ix_CodeMask) goto FAIL;
	if (IX_NOMATCH( ix->ix_Code, template->ix_Code,
			template->ix_CodeMask )) goto FAIL;

	/* qualifier	*/
	if (~ix->ix_QualMask & template->ix_QualMask) goto FAIL;

	tmpqual = ix_synonym(ix->ix_Qualifier, ix->ix_QualSame);
	if (IX_NOMATCH(tmpqual, template->ix_Qualifier, template->ix_QualMask))
	{
		goto FAIL;
	}

SUCCESS:
	success = 1;
FAIL:
	return (success);
}
#endif

CarveIX(ix, ie)
register IX					*ix;
register struct InputEvent	*ie;
{
	/* set up ix to match only ie	*/

	ix->ix_Class		= ie->ie_Class;
	ix->ix_Code			= ie->ie_Code;
	ix->ix_CodeMask		= ~0;
	ix->ix_Qualifier	= ie->ie_Qualifier;
	ix->ix_QualMask		= ~0;
	ix->ix_QualSame		= 0;
}

dumpIX(ix)
IX	*ix;
{
	printf("dump IX: %lx\n", ix);
	if (ix->ix_Version != IX_VERSION)
		printf("\tBad Version: %x should be %x.\n", ix->ix_Version, IX_VERSION);
	printf("\tClass %x\n",ix->ix_Class);
	printf("\tCode %x, (mask %x)\n",ix->ix_Code, ix->ix_CodeMask);
	printf("\tQualifier %x (mask %x)\n",ix->ix_Qualifier, ix->ix_QualMask);
	printf("\tQualSame %x\n", ix->ix_QualSame);
}

dumpIE(ie)
struct InputEvent *ie;
{
	printf("dump IE: %lx\n", ie);
	printf("\tClass %x\n",ie->ie_Class);
	printf("\tCode %x\n",ie->ie_Code);
	printf("\tQualifier %x\n",ie->ie_Qualifier);
	printf("\tEventAddress %lx\n", ie->ie_EventAddress);
}
