/* hotkey.c -- support function for creating Commodities hotkey triad	*/

/*
Copyright (c) 1987, 1988, 1989 Jim Mackraz and I&I Computing.

Executables based on this information may be used in software
for Commodore Amiga computers.  All other rights reserved.
This information is provided "as is"; no warranties are made.
All use is at your own risk, and no liability or responsibility
is assumed.
*/

#include	"cx/cxusr.h"
#define D(x)	;

CxObj	*
HotKey(descr, port, ID)
char			*descr;
struct MsgPort	*port;
LONG			ID;
{
	CxObj	*filter;
	LONG	error;

	/*	create filter	*/
	filter = CxFilter(descr);
	if (!filter)
	{
		D( printf("HotKey: Failed filter\n") );
		return (NULL);
	}

	/*	create sender	*/
	AttachCxObj(filter, CxSender(port, ID) );

	/*	create swallow	*/
	AttachCxObj(filter, CxTranslate(NULL) );

	/* if any problems, delete all	*/
	if (error = CxObjError(filter))
	{
		D( printf("accumulated filter error: %ld\n", error) );
		DeleteCxObjAll(filter);
		return (NULL);
	}

	return (filter);
}
