;  liblink.asm -- jimm mackraz, oct 28, 1986
;  application side interface for C-routines calling example library

	include 'exec/types.i'
	include 'exec/libraries.i'

	LIBINIT
	LIBDEF	_LVOCreateCxObj
	LIBDEF	_LVOCxBroker
	LIBDEF	_LVOActivateCxObj
	LIBDEF	_LVODeleteCxObj
	LIBDEF	_LVODeleteCxObjAll
	LIBDEF	_LVOCxObjType
	LIBDEF	_LVOCxObjError
	LIBDEF	_LVOClearCxObjError
	LIBDEF	_LVOSetCxObjPri
	LIBDEF	_LVOAttachCxObj
	LIBDEF	_LVOEnqueueCxObj
	LIBDEF	_LVOInsertCxObj
	LIBDEF	_LVORemoveCxObj
	LIBDEF	_LVOFindBroker
	LIBDEF	_LVOSetTranslate
	LIBDEF	_LVOSetFilter
	LIBDEF	_LVOSetFilterIX
	LIBDEF	_LVOParseIX
	LIBDEF	_LVOCxMsgType
	LIBDEF	_LVOCxMsgData
	LIBDEF	_LVOCxMsgID
	LIBDEF	_LVODivertCxMsg
	LIBDEF	_LVORouteCxMsg
	LIBDEF	_LVODisposeCxMsg
	LIBDEF	_LVOInvertKeyMap
	LIBDEF	_LVOAddIEvents
	LIBDEF	_LVOCopyBrokerList
	LIBDEF	_LVOFreeBrokerList
	LIBDEF	_LVOBrokerCommand

	; --- xref from application
	public	_CxBase

	; --- xdef for application
	public	_CreateCxObj
	public	_CxBroker
	public	_ActivateCxObj
	public	_DeleteCxObj
	public	_DeleteCxObjAll
	public	_CxObjType
	public	_CxObjError
	public	_ClearCxObjError
	public	_SetCxObjPri
	public	_AttachCxObj
	public	_EnqueueCxObj
	public	_InsertCxObj
	public	_RemoveCxObj
	public	_FindBroker
	public	_SetTranslate
	public	_SetFilter
	public	_SetFilterIX
	public	_ParseIX
	public	_CxMsgType
	public	_CxMsgData
	public	_CxMsgID
	public	_DivertCxMsg
	public	_RouteCxMsg
	public	_DisposeCxMsg
	public	_InvertKeyMap
	public	_AddIEvents
	public	_CopyBrokerList
	public	_FreeBrokerList
	public	_BrokerCommand

;CreateCxObj(type,arg1,arg2)(D0,A0/A1)
_CreateCxObj:
	move.l	_CxBase,a6
	move.l	4(sp),D0
	move.l	8(sp),A0
	move.l	12(sp),A1
	jmp _LVOCreateCxObj(a6)

;CxBroker(nb,error)(A0,D0)
_CxBroker:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	move.l	8(sp),D0
	jmp _LVOCxBroker(a6)

;ActivateCxObj(co,true)(A0,D0)
_ActivateCxObj:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	move.l	8(sp),D0
	jmp _LVOActivateCxObj(a6)

;DeleteCxObj(co)(A0)
_DeleteCxObj:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	jmp _LVODeleteCxObj(a6)

;DeleteCxObjAll(co)(A0)
_DeleteCxObjAll:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	jmp _LVODeleteCxObjAll(a6)

;CxObjType(co)(A0)
_CxObjType:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	jmp _LVOCxObjType(a6)

;CxObjError(co)(A0)
_CxObjError:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	jmp _LVOCxObjError(a6)

;ClearCxObjError(co)(A0)
_ClearCxObjError:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	jmp _LVOClearCxObjError(a6)

;SetCxObjPri(co,pri)(A0,D0)
_SetCxObjPri:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	move.l	8(sp),D0
	jmp _LVOSetCxObjPri(a6)

;AttachCxObj(headobj,co)(A0/A1)
_AttachCxObj:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	move.l	8(sp),A1
	jmp _LVOAttachCxObj(a6)

;EnqueueCxObj(headobj,co)(A0/A1)
_EnqueueCxObj:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	move.l	8(sp),A1
	jmp _LVOEnqueueCxObj(a6)

;InsertCxObj(headobj,co,pred)(A0/A1/A2)
_InsertCxObj:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	move.l	8(sp),A1
	move.l	12(sp),A2
	jmp _LVOInsertCxObj(a6)

;RemoveCxObj(co)(A0)
_RemoveCxObj:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	jmp _LVORemoveCxObj(a6)

;FindBroker(name)(A0)
_FindBroker:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	jmp _LVOFindBroker(a6)

;SetTranslate(translator,ie)(A0/A1)
_SetTranslate:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	move.l	8(sp),A1
	jmp _LVOSetTranslate(a6)

;SetFilter(filter,text)(A0/A1)
_SetFilter:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	move.l	8(sp),A1
	jmp _LVOSetFilter(a6)

;SetFilterIX(filter,ix)(A0/A1)
_SetFilterIX:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	move.l	8(sp),A1
	jmp _LVOSetFilterIX(a6)

;ParseIX(descr,ix)(A0/A1)
_ParseIX:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	move.l	8(sp),A1
	jmp _LVOParseIX(a6)

;CxMsgType(cxm)(A0)
_CxMsgType:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	jmp _LVOCxMsgType(a6)

;CxMsgData(cxm)(A0)
_CxMsgData:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	jmp _LVOCxMsgData(a6)

;CxMsgID(cxm)(A0)
_CxMsgID:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	jmp _LVOCxMsgID(a6)

;DivertCxMsg(cxm,headobj,return)(A0/A1/A2)
_DivertCxMsg:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	move.l	8(sp),A1
	move.l	12(sp),A2
	jmp _LVODivertCxMsg(a6)

;RouteCxMsg(cxm,co)(A0/A1)
_RouteCxMsg:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	move.l	8(sp),A1
	jmp _LVORouteCxMsg(a6)

;DisposeCxMsg(cxm)(A0)
_DisposeCxMsg:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	jmp _LVODisposeCxMsg(a6)


;InvertKeyMap(ansicode,ie,km)(D0,A0/A1)
_InvertKeyMap:
	move.l	_CxBase,a6
	move.l	4(sp),D0
	move.l	8(sp),A0
	move.l	12(sp),A1
	jmp _LVOInvertKeyMap(a6)

;AddIEvents(ie)(A0)
_AddIEvents:
	move.l	_CxBase,a6
	move.l	4(sp),a0
	jmp _LVOAddIEvents(a6)

;CopyBrokerList(ie)(A0)
_CopyBrokerList:
	move.l	_CxBase,a6
	move.l	4(sp),a0
	jmp _LVOCopyBrokerList(a6)

;FreeBrokerList(ie)(A0)
_FreeBrokerList:
	move.l	_CxBase,a6
	move.l	4(sp),a0
	jmp _LVOFreeBrokerList(a6)

;BrokerCommand(name,id)(A0,D0)
_BrokerCommand:
	move.l	_CxBase,a6
	move.l	4(sp),A0
	move.l	8(sp),D0
	jmp _LVOBrokerCommand(a6)

	end
