/* argarray.c -- tool types and startup parameters.	*/

/*
Copyright (c) 1987, 1988, 1989 Jim Mackraz and I&I Computing.

Executables based on this information may be used in software
for Commodore Amiga computers.  All other rights reserved.
This information is provided "as is"; no warranties are made.
All use is at your own risk, and no liability or responsibility
is assumed.
*/

#include <exec/types.h>
#include <workbench/workbench.h>
#include <workbench/startup.h>
#include <stdio.h>

#include "cx/cxusr.h"

LONG						IconBase = 0;
static	struct	DiskObject	*disko = NULL;

/* Pass this your start-up arguments, and it will return
 * an array of strings, either ToolTypes or command line args
 * which should be of the form "THING=some thing else"
 *
 * Opens the icon library and may call GetDiskObject, so
 * be sure to call ArgArrayDone() after you are through
 * using icon library functions and the array of strings.
 *
 * This technique (of blurring the distinction between ToolTypes
 * and argv[]) can only work if startup null-terminates argv[]
 * (i.e., argv[argc] == NULL).  Manx is OK.
 */
char	**
ArgArrayInit(argc, argv)
int		argc;
char	**argv;
{
	int i;
	char	**tt;
	char	**getToolTypes();
	char	*s;

	/* open icon.library in any case so user can call
	 * FindToolType().
	 */
	if (!(IconBase = (LONG) OpenLibrary("icon.library", 32L))) {
		return (NULL);
	}

	if (argc) {
		return (argv);
	}
	else {
		return (getToolTypes(argv));
	}
}

void
ArgArrayDone()
{
	if (disko) FreeDiskObject(disko);
	if (IconBase) CloseLibrary(IconBase);
}

/* returns a string from a tooltypes array, or the
 * default passed if none is found
 */
char	*
ArgString(tt, string, defstring)
char	**tt;
char	*string;
char	*defstring;
{
	char 	*s;

	if (tt && (s = FindToolType(tt, string)) ) {
		return (s);
	}
	else {
		return (defstring);
	}
}

/* This function returns an integer value from a tooltype
 * string, using the 'defval' if the tooltype entry is
 * not found.  The point is that atoi(NULL) isn't zero
 * if some program put garbage at location 0.
 */
ArgInt(tt, field_name, defval)
char	**tt;
char	*field_name;
int		defval;
{
	char	*s;

	s = FindToolType(tt, field_name);

	return (s? atoi(s): defval);
}

/* This function is an interface to CxFilter() which 
 * allows an entry in a ToolTypes field to override
 * the programmers default choice of input description.
 */
CxObj	*
UserFilter(tt, action_name, default_descr)
char	**tt;			/* null-terminated (char *(*)[])	*/
char	*action_name;	/* name of your semantic action		*/
char	*default_descr;	/* used if user doesn't provide		*/
{
	char	*desc;

	desc = FindToolType(tt, action_name);

	return ( CxFilter(desc? desc: default_descr) );
}

char **
getToolTypes(msg)
struct WBStartup *msg;
{
	struct	WBArg		*arg;
	char				**tt;

	arg = msg->sm_ArgList;

	disko = GetDiskObject(arg->wa_Name);

	if (disko)
	{
		tt = disko->do_ToolTypes;
	}

	return (tt);
}

