/*
** $Source: hog:Other/networking/sana2/src/slip/RCS/slip_device.h,v $
** $State: Exp $
** $Revision: 37.2 $
** $Date: 92/08/25 16:43:51 $
** $Author: kcd $
**
** SANA-II Example device driver C include file
**
** (C) Copyright 1992 Commodore-Amiga, Inc.
*/

#include <exec/types.h>
#include <exec/devices.h>
#include <exec/ports.h>
#include <exec/semaphores.h>
#include <exec/memory.h>
#include <dos.h>
#include <devices/sana2.h>
#include <devices/serial.h>

/*
** Stacksize and Priority of the Unit Process
*/
#define SLIP_STACKSIZE 4000
#define SLIP_PRI 5

/*
** Maximum Transmission Unit
*/
#define SLIP_MTU 1006

/*
** Max # of Units allowed
*/
#define SD_MAXUNITS 8

/*
** Message passed to the Unit Process at
** startup time.
*/
struct StartupMessage
{
	struct Message	Msg;
	struct Unit	*Unit;
	struct Device	*Device;
};

/*
** Device Data Structure
*/
struct SLIPDevice
{
    struct Library	 sd_Device;
    UBYTE		 sd_Flags;
    UBYTE		 sd_Pad1;
    struct Library	*sd_SysBase;
    struct Library	*sd_DOSBase;
    ULONG		 sd_DosTag[10];
    BPTR		 sd_SegList;
    struct Unit		*sd_Units[SD_MAXUNITS];
    struct SignalSemaphore sd_Lock;
    struct StartupMessage sd_Startup;
};

/*
** Typedef's for the SANA-II callback functions.
*/
typedef BOOL (*SANA2_CFB)(APTR to, APTR from, LONG length);
typedef BOOL (*SANA2_CTB)(APTR to, APTR from, LONG length);

struct BufferManagement
{
    struct MinNode	bm_Node;
    SANA2_CFB		bm_CopyFromBuffer;
    SANA2_CTB		bm_CopyToBuffer;
};

struct SuperS2PTStats
{
    struct MinNode		ss_Node;
    ULONG			ss_PType;
    struct Sana2PacketTypeStats	ss_Stats;
};

/*
** Unit Data Structure
*/
struct SLIPDevUnit
{
    struct Unit			 sdu_Unit;		/* Standard Unit Structure */
    UBYTE			 sdu_UnitNum;		/* Unit number */
    UBYTE			 sdu_Reserved0;		/* Padding */
    struct Device		*sdu_Device;		/* Pointer to our device node */
    ULONG			 sdu_StAddr;		/* Our "hardware" address */
    ULONG			 sdu_BaudRate;		/* Serial baud rate */
    ULONG			 sdu_SerUnitNum;	/* Serial driver unit number */
    BOOL			 sdu_NoMore;		/* ??? */
    BOOL			 sdu_Escape;		/* SLIP Decode state */
    ULONG			 sdu_State;		/* Various state information */
    struct IOExtSer 		*sdu_SerRx;		/* Serial IORequest for CMD_READ's */
    struct IOExtSer 		*sdu_SerTx;		/* Serial IORequest for CMD_WRITE's */
    struct MsgPort 		*sdu_RxPort;		/* Serial CMD_READ IORequest reply port */
    struct MsgPort 		*sdu_TxPort;		/* Serial CMD_WRITE IORequest reply port */
    UBYTE			*sdu_RxBuff;		/* Buffer for holding decoded packets */
    UBYTE			*sdu_RxBuffPtr;		/* Current place in decode buffer */
    UBYTE			*sdu_TxBuff;		/* Temporary buffer for hold unencoded outgoing packets */
    UBYTE			*sdu_RxSLIP;		/* Two buffers that hold packets encoded */
    UBYTE			*sdu_TxSLIP;		/* in SLIP format. */
    struct Process		*sdu_Proc; 		/* NB: This points to the Task, not the MsgPort */
    struct SignalSemaphore	 sdu_ListLock;		/* A Semaphore for access to all of our queues. */
    struct MinList		 sdu_Rx;                /* Pending CMD_READ's */
    struct MinList		 sdu_RxOrph;		/* Pending CMD_READORPHAN's */
    struct MinList	 	 sdu_Tx;		/* Pending CMD_WRITE's */
    struct MinList	 	 sdu_Events;		/* Pending S2_ONEVENT's */
    struct SuperS2PTStats	*sdu_IPTrack;		/* For tracking IP packets */
    struct MinList	 	 sdu_Track;		/* List of packet types being tracked */
    struct MinList		 sdu_BuffMgmt;		/* List of Callback routines */
    struct Sana2DeviceStats	 sdu_Stats;		/* Global device statistics */
    UBYTE		 	 sdu_SerDevName[32];	/* Name of the serial driver to use */
};

/*
** State bits for sdu_State
*/

#define SLIPUB_CONFIG 0
#define SLIPUB_ONLINE 1
#define SLIPUB_SETCONFIG 2
#define SLIPUB_CD 3
#define SLIPUB_EXCLUSIVE 4
#define SLIPUB_7WIRE 5

#define SLIPUF_CONFIG		(1<<SLIPUB_CONFIG)
#define SLIPUF_ONLINE		(1<<SLIPUB_ONLINE)
#define SLIPUF_SETCONFIG	(1<<SLIPUB_SETCONFIG)
#define SLIPUF_CD		(1<<SLIPUB_CD)
#define SLIPUF_EXCLUSIVE	(1<<SLIPUB_EXCLUSIVE)
#define SLIPUF_7WIRE		(1<<SLIPUB_7WIRE)

/*
** Device Name
*/

#define SLIPDEVNAME "slip.device"

/*
** Packet Encoding Bytes
*/

#define SLIP_END     192
#define SLIP_ESC     219
#define SLIP_ESC_END 220
#define SLIP_ESC_ESC 221

/*
** Compiler Magic
**
*/
#define SLIPBase ((struct SLIPDevice *)__builtin_getreg(14))	/* Avoid the pre-processor problem */

#define SysBase		(SLIPBase->sd_SysBase)
#define DOSBase		(SLIPBase->sd_DOSBase)

#define ASM           __asm
#define REG(x)        register __ ## x

