**
** $Source: hog:Other/networking/sana2/src/slip/RCS/slip_device.asm,v $
** $State: Exp $
** $Revision: 37.3 $
** $Date: 92/08/25 16:42:36 $
** $Author: kcd $
**
** Amiga SANA2 Example SLIP Device Driver
**
** (C) Copyright 1992 Commodore-Amiga, Inc.
**


	SECTION	firstsection

	NOLIST

	include	"exec/types.i"
	include	"exec/devices.i"
	include	"exec/initializers.i"
	include	"exec/memory.i"
	include	"exec/resident.i"
	include	"exec/io.i"
	include	"exec/ables.i"
	include	"exec/errors.i"
	include	"exec/tasks.i"
	include	"utility/tagitem.i"
	include	"dos/dos.i"
	include	"dos/dosextens.i"
	include	"dos/dostags.i"
	include	"devices/serial.i"
	include	"devices/sana2.i"
	include	"slip_device.i"
        include "slip_rev.i"

	LIST

ABSEXECBASE	EQU	4	;Absolute location of the pointer to exec.library base
**
** First executable location
**

FirstAddress:
	moveq	#-1,d0
	rts

SLIPPRI   EQU   5

	XREF	EndCode

initDDescrip:
					; STRUCTURE RT,0
	DC.W	RTC_MATCHWORD		; UWORD	RT_MATCHWORD (Magic cookie)
	DC.L	initDDescrip		; APTR	RT_MATCHTAG  (Back pointer)
	DC.L	EndCode			; APTR	RT_ENDSKIP   (To end of this hunk)
	DC.B	RTF_AUTOINIT		; UBYTE	RT_FLAGS     (magic-see "Init:")
	DC.B	VERSION			; UBYTE	RT_VERSION
	DC.B	NT_DEVICE		; UBYTE	RT_TYPE	     (must be correct)
	DC.B	SLIPPRI			; BYTE	RT_PRI
	DC.L	SLIPName		; APTR	RT_NAME	     (exec name)
	DC.L	idString		; APTR	RT_IDSTRING  (text string)
	DC.L	Init			; APTR	RT_INIT
					; LABEL	RT_SIZE

SLIPName:	SLIPDEVNAME

** This is an identifier tag to help in supporting the device
** format is 'name version.revision (dd MON yyyy)',<cr>,<lf>,<null>

idString:	VSTRING

** Force word alignment

	CNOP	0,4

Init:
	DC.L	SLIPDev_Sizeof	; data space size
	DC.L	DevFuncTable	; pointer to function initializers
	DC.L	0		; pointer to data initializers (unused)
	DC.L	DevInit		; routine to run

**
** Standard System Routines
**

	XREF	_DevOpen
	XREF	_DevClose
	XREF	_DevExpunge
	XREF	_DevBeginIO
	XREF	_DevAbortIO

**
** Other misc. routines
**
	XDEF	_ExtDeviceBase
	XDEF	_DevProcEntry
	XDEF	@IPToNum
	XDEF	_SANA2BuffCall
	XREF	_DevProcCEntry

V_DEF	MACRO
	DC.W	\1+(*-DevFuncTable)
	ENDM

DevFuncTable:
	DC.W	-1
	V_DEF	_DevOpen
	V_DEF	_DevClose
	V_DEF	_DevExpunge
	V_DEF	DevReserved
	V_DEF	_DevBeginIO
	V_DEF	_DevAbortIO
	DC.W	-1

_ExtDeviceBase	dc.l	0

**
** initRoutine
**
** Called after device has been allocated.
** This routine is single threaded
**
** Register Usage
**
** a3 - Pointer to temporary RAM
** a4 - Pointer to expansion.library base
** d0 - Pointer to device struct
** a6 - Pointer to Exec Base

DevInit:
	movem.l	a0/a5,-(sp)
	movea.l	d0,a5
	move.w	#REVISION,LIB_REVISION(a5)
	move.l	a6,sd_SysLib(a5)
	move.l	a0,sd_SegList(a5)
	lea.l	sd_Lock(a5),a0
	jsrlib	InitSemaphore
	move.l	a5,d0
	movem.l	(sp)+,a0/a5
	rts

DevReserved:
	moveq.l	#0,d0
	rts

@IPToNum:
	movem.l	d2,-(sp)
	bsr	StrToNum
	lsl.w	#8,d0
	move.w	d0,d2
	bsr	StrToNum
	move.b	d0,d2
	swap	d2
	bsr	StrToNum
	lsl.w	#8,d0
	move.w	d0,d2
	bsr	StrToNum
	move.b	d0,d2
	move.l	d2,d0
	movem.l	(sp)+,d2
	rts

StrToNum:
	moveq	#0,d0
	moveq	#0,d1
1$	move.b	(a0)+,d1
	cmp.b	#'0',d1
	blo	2$
	cmp.b	#'9',d1
	bhi	2$
	sub.b	#'0',d1
	mulu	#10,d0
	add.w	d1,d0
	bra	1$
2$	rts

_DevProcEntry:
	movea.l	_ExtDeviceBase(pc),a6
	jmp	_DevProcCEntry

_SANA2BuffCall:
	jmp	(a2)
