/*
** $Source: hog:Other/networking/sana2/src/slip/RCS/device_protos.h,v $
** $State: Exp $
** $Revision: 37.2 $
** $Date: 92/08/23 21:23:07 $
** $Author: kcd $
**
** Amiga SANA-II Example SLIP device driver.
**
** (C) Copyright 1992 Commodore-Amiga, Inc.
**
*/

/* Prototypes for functions defined in device_funcs.c */

ULONG __asm DevOpen(register __a1 struct IOSana2Req * ios2,
                    register __d0 ULONG s2unit,
                    register __d1 ULONG s2flags);
BPTR __asm DevClose(register __a1 struct IOSana2Req * ios2);
BPTR __asm DevExpunge(VOID);
struct SLIPDevUnit *InitSLIPUnit(ULONG s2unit);
VOID ExpungeUnit(struct SLIPDevUnit *sdu);
BOOL ReadConfig(struct SLIPDevUnit *sdu);
VOID __asm DevBeginIO(register __a1 struct IOSana2Req * ios2);
VOID PerformIO(struct IOSana2Req *ios2);
VOID GetSpecialStats(struct SLIPDevUnit *sdu,
                     struct IOSana2Req *ios2);
VOID GetGlobalStats(struct SLIPDevUnit *sdu,
                    struct IOSana2Req *ios2);
VOID GetTypeStats(struct SLIPDevUnit *sdu,
                  struct IOSana2Req *ios2);
VOID TrackType(struct SLIPDevUnit *sdu,
               struct IOSana2Req *ios2);
VOID UnTrackType(struct SLIPDevUnit *sdu,
                 struct IOSana2Req *ios2);
VOID PacketReceived(struct SLIPDevUnit *sdu,
                    ULONG length);
VOID PacketSent(struct SLIPDevUnit *sdu,
                ULONG length);
VOID PacketOverrun(struct SLIPDevUnit *sdu);
VOID ReceivedGarbage(struct SLIPDevUnit *sdu);
VOID PacketDropped(struct SLIPDevUnit *sdu);
VOID TermIO(struct IOSana2Req *ios2);
ULONG __asm DevAbortIO(register __a1 struct IOSana2Req * ios2,
                       register __a3 struct SLIPDevUnit * sdu);
ULONG AbortReq(struct MinList *minlist,
               struct IOSana2Req *ios2);
VOID ConfigInterface(struct SLIPDevUnit *sdu,
                     struct IOSana2Req *ios2);
VOID GetStationAddress(struct SLIPDevUnit *sdu,
                       struct IOSana2Req *ios2);
VOID DeviceQuery(struct SLIPDevUnit *sdu,
                 struct IOSana2Req *ios2);
VOID WritePacket(struct SLIPDevUnit *sdu,
                 struct IOSana2Req *ios2);
VOID SendPacket(struct SLIPDevUnit *sdu,
                struct IOSana2Req *ios2);
ULONG EncodeSLIP(UBYTE *source,
                 UBYTE *dest,
                 ULONG length);
VOID ReadPacket(struct SLIPDevUnit *sdu,
                struct IOSana2Req *ios2);
VOID ReadOrphan(struct SLIPDevUnit *sdu,
                struct IOSana2Req *ios2);
BOOL InitSerial(struct SLIPDevUnit *sdu);
VOID DeinitSerial(struct SLIPDevUnit *sdu);
VOID OnEvent(struct SLIPDevUnit *sdu,
             struct IOSana2Req *ios2);
BOOL OpenSerial(struct SLIPDevUnit *sdu);
VOID MarkTimeOnline(struct SLIPDevUnit *sdu);
VOID CloseSerial(struct SLIPDevUnit *sdu);
VOID Online(struct SLIPDevUnit *sdu,
            struct IOSana2Req *ios2);
VOID Offline(struct SLIPDevUnit *sdu,
             struct IOSana2Req *ios2);
VOID DoEvent(struct SLIPDevUnit *sdu,
             ULONG event);
VOID DoOffline(struct SLIPDevUnit *sdu);
VOID ServiceTxPort(struct SLIPDevUnit *sdu);
VOID DoSerial(struct SLIPDevUnit *sdu,
              struct IOExtSer *ioSer);
VOID GotPacket(struct SLIPDevUnit *sdu,
               ULONG length);
VOID QueueSerRequest(struct SLIPDevUnit *sdu);
VOID __asm DevProcCEntry(VOID);
VOID NewList(struct List *list);
