#ifndef MIDI_REALTIMEBASE_H
#define MIDI_REALTIMEBASE_H

/************************************************************************
*     RealTime Library (timing & syncing system)                        *
*************************************************************************
*                                                                       *
* Design & Development  - Talin & Joe Pearce                            *
*                                                                       *
* Copyright 1992 by Commodore Business Machines                         *
*************************************************************************
*
* realtimebase.h - RealTime library base structure
*
************************************************************************/

#ifndef EXEC_LIBRARIES_H
  #include <exec/libraries.h>
#endif

#ifndef EXEC_LISTS_H
  #include <exec/lists.h>
#endif

#ifndef EXEC_SEMAPHORES_H
  #include <exec/semaphores.h>
#endif


struct RealTimeBase 
{
    struct Library Lib;
    UWORD pad0;

	/* publicly available stuff (READ ONLY) */
    ULONG Time; 	/* current time */
    ULONG TimeDelta;	/* time delta */
    WORD TickFreq;	/* ideal RealTime Tick frequency */
    WORD TickErr;	/* nanosecond error from ideal Tick length to real tick length */
			/* actual tick length is:  1/TickFreq + TickErr/1e9 */
			/* -705 < TickErr < 705 */

	/* private stuff below here */
};

#define RealTime_TickErr_Min    -705
#define RealTime_TickErr_Max    705

#endif
