    ifnd    MIDI_REALTIME_I
MIDI_REALTIME_I set 1

*************************************************************************
*     RealTime Library (timing & syncing system)                        *
*************************************************************************
*                                                                       *
* Design & Development  - Talin & Joe Pearce                            *
*                                                                       *
* Copyright 1992 by Commodore Business Machines                         *
*************************************************************************
*
* realtime.h  - RealTime conductor/player include file.
*
*************************************************************************

	ifnd	EXEC_TYPES_I
	include "exec/types.i"
	endc

    ifnd    EXEC_MACROS_I
    include "exec/macros.i"
    endc

    ifnd    EXEC_NODES_I
    include "exec/nodes.i"
    endc

	ifnd	EXEC_LISTS_I
	include "exec/lists.i"
	endc

	ifnd	UTILITY_TAGITEM_I
	include "utility/tagitem.i"
	endc

	ifnd	UTILITY_HOOKS_I
	include "utility/hooks.i"
	endc


* Each Conductor represents a group of applications which wish to remain
* synchronized together.
*

    STRUCTURE Conductor,LN_SIZE
	UWORD	cdt_nodepad
	STRUCT	cdt_Players,MLH_SIZE	; list of players
	ULONG	cdt_ClockTime		; current time of this sequence
	ULONG	cdt_StartTime		; start time of this sequence
	ULONG	cdt_ExternalTime	; time from external unit
	ULONG	cdt_MaxExternalTime	; upper limit on sync'd time
	ULONG	cdt_Metronome		; metronome time of highest pri node
 	UWORD	cdt_PlayersNotReady	; count of players not ready
	UWORD	cdt_Flags		; clock flags
	UBYTE	cdt_State		; playing or stopped
    	UBYTE	cdt_Stopped		; quick running check
	LABEL	Conductor_Size

    BITDEF  CONDUCT,EXTERNAL,0		; clock is externally driven
    BITDEF  CONDUCT,GOTTICK,1		; received 1st external tick
    BITDEF  CONDUCT,METROSET,2		; if Metronone has been filled in

    ENUM    0

    EITEM   CLOCKSTATE_STOPPED		; clock is stopped
    EITEM   CLOCKSTATE_PAUSED		; clock is paused
    EITEM   CLOCKSTATE_LOCATE		; go to 'running' when ready
    EITEM   CLOCKSTATE_RUNNING		; run clock NOW

CLOCKSTATE_METRIC  EQU  -1		; ask high node to locate
CLOCKSTATE_SHUTTLE EQU  -2		; tie changing but not running

    BITDEF  CONDSTOP,STOPPED,0		; not running state
    BITDEF  CONDSTOP,NOTICK,1		; extsync & not gottick

* The PlayerInfo is the connetion between a Conductor and an application.
*

    STRUCTURE PlayerInfo,LN_SIZE
	UWORD	pi_nodepad
	APTR	pi_Hook			; callback for player
    	APTR 	pi_Source;		; pointer to parent context
	APTR	pi_Task;		; task to signal for changes
    	LONG	pi_MetricTime;		; current time in app's metric
    	LONG	pi_AlarmTime;		; time to wake up
    	APTR	pi_UserData;		; for application use
    	UWORD	pi_PlayerID;		; for application use
    	UWORD	pi_Flags;		; general PlayerInfo flags
	STRUCT	pi_Reserved,2*4		; internal use
	BYTE	pi_AlarmSigBit;		; signal to send for alarms
	LABEL	PlayerInfo_Size

    BITDEF  PLAYER,READY,0		; player is ready to go!
    BITDEF  PLAYER,ALARMSET,1		; alarm is set
    BITDEF  PLAYER,QUIET,2		; a dummy player, used for sync
    BITDEF  PLAYER,CONDUCTED,3		; give me metered time
    BITDEF  PLAYER,EXTSYNC,4		; granted external sync

    ENUM    TAG_USER+65

    EITEM   PLAYER_Hook			; set address of hook function
    EITEM   PLAYER_Name			; name of player
    EITEM   PLAYER_Priority		; priority of player
    EITEM   PLAYER_Conductor		; set conductor for player
					; if ~0, create private conductor
    EITEM   PLAYER_Ready		; the "ready" flag
    EITEM   PLAYER_SignalTask		; task to signal for alarm/state change
    EITEM   PLAYER_Conducted		; sets/clears CONDUCTED flag
    EITEM   PLAYER_AlarmSigBit          ; signal bit for alarm (or -1)
    EITEM   PLAYER_Quiet		; don't process time thru this
    EITEM   PLAYER_UserData
    EITEM   PLAYER_ID
    EITEM   PLAYER_AlarmTime		; alarm time (sets PLAYERF_ALARMSET)
    EITEM   PLAYER_AlarmOn		; sets/clears ALARMSET flag
    EITEM   PLAYER_ExtSync 		; attempt/release to ext sync

    EITEM   PLAYER_ErrorCode 		; error return code

* Mesages sent via PlayerInfo hook.
*

    ENUM    0

    EITEM   PM_TICK
    EITEM   PM_STATE
    EITEM   PM_POSITION
    EITEM   PM_SHUTTLE

    STRUCTURE pmTime,0
	ULONG	pmt_Method
	ULONG	pmt_Time
	LABEL	pmTime_Size

    STRUCTURE pmState,0
	ULONG	pms_Method
	ULONG	pms_OldState
	LABEL	pmState_Size

****************************************************************
*
*   RealTime internal lists that can be locked
*
****************************************************************

    ENUM
    EITEM   RT_Conductors                       ; conductor list
    EITEM   RT_NLocks

****************************************************************
*
*   RealTime Error Codes
*
***************************************************************/

RTE_NoMem        equ   801       ; memory allocation failed
RTE_NoSignals    equ   802       ; signal allocation failed
RTE_NoTimer      equ   803       ; timer (CIA) allocation failed

    endc
