#ifndef CLIB_REALTIME_PROTOS_H
#define CLIB_REALTIME_PROTOS_H
/************************************************************************
*     RealTime Library (timing & syncing system)                        *
*************************************************************************
*                                                                       *
* Design & Development  - Talin & Joe Pearce                            *
*                                                                       *
* Copyright 1992 by Commodore Business Machines                         *
*************************************************************************
*
* clib/realtime_protos.h    - realtime.library function prototypes
*
************************************************************************/

#ifndef EXEC_TYPES_H
  #include <exec/types.h>
#endif

#ifndef MIDI_REALTIME_H
  #include <midi/realtime.h>
#endif

    /* ---- Locks */
APTR LockRealTime (ULONG locknum);
void UnlockRealTime (APTR lock);

	/* ---- Conductors & Players */
struct PlayerInfo *CreatePlayerA(struct TagItem *);
struct PlayerInfo *CreatePlayer(Tag tag,...);
void DeletePlayer(struct PlayerInfo *);
BOOL SetPlayerAttrsA(struct PlayerInfo *, struct TagItem *);
BOOL SetPlayerAttrs(struct PlayerInfo *,Tag tag,...);
LONG SetConductorState(struct PlayerInfo *, LONG, LONG);
BOOL ExternalSync(struct PlayerInfo *, LONG, LONG);
struct Conductor *NextConductor(struct Conductor *);
struct Conductor *FindConductor (char *name);
ULONG GetPlayerAttrsA (struct PlayerInfo *pi, struct TagItem *);
ULONG GetPlayerAttrs (struct PlayerInfo *pi, Tag tag, ...);

#endif /* CLIB_REALTIME_PROTOS_H */

