 /* Code generated by Toolmaker V1.13 */

#include <stdlib.h>

#include <exec/types.h>
#include <graphics/view.h>
#include <graphics/displayinfo.h>
#include <dos/dos.h>
#include <intuition/intuition.h>
#include <intuition/gadgetclass.h>
#include <intuition/imageclass.h>
#include <intuition/classes.h>
#include <libraries/gadtools.h>
#include <exec/memory.h>

#include <clib/exec_protos.h>
#include <clib/graphics_protos.h>
#include <clib/intuition_protos.h>
#include <clib/gadtools_protos.h>
#include <clib/utility_protos.h>
#include <clib/realtime_protos.h>
#include <clib/macros.h>

#include <pragmas/exec_pragmas.h>
#include <pragmas/graphics_pragmas.h>
#include <pragmas/intuition_pragmas.h>
#include <pragmas/gadtools_pragmas.h>
#include <pragmas/utility_pragmas.h>
#include <pragmas/realtime_pragmas.h>

#include "trans.h"
#include "boximage.h"

static BOOL TM_WindowSignal(struct TMData *);
static VOID TM_RemoveWindow(struct TMWindowInfo *);
static BOOL WindowIDCMP_TRANSP(struct TMData *, struct IntuiMessage *);
static BOOL WindowIDCMP_SELECTCO(struct TMData *, struct IntuiMessage *);

UWORD __chip WaitPointer[36] =
  {
  0x0000, 0x0000,
  0x0400, 0x07C0,
  0x0000, 0x07C0,
  0x0100, 0x0380,
  0x0000, 0x07E0,
  0x07C0, 0x1FF8,
  0x1FF0, 0x3FEC,
  0x3FF8, 0x7FDE,
  0x3FF8, 0x7FBE,
  0x7FFC, 0xFF7F,
  0x7EFC, 0xFFFF,
  0x7FFC, 0xFFFF,
  0x3FF8, 0x7FFE,
  0x3FF8, 0x7FFE,
  0x1FF0, 0x3FFC,
  0x07C0, 0x1FF8,
  0x0000, 0x07E0,
  0x0000, 0x0000,
  };

	/* transport buttons */

UWORD __chip stop_data[] = { 0xFF80,0xFF80,0xFF80,0xFF80,0xFF80,0xFF80,0xFF80 };
UWORD __chip play_data[] = { 0xC000,0xF000,0xFC00,0xFF00,0xFC00,0xF000,0xC000 };
UWORD __chip rew_data[]  = { 0x0301,0x8000,0x0F07,0x8000,0x3F1F,0x8000,0xFF7F,0x8000,0x3F1F,0x8000,0x0F07,0x8000,0x0301,0x8000 };
UWORD __chip ff_data[]   =	{ 0xC060,0x0000,0xF078,0x0000,0xFC7E,0x0000,0xFF7F,0x8000,0xFC7E,0x0000,0xF078,0x0000,0xC060,0x0000 };
UWORD __chip pause_data[]= { 0xE380,0xE380,0xE380,0xE380,0xE380,0xE380,0xE380 };

UWORD __chip clocklabel_data[84] =
{	0xC600,0x0030,0x6C00,0x007C,0x0000,0x07F0,0x0000,
	0xC678,0x0038,0xE1B0,0x00C0,0x78F0,0x0603,0xCD80,
	0xC6C0,0x0035,0x6DD8,0x0070,0xCD80,0x07C6,0x1DC0,
	0xFEC0,0x0032,0x6D98,0x001C,0xFD80,0x0606,0x1AC0,
	0xC6C0,0x0030,0x6D98,0x0006,0xC180,0x0606,0x1AC0,
	0xC6C0,0x0030,0x6D98,0x00FC,0x78F0,0x0606,0x18C0,
};

struct Image clocklabel_im =
{	0,0,
	106,6,
	1,
	clocklabel_data,
	0x1,0x0,
	NULL
};

struct Glyph {
	WORD				w,h;
	UWORD				*data;
};

struct Glyph stop_glyph = { 9, 7, stop_data };
struct Glyph play_glyph = { 8, 7, play_data };
struct Glyph rew_glyph  = { 17,7, rew_data  };
struct Glyph ff_glyph   = { 17,7, ff_data   };
struct Glyph pause_glyph= { 9, 7, pause_data};

struct NewMenu newmenu_TRANSP[] =
  {
  {NM_TITLE, (UBYTE *)MENUTEXT_CONTROL,	NULL,	0,	0,	NULL},
  {NM_ITEM,  (UBYTE *)ITEMTEXT_SETCONDU,	NULL,	0,	0,	(APTR) &tmobjectdata_SETCONDU},
  {NM_ITEM,  (UBYTE *)ITEMTEXT_ABOUT,	NULL,	0,	0,	(APTR) &tmobjectdata_ABOUT},
  {NM_ITEM,  NM_BARLABEL,	NULL,	0,	0,	NULL},
  {NM_ITEM,  (UBYTE *)ITEMTEXT_QUIT,	(UBYTE *)"Q",	0,	0,	(APTR) &tmobjectdata_QUIT},

  {NM_TITLE, (UBYTE *)MENUTEXT_PROJECT,	NULL,	0,	0,	NULL},
  {NM_ITEM,  (UBYTE *)ITEMTEXT_RESETTOZ,	(UBYTE *)"0",	0,	0,	(APTR) &tmobjectdata_RESETTOZ},
  {NM_ITEM,  (UBYTE *)ITEMTEXT_CLOCKTYP,	NULL,	NM_ITEMDISABLED,	0,	NULL},
  {NM_SUB,   (UBYTE *)SUBTEXT_NTSCNOND,	(UBYTE *)"1",	CHECKIT | CHECKED,	0,	(APTR) &tmobjectdata_NTSCNOND},
  {NM_SUB,   (UBYTE *)SUBTEXT_NTSCDROP,	(UBYTE *)"2",	CHECKIT,	0,	(APTR) &tmobjectdata_NTSCDROP},
  {NM_SUB,   (UBYTE *)SUBTEXT_PAL25FPS,	(UBYTE *)"3",	CHECKIT,	0,	(APTR) &tmobjectdata_PAL25FPS},
  {NM_SUB,   (UBYTE *)SUBTEXT_FILM24FP,	(UBYTE *)"4",	CHECKIT,	0,	(APTR) &tmobjectdata_FILM24FP},
  {NM_ITEM,  NM_BARLABEL,	NULL,	0,	0,	NULL},
  {NM_ITEM,  (UBYTE *)ITEMTEXT_POSITIVE,	NULL,	CHECKIT | CHECKED | MENUTOGGLE,	0,	(APTR) &tmobjectdata_POSITIVE},
  {NM_ITEM,  (UBYTE *)ITEMTEXT_WAIT,		NULL,	CHECKIT | CHECKED | MENUTOGGLE,	0,	(APTR) &tmobjectdata_WAIT},

  {NM_END,   NULL,	NULL,	0,	0,	NULL}
  };


struct TextAttr topaz8 =
  {
  (STRPTR)"topaz.font",
  8,
  FS_NORMAL,
  0x0
  };

/****** trans_tm.c/TM_Request *****************************
*
*   NAME
*	TM_Request -- display a message in a system requester.
*
*   SYNOPSIS
*	num = TM_Request(Window, Title, TextFormat, GadgetFormat,
*	                 IDCMP_ptr, Arg1, Arg2, ...)
*
*	LONG TM_Request(struct Window *, UBYTE *, UBYTE *, UBYTE *,
*	                ULONG *, APTR, ...);
*
*   FUNCTION
*	Calls EasyRequestArgs to display a message in a system
*	requester without having to fill in an EasyStruct structure.
*	This function uses a varargs calling convention.
*
*	EasyRequestArgs has the capability to display more than one
*	gadget by separating the GadgetText with the '|' character.
*	Also printf style formatting may be used in the TextFormat
*	and GadgetFormat strings.  The formatting arguments should
*	be added first for the TextFormat, then for the GadgetFormat.
*
*   INPUTS
*	Window = pointer to window (passed to EasyRequestArgs()).
*	Title = title bar string (passed to EasyRequestArgs()).
*	TextFormat = body text (passed to EasyRequestArgs()).
*	GadgetFormat = gadget text (passed to EasyRequestArgs()).
*	IDCMP_ptr = IDCMP value (passed to EasyRequestArgs()).
*	Args = arguments (passed to EasyRequestArgs()).
*
*   RESULT
*	num = gadget number returned by EasyRequestArgs().
*
*   EXAMPLE
*	To display a requester with two choices:
*
*	result = TM_Request(NULL, "Question", "Are you sure?",
*	                    "OK|Cancel", NULL, NULL);
*
*   NOTES
*	The intuition library must be open before calling this
*	function.
*
*   BUGS
*
*   SEE ALSO
*	intuition.library/EasyRequestArgs()
*
**************************************************************
*
*/
LONG TM_Request(struct Window *Window, UBYTE *Title, UBYTE *TextFormat, UBYTE *GadgetFormat, ULONG *IDCMP_ptr, APTR Arg1, ...)
  {
  struct EasyStruct es;

  es.es_StructSize = sizeof(struct EasyStruct);
  es.es_Flags = 0;
  es.es_Title = Title;
  es.es_TextFormat = TextFormat;
  es.es_GadgetFormat = GadgetFormat;

  return(EasyRequestArgs(Window, &es, IDCMP_ptr, &Arg1));
  }

/****** trans_tm.c/TM_Open *****************************
*
*   NAME
*	TM_Open -- initialize user-interface data.
*
*   SYNOPSIS
*	TMData = TM_Open(ErrorCode)
*
*	struct TMData *TM_Open(ULONG *error);
*
*   FUNCTION
*	Creates an initializes a TMData structure.  This
*	includes allocating memory for a TMData structure,
*	creating a message port for window IDCMP messages,
*	and opening any fonts on disk.
*
*   INPUTS
*	error = pointer to ULONG to store an error number.
*	        Error numbers are defined in the _tm.h file.
*
*   RESULT
*	TMData = pointer to an initialized TMData structure
*	         or NULL if an error occurred.
*
*   EXAMPLE
*	if(!(TMData = TM_Open(&error)))
*	  {
*	  switch(error)
*	    {
*	    case TMERR_MEMORY:
*	      TM_Request(NULL, "Error", "Out of memory", "Abort", NULL, NULL);
*	      break;
*	    case TMERR_MSGPORT:
*	      TM_Request(NULL, "Error", "Error creating\nmessage port", "Abort", NULL, NULL);
*	      break;
*	    }
*	  CleanExit(NULL, RETURN_FAIL);
*	  }
*
*   NOTES
*	The intuition and gadtools libraries must be open before
*	calling this function.  If any fonts other than topaz 8
*	and topaz 9 are used, the diskfont and graphics libraries
*	must also be open.
*
*   BUGS
*
*   SEE ALSO
*	TM_Close()
*
**************************************************************
*
*/
struct TMData *TM_Open(ULONG *error)
{
    struct TMData *tmdata;

    if(tmdata = AllocMem(sizeof(struct TMData), MEMF_CLEAR))
    {   tmdata->Size = sizeof(struct TMData);

        if(tmdata->WindowMsgPort = CreateMsgPort())
        {
            *error = TMERR_OK;
	        return(tmdata);
        }
        else
        {
            *error = TMERR_MSGPORT;
        }

        FreeMem(tmdata, sizeof(struct TMData));
    }
    else
    {
        *error = TMERR_MEMORY;
    }

    return(NULL);
}

/****** trans_tm.c/TM_Close *****************************
*
*   NAME
*	TM_Close -- frees user-interface data.
*
*   SYNOPSIS
*	TM_Close(TMData)
*
*	VOID TM_Close(struct TMData *TMData);
*
*   FUNCTION
*	Frees resources allocated by TM_Open().
*
*   INPUTS
*	TMData = pointer to TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*	if(TMData) TM_Close(TMData);
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	TM_Open()
*
**************************************************************
*
*/
VOID TM_Close(struct TMData *TMData)
  {

  if(TMData)
    {
    if(TMData->WindowMsgPort) DeleteMsgPort(TMData->WindowMsgPort);
    FreeMem(TMData, TMData->Size);
    }

  }

/****** trans_tm.c/TM_EventLoop *****************************
*
*   NAME
*	TM_EventLoop -- waits for all events.
*
*   SYNOPSIS
*	TM_EventLoop(TMData)
*
*	VOID TM_EventLoop(struct TMData *);
*
*   FUNCTION
*	Waits for any events to signal program.  All IDCMP, ARexx,
*	and a user signal messages received are sent to the
*	appropriate signal function.  A return value of TRUE from
*	any of the signal functions will terminate the loop.
*
*   INPUTS
*	TMData = pointer to TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*	TM_EventLoop(TMData);
*
*   NOTES
*	An event signal must be set up before calling TM_EventLoop.
*	Either a window must be open, the SimpleRexx option selected,
*	or a user signal set up.
*
*   BUGS
*
*   SEE ALSO
*	TM_WindowSignal(), TM_ARexxSignal(), exec.library/Wait()
*
**************************************************************
*
*/
VOID TM_EventLoop(struct TMData *TMData)
  {
  BOOL done=FALSE, result;
  ULONG windowsignal, signals;

  windowsignal = 1L << TMData->WindowMsgPort->mp_SigBit;

  while(!done)
    {
    signals = Wait(windowsignal | SIGBREAKF_CTRL_E | SIGBREAKF_CTRL_F);

    if(signals & windowsignal)
      {
      if(result = TM_WindowSignal(TMData)) done = result;
      }

    if(signals & (SIGBREAKF_CTRL_E|SIGBREAKF_CTRL_F))
      {
      	HandleSignal(TMData, signals);
      }
    }
  }

/****** trans_tm.c/OpenScreen_Workbench *****************************
*
*   NAME
*	OpenScreen_Workbench -- Use the default public screen.
*
*   SYNOPSIS
*	success = OpenScreen_Workbench(TMData)
*
*	BOOL OpenScreen_Workbench(struct TMData *);
*
*   FUNCTION
*	Locks the default public screen and gets its visual info.  If the
*	screen was already locked, it will be brought to front.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*	success = TRUE if command was successfully completed.
*	          FALSE if not.
*
*   EXAMPLE
*	if(!(OpenScreen_Workbench(TMData)))
*	  {
*	  TM_Request(NULL, "Error", "Error opening screen", "Abort", NULL, NULL);
*	  CleanExit(TMData, RETURN_FAIL);
*	  }
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	CloseScreen_Workbench()
*
**************************************************************
*
*/
BOOL OpenScreen_Workbench(struct TMData *TMData)
  {
  if(ScreenInfo_Workbench.Screen)
    {
    ScreenToFront(ScreenInfo_Workbench.Screen);
    return(TRUE);
    }
  else
    {
    if(ScreenInfo_Workbench.Screen = LockPubScreen(NULL))
      {
      if(ScreenInfo_Workbench.VisualInfo = GetVisualInfo(ScreenInfo_Workbench.Screen, TAG_DONE))
        {
        return(TRUE);
        }
      UnlockPubScreen(NULL, ScreenInfo_Workbench.Screen);
      }
    }

  return(FALSE);
  }

/****** trans_tm.c/CloseScreen_Workbench *****************************
*
*   NAME
*	CloseScreen_Workbench -- Free the default public screen.
*
*   SYNOPSIS
*	CloseScreen_Workbench(TMData)
*
*	VOID CloseScreen_Workbench(struct TMData *);
*
*   FUNCTION
*	Unlocks the default public screen and frees the visual info.
*	It's ok to re-close a screen that is already closed.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*	CloseScreen_Workbench(TMData);
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	OpenScreen_Workbench()
*
**************************************************************
*
*/
VOID CloseScreen_Workbench(struct TMData *TMData)
  {
  if(ScreenInfo_Workbench.VisualInfo)
    {
    FreeVisualInfo(ScreenInfo_Workbench.VisualInfo);
    ScreenInfo_Workbench.VisualInfo = NULL;
    }
  if(ScreenInfo_Workbench.Screen)
    {
    UnlockPubScreen(NULL, ScreenInfo_Workbench.Screen);
    ScreenInfo_Workbench.Screen = NULL;
    }
  }

/****** trans_tm.c/OpenWindow_TRANSP *****************************
*
*   NAME
*	OpenWindow_TRANSP -- Open window "TRANSP".
*
*   SYNOPSIS
*	success = OpenWindow_TRANSP(TMData)
*
*	BOOL OpenWindow_TRANSP(struct TMData *);
*
*   FUNCTION
*	Opens the window with label "TRANSP"
*	along with any gadgets it contains.  If the window was already
*	open, it will be brought to front.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*	success = TRUE if command was successfully completed.
*	          FALSE if not.
*
*   EXAMPLE
*	if(!OpenWindow_TRANSP(TMData))
*	  {
*	  TMRequest(NULL, "Error", "Error opening window", "Abort", NULL, NULL);
*	  CleanExit(TMData, RETURN_FAIL);
*	  }
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	CloseWindow_TRANSP()
*
**************************************************************
*
*/
BOOL OpenWindow_TRANSP(struct TMData *TMData)
  {
  ULONG lasttag;
  struct NewGadget ng;

  if(WindowInfo_TRANSP.Window)
    {
    WindowToFront(WindowInfo_TRANSP.Window);
    ActivateWindow(WindowInfo_TRANSP.Window);
    return(TRUE);
    }
  else
    {	extern Class	*box_class;

		/* create the BOOPSI images */

		Image_CLOCK = (struct Image *)NewObject(box_class,NULL,
					IA_Width,		125,
					IA_Height,		24,
					BOX_Filled, 	FALSE,
					BOX_ThickBevel, TRUE,
					BOX_PushesIn, 	FALSE,
					TAG_END );

		Image_PLAY = (struct Image *)NewObject(box_class,NULL,
					IA_Width,		48,
					IA_Height,		15,
					BOX_Filled, 	TRUE,
					BOX_ThickBevel, TRUE,
					BOX_PushesIn, 	TRUE,
					BOX_GlyphData,	play_glyph.data,
					BOX_GlyphWidth,	play_glyph.w,
					BOX_GlyphHeight,play_glyph.h,
					TAG_END );

		Image_STOP = (struct Image *)NewObject(box_class,NULL,
					IA_Width,		51,
					IA_Height,		15,
					BOX_Filled, 	TRUE,
					BOX_ThickBevel, TRUE,
					BOX_PushesIn, 	TRUE,
					BOX_GlyphData,	stop_glyph.data,
					BOX_GlyphWidth,	stop_glyph.w,
					BOX_GlyphHeight,stop_glyph.h,
					TAG_END );

		Image_REW = (struct Image *)NewObject(box_class,NULL,
					IA_Width,		27,
					IA_Height,		15,
					BOX_Filled, 	TRUE,
					BOX_ThickBevel, TRUE,
					BOX_PushesIn, 	TRUE,
					BOX_GlyphData,	rew_glyph.data,
					BOX_GlyphWidth,	rew_glyph.w,
					BOX_GlyphHeight,rew_glyph.h,
					TAG_END );

		Image_FF = (struct Image *)NewObject(box_class,NULL,
					IA_Width,		27,
					IA_Height,		15,
					BOX_Filled, 	TRUE,
					BOX_ThickBevel, TRUE,
					BOX_PushesIn, 	TRUE,
					BOX_GlyphData,	ff_glyph.data,
					BOX_GlyphWidth,	ff_glyph.w,
					BOX_GlyphHeight,ff_glyph.h,
					TAG_END );

		Image_PAUSE = (struct Image *)NewObject(box_class,NULL,
					IA_Width,		48,
					IA_Height,		15,
					BOX_Filled, 	TRUE,
					BOX_ThickBevel, TRUE,
					BOX_PushesIn, 	TRUE,
					BOX_GlyphData,	pause_glyph.data,
					BOX_GlyphWidth,	pause_glyph.w,
					BOX_GlyphHeight,pause_glyph.h,
					TAG_END );

    WindowInfo_TRANSP.FirstGadget = NULL;
    WindowInfo_TRANSP.ContextGadget = CreateContext(&WindowInfo_TRANSP.FirstGadget);

    ng.ng_VisualInfo = ScreenInfo_Workbench.VisualInfo;

    ng.ng_LeftEdge = 8;
    ng.ng_TopEdge = 3+ScreenInfo_Workbench.Screen->BarHeight;
    ng.ng_Width = 27;
    ng.ng_Height = 15;
    ng.ng_Flags = PLACETEXT_IN;
    ng.ng_TextAttr = &topaz8;
    ng.ng_GadgetText = NULL;
    ng.ng_GadgetID = ID_REW;
    ng.ng_UserData = (APTR) &tmobjectdata_REW;
    lasttag = GadgetInfo_REW.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_REW.Gadget = CreateGadget(GENERIC_KIND, WindowInfo_TRANSP.ContextGadget, &ng,
		lasttag, GadgetInfo_REW.MoreTags);

	GadgetInfo_REW.Gadget->GadgetRender =
		GadgetInfo_REW.Gadget->SelectRender = (APTR)Image_REW;
	GadgetInfo_REW.Gadget->Flags = GFLG_GADGIMAGE | GFLG_GADGHIMAGE;
	GadgetInfo_REW.Gadget->Activation |= GACT_RELVERIFY|GACT_IMMEDIATE;

    ng.ng_TopEdge = 19+ScreenInfo_Workbench.Screen->BarHeight;
    ng.ng_Width = 125;
    ng.ng_Height = 24;
    ng.ng_GadgetText = NULL;
    ng.ng_GadgetID = ID_CLOCK;
    ng.ng_UserData = (APTR) &tmobjectdata_CLOCK;
    lasttag = GadgetInfo_CLOCK.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_CLOCK.Gadget = CreateGadget(GENERIC_KIND, GadgetInfo_REW.Gadget, &ng,
		lasttag, GadgetInfo_CLOCK.MoreTags);

	GadgetInfo_CLOCK.Gadget->GadgetRender =
		GadgetInfo_CLOCK.Gadget->SelectRender = (APTR)Image_CLOCK;
	GadgetInfo_CLOCK.Gadget->Flags = GFLG_GADGIMAGE | GFLG_GADGHIMAGE;
	GadgetInfo_CLOCK.Gadget->Activation |= GACT_RELVERIFY|GACT_IMMEDIATE;

    ng.ng_LeftEdge = 35;
    ng.ng_TopEdge = 3+ScreenInfo_Workbench.Screen->BarHeight;
    ng.ng_Width = 48;
    ng.ng_Height = 15;
    ng.ng_GadgetText = NULL;
    ng.ng_GadgetID = ID_PLAY;
    ng.ng_UserData = (APTR) &tmobjectdata_PLAY;
    lasttag = GadgetInfo_PLAY.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_PLAY.Gadget = CreateGadget(GENERIC_KIND, GadgetInfo_CLOCK.Gadget, &ng,
		lasttag, GadgetInfo_PLAY.MoreTags);

	GadgetInfo_PLAY.Gadget->GadgetRender =
		GadgetInfo_PLAY.Gadget->SelectRender = (APTR)Image_PLAY;
	GadgetInfo_PLAY.Gadget->Flags = GFLG_GADGIMAGE | GFLG_GADGHIMAGE;
	GadgetInfo_PLAY.Gadget->Activation |= GACT_RELVERIFY|GACT_TOGGLESELECT;

    ng.ng_LeftEdge = 83;
    ng.ng_Width = 27;
    ng.ng_GadgetText = NULL;
    ng.ng_GadgetID = ID_FF;
    ng.ng_UserData = (APTR) &tmobjectdata_FF;
    lasttag = GadgetInfo_FF.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_FF.Gadget = CreateGadget(GENERIC_KIND, GadgetInfo_PLAY.Gadget, &ng,
		lasttag, GadgetInfo_FF.MoreTags);

	GadgetInfo_FF.Gadget->GadgetRender =
		GadgetInfo_FF.Gadget->SelectRender = (APTR)Image_FF;
	GadgetInfo_FF.Gadget->Flags = GFLG_GADGIMAGE | GFLG_GADGHIMAGE;
	GadgetInfo_FF.Gadget->Activation |= GACT_RELVERIFY|GACT_IMMEDIATE;

    ng.ng_LeftEdge = 110;
    ng.ng_Width = 51;
    ng.ng_GadgetText = NULL;
    ng.ng_GadgetID = ID_STOP;
    ng.ng_UserData = (APTR) &tmobjectdata_STOP;
    lasttag = GadgetInfo_STOP.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_STOP.Gadget = CreateGadget(GENERIC_KIND, GadgetInfo_FF.Gadget, &ng,
		lasttag, GadgetInfo_STOP.MoreTags);

	GadgetInfo_STOP.Gadget->GadgetRender =
		GadgetInfo_STOP.Gadget->SelectRender = (APTR)Image_STOP;
	GadgetInfo_STOP.Gadget->Flags = GFLG_GADGIMAGE | GFLG_GADGHIMAGE;
	GadgetInfo_STOP.Gadget->Activation |= GACT_RELVERIFY|GACT_TOGGLESELECT;

    ng.ng_LeftEdge = 136;
    ng.ng_TopEdge = 31+ScreenInfo_Workbench.Screen->BarHeight;
    ng.ng_Width = 76;
    ng.ng_Height = 12;
    ng.ng_Flags = PLACETEXT_ABOVE;
    ng.ng_GadgetText = (UBYTE *)GADGETTEXT_STATUS;
    ng.ng_GadgetID = 0;
    ng.ng_UserData = NULL;
    lasttag = GadgetInfo_STATUS.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_STATUS.Gadget = CreateGadget(TEXT_KIND, GadgetInfo_STOP.Gadget, &ng,
		GTTX_Border, TRUE,
		GTTX_Text, GTTX_Text_STATUS,
		lasttag, GadgetInfo_STATUS.MoreTags);

    ng.ng_LeftEdge = 164;
    ng.ng_TopEdge = 3+ScreenInfo_Workbench.Screen->BarHeight;
    ng.ng_Width = 48;
    ng.ng_Height = 15;
    ng.ng_Flags = PLACETEXT_IN;
    ng.ng_GadgetText = NULL;
    ng.ng_GadgetID = ID_PAUSE;
    ng.ng_UserData = (APTR) &tmobjectdata_PAUSE;
    lasttag = GadgetInfo_PAUSE.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_PAUSE.Gadget = CreateGadget(GENERIC_KIND, GadgetInfo_STATUS.Gadget, &ng,
		lasttag, GadgetInfo_PAUSE.MoreTags);

	GadgetInfo_PAUSE.Gadget->GadgetRender =
		GadgetInfo_PAUSE.Gadget->SelectRender = (APTR)Image_PAUSE;
	GadgetInfo_PAUSE.Gadget->Flags = GFLG_GADGIMAGE | GFLG_GADGHIMAGE;
	GadgetInfo_PAUSE.Gadget->Activation |= GACT_RELVERIFY|GACT_TOGGLESELECT;

    if(GadgetInfo_PAUSE.Gadget)
      {
      lasttag = WindowInfo_TRANSP.MoreTags ? TAG_MORE : TAG_DONE;

      if((WindowInfo_TRANSP.Window = OpenWindowTags(NULL,
		WA_PubScreen, ScreenInfo_Workbench.Screen,
		WA_Title, WINDOWTEXT_TRANSP,
		WA_IDCMP, NULL,
		WA_Gadgets, WindowInfo_TRANSP.FirstGadget,
		WA_Left, 135,
		WA_Top, 36,
		WA_InnerWidth, 214,
		WA_InnerHeight, 44,
		WA_AutoAdjust, TRUE,
		WA_DragBar, TRUE,
		WA_CloseGadget, TRUE,
		WA_DepthGadget, TRUE,
		WA_Activate, TRUE,
		WA_ScreenTitle, WA_ScreenTitle_TRANSP,
		WA_SimpleRefresh, TRUE,
		lasttag, WindowInfo_TRANSP.MoreTags)))
        {
        if((WindowInfo_TRANSP.Menu = CreateMenus(newmenu_TRANSP, TAG_DONE)))
          {
          if((LayoutMenus(WindowInfo_TRANSP.Menu, ScreenInfo_Workbench.VisualInfo, TAG_DONE)))
            {
            if((SetMenuStrip(WindowInfo_TRANSP.Window, WindowInfo_TRANSP.Menu)))
              {
              WindowInfo_TRANSP.Window->UserPort = TMData->WindowMsgPort;
              ModifyIDCMP(WindowInfo_TRANSP.Window,
			IDCMP_REFRESHWINDOW |
			BUTTONIDCMP |
			IDCMP_MOUSEMOVE |
			IDCMP_MOUSEBUTTONS |
			IDCMP_GADGETDOWN |
			IDCMP_GADGETUP |
			IDCMP_MENUPICK |
			IDCMP_CLOSEWINDOW |
			IDCMP_INTUITICKS |
			IDCMP_IDCMPUPDATE);
              GT_RefreshWindow(WindowInfo_TRANSP.Window, NULL);
              WindowInfo_TRANSP.Flags |= TMWF_OPENED;

			  RefreshWindow_TRANSP(TMData);

              return(TRUE);
              }
            }
          FreeMenus(WindowInfo_TRANSP.Menu);
          }
        CloseWindow(WindowInfo_TRANSP.Window);
        }
      FreeGadgets(WindowInfo_TRANSP.FirstGadget);
      }
    }
  return(FALSE);
  }

/****** trans_tm.c/CloseWindow_TRANSP *****************************
*
*   NAME
*	CloseWindow_TRANSP -- Close window "TRANSP".
*
*   SYNOPSIS
*	CloseWindow_TRANSP(TMData)
*
*	VOID CloseWindow_TRANSP(struct TMData *);
*
*   FUNCTION
*	Closes the window with label "TRANSP"
*	and frees its resources.  It's ok to re-close a window
*	that is already closed.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	OpenWindow_TRANSP()
*
**************************************************************
*
*/
VOID CloseWindow_TRANSP(struct TMData *TMData)
  {
  TM_RemoveWindow(&WindowInfo_TRANSP);

	if (Image_CLOCK) { DisposeObject (Image_CLOCK); Image_CLOCK = NULL; }
	if (Image_PLAY)  { DisposeObject (Image_PLAY); Image_PLAY = NULL; }
	if (Image_STOP)  { DisposeObject (Image_STOP); Image_STOP = NULL; }
	if (Image_REW)   { DisposeObject (Image_REW); Image_REW = NULL; }
	if (Image_FF)    { DisposeObject (Image_FF); Image_FF = NULL; }
	if (Image_PAUSE) { DisposeObject (Image_PAUSE); Image_PAUSE = NULL; }
  }

/****** trans_tm.c/DisableWindow_TRANSP *****************************
*
*   NAME
*	DisableWindow_TRANSP -- disable input to window "TRANSP".
*
*   SYNOPSIS
*	DisableWindow_TRANSP(TMData)
*
*	VOID DisableWindow_TRANSP(struct TMData *);
*
*   FUNCTION
*	Disables all input to window with label "TRANSP"
*	and changes its mouse pointer.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	EnableWindow_TRANSP()
*
**************************************************************
*
*/
VOID DisableWindow_TRANSP(struct TMData *TMData)
  {
  if((WindowInfo_TRANSP.DisableCount == 0) && (WindowInfo_TRANSP.Flags & TMWF_OPENED))
    {
    InitRequester(&WindowInfo_TRANSP.Requester);
    if(Request(&WindowInfo_TRANSP.Requester, WindowInfo_TRANSP.Window))
      {
      WindowInfo_TRANSP.Flags |= TMWF_DISABLED;
      SetPointer(WindowInfo_TRANSP.Window, WaitPointer, 16, 16, -6, 0);
      }
    }
  WindowInfo_TRANSP.DisableCount++;
  }

/****** trans_tm.c/EnableWindow_TRANSP *****************************
*
*   NAME
*	EnableWindow_TRANSP -- enable input to window "TRANSP".
*
*   SYNOPSIS
*	EnableWindow_TRANSP(TMData)
*
*	VOID EnableWindow_TRANSP(struct TMData *);
*
*   FUNCTION
*	Enables input to window with label "TRANSP"
*	and clears its mouse pointer.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	DisableWindow_TRANSP()
*
**************************************************************
*
*/
VOID EnableWindow_TRANSP(struct TMData *TMData)
  {
  WindowInfo_TRANSP.DisableCount--;
  if((WindowInfo_TRANSP.DisableCount == 0) && (WindowInfo_TRANSP.Flags & (TMWF_DISABLED | TMWF_OPENED)))
    {
    EndRequest(&WindowInfo_TRANSP.Requester, WindowInfo_TRANSP.Window);
    WindowInfo_TRANSP.Flags &= ~TMWF_DISABLED;
    ClearPointer(WindowInfo_TRANSP.Window);
    }
  }

/****** trans_tm.c/OpenWindow_SELECTCO *****************************
*
*   NAME
*	OpenWindow_SELECTCO -- Open window "SELECTCO".
*
*   SYNOPSIS
*	success = OpenWindow_SELECTCO(TMData)
*
*	BOOL OpenWindow_SELECTCO(struct TMData *);
*
*   FUNCTION
*	Opens the window with label "SELECTCO"
*	along with any gadgets it contains.  If the window was already
*	open, it will be brought to front.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*	success = TRUE if command was successfully completed.
*	          FALSE if not.
*
*   EXAMPLE
*	if(!OpenWindow_SELECTCO(TMData))
*	  {
*	  TMRequest(NULL, "Error", "Error opening window", "Abort", NULL, NULL);
*	  CleanExit(TMData, RETURN_FAIL);
*	  }
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	CloseWindow_SELECTCO()
*
**************************************************************
*
*/
BOOL OpenWindow_SELECTCO(struct TMData *TMData)
  {
  ULONG lasttag;
  struct NewGadget ng;

	GetConductorList( &CDTList );

  if(WindowInfo_SELECTCO.Window)
    {
    WindowToFront(WindowInfo_SELECTCO.Window);
    ActivateWindow(WindowInfo_SELECTCO.Window);
    return(TRUE);
    }
  else
    {
    WindowInfo_SELECTCO.FirstGadget = NULL;
    WindowInfo_SELECTCO.ContextGadget = CreateContext(&WindowInfo_SELECTCO.FirstGadget);

    ng.ng_VisualInfo = ScreenInfo_Workbench.VisualInfo;

    ng.ng_TextAttr = &topaz8;
    ng.ng_TopEdge = 79+ScreenInfo_Workbench.Screen->BarHeight;
    ng.ng_LeftEdge = 8;
    ng.ng_Width = 198;
    ng.ng_Height = 12;
    ng.ng_Flags = PLACETEXT_LEFT;
    ng.ng_GadgetText = (UBYTE *)GADGETTEXT_NEWCON;
    ng.ng_GadgetID = ID_NEWCON;
    ng.ng_UserData = (APTR) &tmobjectdata_NEWCON;
    lasttag = GadgetInfo_NEWCON.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_NEWCON.Gadget = CreateGadget(STRING_KIND, WindowInfo_SELECTCO.ContextGadget, &ng,
	/*	GTST_String, GTST_String_NEWCON, */
		GTST_MaxChars, 32,
		lasttag, GadgetInfo_NEWCON.MoreTags);

    ng.ng_TopEdge = 3+ScreenInfo_Workbench.Screen->BarHeight;
    ng.ng_Height = 80;
    ng.ng_Flags = PLACETEXT_ABOVE;
    ng.ng_GadgetText = (UBYTE *)GADGETTEXT_CLIST;
    ng.ng_GadgetID = ID_CLIST;
    ng.ng_UserData = (APTR) &tmobjectdata_CLIST;
    lasttag = GadgetInfo_CLIST.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_CLIST.Gadget = CreateGadget(LISTVIEW_KIND, GadgetInfo_NEWCON.Gadget, &ng,
	/*	GTLV_ShowSelected, &GadgetInfo_NEWCON.Gadget, */
		GTLV_Labels, &CDTList,
		lasttag, GadgetInfo_CLIST.MoreTags);

    ng.ng_TopEdge = 93+ScreenInfo_Workbench.Screen->BarHeight;
    ng.ng_Width = 90;
    ng.ng_Height = 14;
    ng.ng_Flags = PLACETEXT_IN;
    ng.ng_GadgetText = (UBYTE *)GADGETTEXT_SELECT;
    ng.ng_GadgetID = ID_SELECT;
    ng.ng_UserData = (APTR) &tmobjectdata_SELECT;
    lasttag = GadgetInfo_SELECT.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_SELECT.Gadget = CreateGadget(BUTTON_KIND, GadgetInfo_CLIST.Gadget, &ng,
		lasttag, GadgetInfo_SELECT.MoreTags);

    ng.ng_LeftEdge = 116;
    ng.ng_GadgetText = (UBYTE *)GADGETTEXT_CANCEL;
    ng.ng_GadgetID = ID_CANCEL;
    ng.ng_UserData = (APTR) &tmobjectdata_CANCEL;
    lasttag = GadgetInfo_CANCEL.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_CANCEL.Gadget = CreateGadget(BUTTON_KIND, GadgetInfo_SELECT.Gadget, &ng,
		lasttag, GadgetInfo_CANCEL.MoreTags);

    if(GadgetInfo_CANCEL.Gadget)
      {
      lasttag = WindowInfo_SELECTCO.MoreTags ? TAG_MORE : TAG_DONE;

      if((WindowInfo_SELECTCO.Window = OpenWindowTags(NULL,
		WA_PubScreen, ScreenInfo_Workbench.Screen,
		WA_Title, WINDOWTEXT_SELECTCO,
		WA_IDCMP, NULL,
		WA_Gadgets, WindowInfo_SELECTCO.FirstGadget,
		WA_Left, 138,
		WA_Top, 96,
		WA_InnerWidth, 207,
		WA_InnerHeight, 108,
		WA_AutoAdjust, TRUE,
		WA_DragBar, TRUE,
		WA_DepthGadget, TRUE,
		WA_Activate, TRUE,
		WA_SimpleRefresh, TRUE,
		lasttag, WindowInfo_SELECTCO.MoreTags)))
        {
        WindowInfo_SELECTCO.Window->UserPort = TMData->WindowMsgPort;
        ModifyIDCMP(WindowInfo_SELECTCO.Window,
			IDCMP_REFRESHWINDOW |
			LISTVIEWIDCMP |
			STRINGIDCMP |
			BUTTONIDCMP |
			IDCMP_GADGETDOWN |
			IDCMP_GADGETUP |
			IDCMP_CLOSEWINDOW);
        GT_RefreshWindow(WindowInfo_SELECTCO.Window, NULL);
        WindowInfo_SELECTCO.Flags |= TMWF_OPENED;
		ShowConductorName( TMData );
        return(TRUE);
        }
      FreeGadgets(WindowInfo_SELECTCO.FirstGadget);
      }
    }
  return(FALSE);
  }

/****** trans_tm.c/CloseWindow_SELECTCO *****************************
*
*   NAME
*	CloseWindow_SELECTCO -- Close window "SELECTCO".
*
*   SYNOPSIS
*	CloseWindow_SELECTCO(TMData)
*
*	VOID CloseWindow_SELECTCO(struct TMData *);
*
*   FUNCTION
*	Closes the window with label "SELECTCO"
*	and frees its resources.  It's ok to re-close a window
*	that is already closed.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	OpenWindow_SELECTCO()
*
**************************************************************
*
*/
VOID CloseWindow_SELECTCO(struct TMData *TMData)
  {
  TM_RemoveWindow(&WindowInfo_SELECTCO);
  EnableWindow_TRANSP(TMData);
	FreeConductorList( &CDTList );
  }

/****** trans_tm.c/DisableWindow_SELECTCO *****************************
*
*   NAME
*	DisableWindow_SELECTCO -- disable input to window "SELECTCO".
*
*   SYNOPSIS
*	DisableWindow_SELECTCO(TMData)
*
*	VOID DisableWindow_SELECTCO(struct TMData *);
*
*   FUNCTION
*	Disables all input to window with label "SELECTCO"
*	and changes its mouse pointer.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	EnableWindow_SELECTCO()
*
**************************************************************
*
*/
VOID DisableWindow_SELECTCO(struct TMData *TMData)
  {
  if((WindowInfo_SELECTCO.DisableCount == 0) && (WindowInfo_SELECTCO.Flags & TMWF_OPENED))
    {
    InitRequester(&WindowInfo_SELECTCO.Requester);
    if(Request(&WindowInfo_SELECTCO.Requester, WindowInfo_SELECTCO.Window))
      {
      WindowInfo_SELECTCO.Flags |= TMWF_DISABLED;
      SetPointer(WindowInfo_SELECTCO.Window, WaitPointer, 16, 16, -6, 0);
      }
    }
  WindowInfo_SELECTCO.DisableCount++;
  }

/****** trans_tm.c/EnableWindow_SELECTCO *****************************
*
*   NAME
*	EnableWindow_SELECTCO -- enable input to window "SELECTCO".
*
*   SYNOPSIS
*	EnableWindow_SELECTCO(TMData)
*
*	VOID EnableWindow_SELECTCO(struct TMData *);
*
*   FUNCTION
*	Enables input to window with label "SELECTCO"
*	and clears its mouse pointer.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	DisableWindow_SELECTCO()
*
**************************************************************
*
*/
VOID EnableWindow_SELECTCO(struct TMData *TMData)
  {
  WindowInfo_SELECTCO.DisableCount--;
  if((WindowInfo_SELECTCO.DisableCount == 0) && (WindowInfo_SELECTCO.Flags & (TMWF_DISABLED | TMWF_OPENED)))
    {
    EndRequest(&WindowInfo_SELECTCO.Requester, WindowInfo_SELECTCO.Window);
    WindowInfo_SELECTCO.Flags &= ~TMWF_DISABLED;
    ClearPointer(WindowInfo_SELECTCO.Window);
    }
  }

static BOOL TM_WindowSignal(struct TMData *TMData)
  {
  BOOL done=FALSE;
  BOOL result;
  struct IntuiMessage *imessage;

  while(imessage = GT_GetIMsg(TMData->WindowMsgPort))
    {
    if(imessage->IDCMPWindow == WindowInfo_TRANSP.Window)
      {
      WindowInfo_TRANSP.GT_IMsg = imessage;
      if(result = WindowIDCMP_TRANSP(TMData, imessage)) done = result;
      if(WindowInfo_TRANSP.GT_IMsg)
        {
        GT_ReplyIMsg(WindowInfo_TRANSP.GT_IMsg);
        WindowInfo_TRANSP.GT_IMsg = NULL;
        }
      }
    else if(imessage->IDCMPWindow == WindowInfo_SELECTCO.Window)
      {
      WindowInfo_SELECTCO.GT_IMsg = imessage;
      if(result = WindowIDCMP_SELECTCO(TMData, imessage)) done = result;
      if(WindowInfo_SELECTCO.GT_IMsg)
        {
        GT_ReplyIMsg(WindowInfo_SELECTCO.GT_IMsg);
        WindowInfo_SELECTCO.GT_IMsg = NULL;
        }
      }
    }

  return(done);
  }

static BOOL WindowIDCMP_TRANSP(struct TMData *TMData, struct IntuiMessage *imessage)
  {
  BOOL done=FALSE;
  BOOL result;

  switch(imessage->Class)
    {
    case IDCMP_REFRESHWINDOW:
      GT_BeginRefresh(WindowInfo_TRANSP.Window);

	  RefreshWindow_TRANSP(TMData);

      GT_EndRefresh(WindowInfo_TRANSP.Window, TRUE);
      break;

    case IDCMP_MENUPICK:
      if(result = Window_TRANSP_MENUPICK(TMData, imessage)) done = result;
      break;

    case IDCMP_GADGETDOWN:
      if(result = Window_TRANSP_GADGETDOWN(TMData, imessage)) done = result;
      break;

    case IDCMP_GADGETUP:
      if(result = Window_TRANSP_GADGETUP(TMData, imessage)) done = result;
      break;

    case IDCMP_CLOSEWINDOW:
      if(result = Window_TRANSP_CLOSEWINDOW(TMData, imessage)) done = result;
      break;

    case IDCMP_MOUSEMOVE:
      if(result = Window_TRANSP_MOUSEMOVE(TMData, imessage)) done = result;
      break;

    case IDCMP_MOUSEBUTTONS:
      if(result = Window_TRANSP_MOUSEUP(TMData, imessage)) done = result;
      break;

    case IDCMP_INTUITICKS:
      if(result = Window_TRANSP_INTUITICKS(TMData, imessage)) done = result;
      break;

    case IDCMP_IDCMPUPDATE:
      if(result = Window_TRANSP_IDCMPUPDATE(TMData, imessage)) done = result;
      break;

    }

  return(done);
  }

static BOOL WindowIDCMP_SELECTCO(struct TMData *TMData, struct IntuiMessage *imessage)
  {
  BOOL done=FALSE;
  BOOL result;

  switch(imessage->Class)
    {
    case IDCMP_REFRESHWINDOW:
      GT_BeginRefresh(WindowInfo_SELECTCO.Window);
      GT_EndRefresh(WindowInfo_SELECTCO.Window, TRUE);
      break;

    case IDCMP_GADGETDOWN:
      if(result = Window_SELECTCO_GADGETDOWN(TMData, imessage)) done = result;
      break;

    case IDCMP_GADGETUP:
      if(result = Window_SELECTCO_GADGETUP(TMData, imessage)) done = result;
      break;

    case IDCMP_CLOSEWINDOW:
      if(result = Window_SELECTCO_CLOSEWINDOW(TMData, imessage)) done = result;
      break;

    }

  return(done);
  }

static VOID TM_RemoveWindow(struct TMWindowInfo *TMWindowInfo)
  {
  struct IntuiMessage *imessage;
  struct Node *succ;

  if(TMWindowInfo->Window)
    {
    if(TMWindowInfo->Menu)
      {
      ClearMenuStrip(TMWindowInfo->Window);
      FreeMenus(TMWindowInfo->Menu);
      TMWindowInfo->Menu = NULL;
      }

    if(TMWindowInfo->GT_IMsg)
      {
      GT_ReplyIMsg(TMWindowInfo->GT_IMsg);
      TMWindowInfo->GT_IMsg = NULL;
      }

    if(TMWindowInfo->Window->UserPort)
      {
      Forbid();
      imessage = (struct IntuiMessage *) TMWindowInfo->Window->UserPort->mp_MsgList.lh_Head;
      while(succ = imessage->ExecMessage.mn_Node.ln_Succ)
        {
        if(imessage->IDCMPWindow == TMWindowInfo->Window)
          {
          Remove((struct Node *) imessage);
          ReplyMsg((struct Message *) imessage);
          }
        imessage = (struct IntuiMessage *) succ;
        }
      TMWindowInfo->Window->UserPort = NULL;
      ModifyIDCMP(TMWindowInfo->Window, 0L);
      Permit();
      }

    CloseWindow(TMWindowInfo->Window);
    TMWindowInfo->Window = NULL;
    TMWindowInfo->Flags = 0;
    }

  if(TMWindowInfo->FirstGadget)
    {
    FreeGadgets(TMWindowInfo->FirstGadget);
    TMWindowInfo->FirstGadget = NULL;
    }
  }

