
/* Events source file */

#include <exec/types.h>
#include <intuition/intuition.h>
#include <libraries/asl.h>

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/gadtools_protos.h>

#include <pragmas/exec_pragmas.h>
#include <pragmas/intuition_pragmas.h>
#include <pragmas/gadtools_pragmas.h>

#include "trans.h"

BOOL EventFunc_SETCONDU(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_ABOUT(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_QUIT(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_REW(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_CLOCK(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_PLAY(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_FF(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_STOP(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_PAUSE(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_CLIST(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_NEWCON(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_SELECT(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_CANCEL(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);

BOOL EventFunc_RESETTOZ(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_NTSCNOND(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_NTSCDROP(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_PAL25FPS(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_FILM24FP(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_POSITIVE(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);
BOOL EventFunc_WAIT(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);

TMOBJECTDATA tmobjectdata_SETCONDU = { EventFunc_SETCONDU };
TMOBJECTDATA tmobjectdata_ABOUT = { EventFunc_ABOUT };
TMOBJECTDATA tmobjectdata_QUIT = { EventFunc_QUIT };

TMOBJECTDATA tmobjectdata_REW = { EventFunc_REW };
TMOBJECTDATA tmobjectdata_CLOCK = { EventFunc_CLOCK };
TMOBJECTDATA tmobjectdata_PLAY = { EventFunc_PLAY };
TMOBJECTDATA tmobjectdata_FF = { EventFunc_FF };
TMOBJECTDATA tmobjectdata_STOP = { EventFunc_STOP };
TMOBJECTDATA tmobjectdata_PAUSE = { EventFunc_PAUSE };
TMOBJECTDATA tmobjectdata_CLIST = { EventFunc_CLIST };
TMOBJECTDATA tmobjectdata_NEWCON = { EventFunc_NEWCON };
TMOBJECTDATA tmobjectdata_SELECT = { EventFunc_SELECT };
TMOBJECTDATA tmobjectdata_CANCEL = { EventFunc_CANCEL };

TMOBJECTDATA tmobjectdata_RESETTOZ = { EventFunc_RESETTOZ };
TMOBJECTDATA tmobjectdata_NTSCNOND = { EventFunc_NTSCNOND };
TMOBJECTDATA tmobjectdata_NTSCDROP = { EventFunc_NTSCDROP };
TMOBJECTDATA tmobjectdata_PAL25FPS = { EventFunc_PAL25FPS };
TMOBJECTDATA tmobjectdata_FILM24FP = { EventFunc_FILM24FP };
TMOBJECTDATA tmobjectdata_POSITIVE = { EventFunc_POSITIVE };
TMOBJECTDATA tmobjectdata_WAIT = { EventFunc_WAIT };

extern LONG				current_time;

extern WORD				drag_state,
						drag_delay,
						drag_accum;

UWORD __chip BlankPointer[36] =
  {
  0x0000, 0x0000,
  0x0000, 0x0000,
  };

BOOL EventFunc_SETCONDU(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {

  if(!(OpenWindow_SELECTCO(TMData)))
    {
    TM_Request(NULL, (UBYTE *)TEXT_ERROR, (UBYTE *)TEXT_NOWINDOW, (UBYTE *)TEXT_ABORT, NULL, NULL);
    cleanexit(TMData, RETURN_FAIL);
    }
	else
	  DisableWindow_TRANSP(TMData);

  return(FALSE);
  }

BOOL EventFunc_ABOUT(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {

  TM_Request(imsg->IDCMPWindow, "Program Information",
  			"Conductor Controller\n1992 Sylvan Tecnical Arts\nWritten By Talin",
  			"Continue", NULL, NULL);

  return(FALSE);
  }

BOOL EventFunc_QUIT(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  return(TRUE);
  }

BOOL EventFunc_REW(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  	if (imsg->Class == GADGETDOWN)
	{	StopState(TMData);
		current_time -= 600;
		DrawTimeControl(TMData);
		drag_state = DRAG_REW;
		drag_delay = 3;
	}

	return(FALSE);
  }

BOOL EventFunc_FF(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  	if (imsg->Class == GADGETDOWN)
	{	StopState(TMData);
		current_time += 600;
		DrawTimeControl(TMData);
		drag_state = DRAG_FF;
		drag_delay = 3;
	}

	return(FALSE);
  }

BOOL EventFunc_CLOCK(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
{	struct Window *w = imsg->IDCMPWindow;

  	if (imsg->Class == GADGETDOWN)
  	{	WORD		mx, my;

  		StopState(TMData);

  		mx = imsg->MouseX - GadgetInfo_CLOCK.Gadget->LeftEdge;
  		my = imsg->MouseY - GadgetInfo_CLOCK.Gadget->TopEdge;

  		if (my >= 1 && my <= 15)
  		{	WORD		selected = (mx - 2) / 15;
			extern WORD	selected_digit;

  			if (selected >= 0 && selected < 8)
  			{	drag_state = DRAG_DIGIT;
  				drag_accum = 0;
  				selected_digit = selected;
				DrawTimeControl(TMData);
				ModifyIDCMP(w, w->IDCMPFlags | IDCMP_DELTAMOVE);
				w->Flags |= WFLG_REPORTMOUSE;
		        SetPointer(w, BlankPointer, 0, 16, -6, 0);
  			}
  		}
  	}
  	else if (imsg->Class == GADGETUP || (imsg->Class == MOUSEBUTTONS && imsg->Code == SELECTUP))
  	{	selected_digit = -1;
  		drag_state = DRAG_NONE;
		DrawTimeControl(TMData);
		ModifyIDCMP(w, w->IDCMPFlags & ~IDCMP_DELTAMOVE);
		w->Flags &=~WFLG_REPORTMOUSE;
		ClearPointer(w);
  	}

  return(FALSE);
  }

BOOL EventFunc_PLAY(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {

	PlayState(TMData);
  return(FALSE);
  }

BOOL EventFunc_STOP(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
	StopState(TMData);
  return(FALSE);
  }

BOOL EventFunc_PAUSE(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
		/* REM: This should only be allowed if we are not already stopped... */

	PauseState(TMData);
  return(FALSE);
  }

BOOL EventFunc_CLIST(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {	struct Node *n = SelectNode( &CDTList, imsg->Code );

	if (n)
		GT_SetGadgetAttrs(GadgetInfo_NEWCON.Gadget, WindowInfo_SELECTCO.Window, NULL,
			GTST_String, n->ln_Name, TAG_DONE );

  return(FALSE);
  }

BOOL EventFunc_NEWCON(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  return(FALSE);
  }

BOOL EventFunc_SELECT(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  NewConductorName( ((struct StringInfo *)GadgetInfo_NEWCON.Gadget->SpecialInfo)->Buffer );
  CloseWindow_SELECTCO(TMData);

  return(FALSE);
  }

BOOL EventFunc_CANCEL(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  CloseWindow_SELECTCO(TMData);

  return(FALSE);
  }

BOOL EventFunc_RESETTOZ(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
	current_time = 0;
	StopState(TMData);
	DrawTimeControl(TMData);
	return(FALSE);
  }

BOOL EventFunc_NTSCNOND(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  return(FALSE);
  }

BOOL EventFunc_NTSCDROP(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  return(FALSE);
  }

BOOL EventFunc_PAL25FPS(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  return(FALSE);
  }

BOOL EventFunc_FILM24FP(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {
  return(FALSE);
  }

extern BOOL positive_only;

BOOL EventFunc_POSITIVE(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {	positive_only = TMData->checked_menu;
	return(FALSE);
  }

extern BOOL wait_for_apps;

BOOL EventFunc_WAIT(struct TMData *TMData, struct IntuiMessage *imsg, TMOBJECTDATA *tmobjectdata)
  {	wait_for_apps = TMData->checked_menu;
	return(FALSE);
  }
