/* =========================================================================== *
 *							       Box Image Class                             *
 * =========================================================================== */

	/* This is my generic custom image structure */

struct BoxImage {
	struct _Object		obj;
	struct Image		image;
	UWORD				*glyph_data;			/* data for glyph in center		*/
	WORD				flags;					/* flags for this image			*/
};

	/* flags to fill in the BoxImage flags field */

#define BOX_BEVELED		(1<<0)					/* box has beveled look			*/
#define BOX_FILLED		(1<<1)					/* center of box filled in		*/
#define BOX_THICK_BEVEL	(1<<2)					/* vertical lines doubly thick	*/
#define BOX_PUSHES_IN	(1<<3)					/* bevel inverted when selected	*/
/* #define BOX_HIGH_FILL	(1<<4) */
#define BOX_LIGHT_FILL	(1<<5)					/* selected center same as shine*/
#define BOX_IN_BORDER	(1<<6)					/* reverse fill when window active */

#define BOX_Beveled		(TAG_USER+1)			/* box has beveled look			*/
#define BOX_Filled		(TAG_USER+2)			/* center of box filled in		*/
#define BOX_ThickBevel	(TAG_USER+3)			/* vertical lines doubly thick	*/
#define BOX_PushesIn	(TAG_USER+4)			/* bevel inverted when selected	*/
#define BOX_LightFill	(TAG_USER+5)			/* selected center same as shine*/
#define BOX_BorderFill	(TAG_USER+6)			/* reverse fill when window active*/

#define BOX_GlyphData	(TAG_USER+7)			/* glyph image data				*/
#define BOX_GlyphWidth	(TAG_USER+8)			/* width of glyph data			*/
#define BOX_GlyphHeight	(TAG_USER+9)			/* height of glyph data			*/
#define BOX_Text		(TAG_USER+10)			/* centered text string			*/
#define BOX_Font		(TAG_USER+11)			/* font to render text string	*/

	/* assembly language functions from my standard library */

void __asm DrawBevel( register __a1 struct RastPort *,
                      register __a0 struct IBox *,
                      register __d0 WORD,
                      register __d1 WORD );

void __asm DrawThinBevel( register __a1 struct RastPort *,
                          register __a0 struct IBox *,
                          register __d0 WORD,
                          register __d1 WORD );

void __asm SetupImageIBox( register __a0 struct Image *,
                           register __a1 struct impDraw *,
                           register __a2 struct IBox * );

