
#ifndef AZTEC_C
#include <clib/alib_protos.h>
#include <clib/alib_stdio_protos.h>
#include <clib/cia_protos.h>
#include <clib/dos_protos.h>
#include <clib/exec_protos.h>
#include <clib/misc_protos.h>
#include <clib/timer_protos.h>
#include <clib/utility_protos.h>

#include <stdlib.h>
#endif

#if 0
    /* locally defined pragmas */
#include "sys_pragmas.h"
#include "pragmas/dos_pragmas.h"
#include "pragmas/misc_pragmas.h"
#include "pragmas/timer_pragmas.h"
#include "pragmas/utility_pragmas.h"
#endif

#include "midi/camd.h"
#include "midi/mididefs.h"
#include "clib/camd_protos.h"
#include "pragmas/camd_pragmas.h"

struct Library	*CamdBase;

struct MidiNode	*testnode;
struct MidiLink *outlink,
				*inlink;

char			a_sys_ex[] = { MS_SysEx, 8, 7, 6, 5, 4, 3, 2, 1, MS_EOX };
char			b_sys_ex[128];

char			r_sys_ex[] = { MS_SysEx, 0x41, 0x07, 0x14, 0x11, 0,0,0,
								0,0,0x10, 0x70, MS_EOX };
	/* stub functions */

struct MidiNode *CreateMidi(Tag tag, ...)
{	return CreateMidiA((struct TagItem *)&tag );
}

BOOL SetMidiAttrs(struct MidiNode *mi, Tag tag, ...)
{	return SetMidiAttrsA(mi, (struct TagItem *)&tag );
}

struct MidiLink *AddMidiLink(struct MidiNode *mi, LONG type, Tag tag, ...)
{	return AddMidiLinkA(mi, type, (struct TagItem *)&tag );
}

BOOL SetMidiLinkAttrs(struct MidiLink *mi, Tag tag, ...)
{	return SetMidiLinkAttrsA(mi, (struct TagItem *)&tag );
}

void main(int argc, char *argv[])
{	char	*inlinkname = "in.0",
			*outlinkname = "out.0";
	char	mode;
	ULONG	sigs;

	if (argc <= 1)
	{
		printf("Usage: linktest mode [inlink outlink]\n");
		exit (5);
	}

	mode = argv[1][0];

	if (argc == 4)
	{
		inlinkname = argv[2];
		outlinkname = argv[3];
	}

	if (CamdBase = OpenLibrary("camd.library",0L))
	{
		if (testnode = CreateMidi(
			MIDI_Name, "test node",
			MIDI_RecvSignal, SIGBREAKB_CTRL_F,
			MIDI_MsgQueue,   100,
			MIDI_SysExSize,   100,
			MIDI_ErrFilter, CMEF_All,
			TAG_DONE ))
		{	printf("Opened Node!\n");

			if (outlink = AddMidiLink(testnode, MLTYPE_Sender,
				MLINK_Name, "Out",
				MLINK_Location, outlinkname,
				MLINK_Comment, "Test Output",
				MLINK_Parse, TRUE,
				TAG_DONE ))
			{	printf("Opened Output Link!\n");

				if (inlink = AddMidiLink(testnode, MLTYPE_Receiver,
					MLINK_Name, "In",
					MLINK_Location, inlinkname,
					MLINK_Comment, "Test Input",
					MLINK_PortID,	0,
					TAG_DONE ))
				{	MidiMsg		test;

					printf("Opened Input Link!\n");

					if (mode == 'r')
					{
						test.mm_Status = 0;

						printf("Waiting...\n");

						sigs = Wait(SIGBREAKF_CTRL_C | SIGBREAKF_CTRL_F);

						if (sigs & SIGBREAKF_CTRL_C) goto end0;
										
						GetMidi(testnode,&test);

						if (test.mm_Status == MS_SysEx)
						{	int i;

							printf("Maybe SysEx!\n");

							GetSysEx(testnode,b_sys_ex,128);

							for (i=0;i<128;i++)
							{
								printf("0x%02lx\n",(ULONG)b_sys_ex[i]);
								if (b_sys_ex[i] == MS_EOX) break;
							}

							PutSysEx(outlink,a_sys_ex);
						}
						else
						{
							printf("Got something else: 0x%02lx\n",(ULONG)test.mm_Status);
						}
					}
					else if (mode == 's')
					{
						PutSysEx (outlink,r_sys_ex);

						printf("Put SysEx\n");

						test.mm_Status = 0;

						sigs = Wait(SIGBREAKF_CTRL_C | SIGBREAKF_CTRL_F);

						if (sigs & SIGBREAKF_CTRL_C) goto end0;
										
						GetMidi(testnode,&test);

						if (test.mm_Status == MS_SysEx)
						{	int i;

							printf("Maybe SysEx!\n");

							GetSysEx(testnode,b_sys_ex,128);

							for (i=0;i<128;i++)
							{
								printf("0x%02lx\n",(ULONG)b_sys_ex[i]);
								if (b_sys_ex[i] == MS_EOX) break;
							}
						}
						else
						{
							printf("Got something other than SysEx?\n");
						}
					}
				}
			}
end0:		DeleteMidi(testnode);
		}
		CloseLibrary(CamdBase);
	}

	exit(0);
}
