#include <clib/alib_protos.h>
#include <clib/alib_stdio_protos.h>
#include <clib/cia_protos.h>
#include <clib/dos_protos.h>
#include <clib/exec_protos.h>
#include <clib/misc_protos.h>
#include <clib/timer_protos.h>
#include <clib/utility_protos.h>

#include <stdlib.h>

#include "/midi/camd.h"
#include "/midi/camdtime.h"
#include "/midi/mididefs.h"
#include "/clib/camd_protos.h"
#include "/pragmas/camd_lat_pragmas.h"

struct Library	*CamdBase;

	/* stub functions */

struct MidiNode *CreateMidi(Tag tag, ...)
{	return CreateMidiA((struct TagItem *)&tag );
}

BOOL SetMidiAttrs(struct MidiNode *mi, Tag tag, ...)
{	return SetMidiAttrsA(mi, (struct TagItem *)&tag );
}

struct MidiLink *AddMidiLink(struct MidiNode *mi, LONG type, Tag tag, ...)
{	return AddMidiLinkA(mi, type, (struct TagItem *)&tag );
}

BOOL SetMidiLinkAttrs(struct MidiLink *mi, Tag tag, ...)
{	return SetMidiLinkAttrsA(mi, (struct TagItem *)&tag );
}

void main(int argc, char *argv[])
{	struct MidiCluster	*mc = NULL;
	struct Conductor	*cdt = NULL;

	if (CamdBase = OpenLibrary("camd.library",0L))
	{
		LockCAMD(CD_Linkages);
		while (mc = NextCluster(mc))
		{
			printf("Cluster \"%s\"\n",mc->mcl_Node.ln_Name);
		}
		UnlockCAMD(CD_Linkages);

		LockCAMD(CD_Conductors);
		while (cdt = NextConductor(cdt))
		{
			printf("Conductor \"%s\"\n",cdt->cdt_Node.ln_Name);
		}
		UnlockCAMD(CD_Conductors);

		CloseLibrary(CamdBase);
	}

	exit(0);
}
