******* LawBreaker ************************************************************
*
*   NAME
*	LawBreaker - A quicky test of Enforcer
*
*   SYNOPSIS
*	This is a quick test of Enforcer and its reporting abilities.
*
*   FUNCTION
*	This program is used to make sure that Enforcer is correctly
*	installed and operating.  LawBreaker works from either the CLI
*	or Workbench.  It will try to read and write certain memory
*	areas that will cause an Enforcer hit or four.
*
*   INPUTS
*	Just run it...
*
*   RESULTS
*	When running Enforcer, you will see some output from Enforcer.
*	Output on a 68030 machine would look something like this:
*
*WORD-WRITE to  00000000        data=0000       PC: 0783AC6A
*USP:  078CAAEC SR: 0004 SW: 0729  (U0)(-)(-)  TCB: 078AADF8
*Data: DDDD0000 DDDD1111 DDDD2222 DDDD3333 DDDD4444 DDDD5555 DDDD6666 DDDD7777
*Addr: AAAA0000 AAAA1111 AAAA2222 AAAA3333 AAAA4444 AAAA5555 07800804 --------
*Stck: 00000000 0784991C 00009C40 078AB81C BBBBBBBB BBBBBBBB BBBBBBBB BBBBBBBB
*Stck: BBBBBBBB BBBBBBBB BBBBBBBB BBBBBBBB BBBBBBBB 00000000 006B54E0 ABADCAFE
*PC-8: AAAA1111 247CAAAA 2222267C AAAA3333 287CAAAA 44442A7C AAAA5555 31C00000
*PC *: 522E0127 201433FC 400000DF F09A522E 012611C1 01004EAE FF7621C0 0104532E
*Name: "Shell"  CLI: "NewTest:LawBreaker"  Hunk 0000 Offset 0000007A
*
*LONG-READ from AAAA4444                        PC: 0783AC6E
*USP:  078CAAEC SR: 0015 SW: 0749  (U0)(F)(-)  TCB: 078AADF8
*Data: DDDD0000 DDDD1111 DDDD2222 DDDD3333 DDDD4444 DDDD5555 DDDD6666 DDDD7777
*Addr: AAAA0000 AAAA1111 AAAA2222 AAAA3333 AAAA4444 AAAA5555 07800804 --------
*Stck: 00000000 0784991C 00009C40 078AB81C BBBBBBBB BBBBBBBB BBBBBBBB BBBBBBBB
*Stck: BBBBBBBB BBBBBBBB BBBBBBBB BBBBBBBB BBBBBBBB 00000000 006B54E0 ABADCAFE
*PC-8: 247CAAAA 2222267C AAAA3333 287CAAAA 44442A7C AAAA5555 31C00000 522E0127
*PC *: 201433FC 400000DF F09A522E 012611C1 01004EAE FF7621C0 0104532E 01266C08
*Name: "Shell"  CLI: "NewTest:LawBreaker"  Hunk 0000 Offset 0000007E
*
*BYTE-WRITE to  00000100        data=11         PC: 0783AC80
*USP:  078CAAEC SR: 0010 SW: 0711  (U0)(F)(D)  TCB: 078AADF8
*Data: 00000000 DDDD1111 DDDD2222 DDDD3333 DDDD4444 DDDD5555 DDDD6666 DDDD7777
*Addr: AAAA0000 AAAA1111 AAAA2222 AAAA3333 AAAA4444 AAAA5555 07800804 --------
*Stck: 00000000 0784991C 00009C40 078AB81C BBBBBBBB BBBBBBBB BBBBBBBB BBBBBBBB
*Stck: BBBBBBBB BBBBBBBB BBBBBBBB BBBBBBBB BBBBBBBB 00000000 006B54E0 ABADCAFE
*PC-8: 2A7CAAAA 555531C0 0000522E 01272014 33FC4000 00DFF09A 522E0126 11C10100
*PC *: 4EAEFF76 21C00104 532E0126 6C0833FC C00000DF F09A201F 66024E75 22404EEE
*Name: "Shell"  CLI: "NewTest:LawBreaker"  Hunk 0000 Offset 00000090
*
*LONG-WRITE to  00000104        data=00000000   PC: 0783AC88
*USP:  078CAAEC SR: 0014 SW: 0709  (U0)(-)(D)  TCB: 078AADF8
*Data: 00000000 DDDD1111 DDDD2222 DDDD3333 DDDD4444 DDDD5555 DDDD6666 DDDD7777
*Addr: AAAA0000 AAAA1111 AAAA2222 AAAA3333 AAAA4444 AAAA5555 07800804 --------
*Stck: 00000000 0784991C 00009C40 078AB81C BBBBBBBB BBBBBBBB BBBBBBBB BBBBBBBB
*Stck: BBBBBBBB BBBBBBBB BBBBBBBB BBBBBBBB BBBBBBBB 00000000 006B54E0 ABADCAFE
*PC-8: 0000522E 01272014 33FC4000 00DFF09A 522E0126 11C10100 4EAEFF76 21C00104
*PC *: 532E0126 6C0833FC C00000DF F09A201F 66024E75 22404EEE FE860024 5645523A
*Name: "Shell"  CLI: "NewTest:LawBreaker"  Hunk 0000 Offset 00000098
*
*   NOTES
*	If enforcer is not running, the program should not cause the
*	system to crash.  It will, however, write to certain areas
*	of low memory.  Also, it will cause read access of some
*	addresses that may not exist.  This may cause bus faults.
*
*   SEE ALSO
*	"Quantum Physics:  The Dreams that Stuff is made of." - Michael Sinz
*
*   BUGS
*	There are 4 known Enforcer hits in this code, however, they
*	will not be fixed.  ;^)
*
*******************************************************************************
*
		INCLUDE	"exec/types.i"
		INCLUDE	"exec/execbase.i"
		INCLUDE	"exec/macros.i"
		INCLUDE	"dos/dosextens.i"
*
*******************************************************************************
*
* The main code...
*
LawBreaker:	move.l	4.w,a6		; Get ExecBase...
		clr.l	-(sp)		; Clear the message pointer...
		move.l	ThisTask(a6),a4	; Get our process pointer...
		tst.l	pr_CLI(a4)	; Are we a CLI?
		bne.s	Do_Law		; If NULL, we are a WB run program...
*
* Handle Workbench Startup...
*
		lea	pr_MsgPort(a4),a4	; Get message port...
		move.l	a4,a0		; We first wait for the WB Startup MSG
		JSRLIB	WaitPort	; (it should be here very quickly)
		move.l	a4,a0		; Now we get the message...
		JSRLIB	GetMsg		; Get it...
		move.l	d0,(sp)		; Now, store it on the stack...
*
* Ok, now be nasty...
*
* First fill up the registers with patterns
*
Do_Law:		move.l	#$DDDD0000,d0
		move.l	#$DDDD1111,d1
		move.l	#$DDDD2222,d2
		move.l	#$DDDD3333,d3
		move.l	#$DDDD4444,d4
		move.l	#$DDDD5555,d5
		move.l	#$DDDD6666,d6
		move.l	#$DDDD7777,d7
		move.l	#$AAAA0000,a0
		move.l	#$AAAA1111,a1
		move.l	#$AAAA2222,a2
		move.l	#$AAAA3333,a3
		move.l	#$AAAA4444,a4
		move.l	#$AAAA5555,a5
*
		move.w	d0,$0000	; Ping location 0 (to 0)
		JSRLIB	Forbid
		move.l	(a4),d0		; Ping another spot
		JSRLIB	Disable
		move.b	d1,$0101	; Ping one more...
		JSRLIB	Permit
		move.l	d0,$0102	; One last one...
		JSRLIB	Enable
*
* Ok, so now we quit...
*
		move.l	(sp)+,d0	; Get message...
		beq.s	Done		; If we have one, do WB exit...
*
* We have a Workbench message, so reply it...
*
		JSRLIB	Forbid		; We need to FORBID for a bit...
		move.l	d0,a1		; Get message into register
		JSRLIB	ReplyMsg	; Reply the workbench message...
*
Done:		rts			; Return with NULL...
*
*******************************************************************************
*
* The version string...
*
		INCLUDE	"lawbreaker_rev.i"
		VERSTAG
*
*******************************************************************************
*
* "A master's secrets are only as good as the
*  master's ability to explain them to others."  -  Michael Sinz
*
*******************************************************************************
*
		END
