/*
 * ShowBoard.rexx - A Flipper REXX macro to display in ASCII the board
 *
 * The argument given to this script is the flipper port number.
 */

PARSE ARG number
number=STRIP(number)

/* Generate port name for FLIPPER */
port='FLIPPER.'||number

/* Check to see if the port asked for is available */
IF SHOW('p',port)>0 THEN
  DO
    /* Address the FLIPPER port */
    ADDRESS VALUE port

    /* We get results via the RESULT variable */
    OPTIONS RESULTS

    /* Get the version of Flipper */
    'get about' ; PARSE VAR RESULT name version copyright
    SAY name "version" version

    /* Get the current board layout */
    'get board' ; board=RESULT

    /* Get the current player */
    'get player' ; player=RESULT

    /* Display the results of our "investigation" */
    SAY " "

    IF player=='-' THEN SAY "The game is over - No moves left"
    ELSE SAY "It is player "player"'s turn"

    SAY "The current board is:"
    DO loop=0 to 7
      SAY RIGHT(SUBSTR(board,1+8*loop,8),30)
    END

    SAY " "

  END
ELSE
  DO
    SAY port "is not active."
  END

EXIT
