/* setwaitpointer.c
 * Copyright (C) 1990, 1991 Commodore-Amiga, Inc.
 * Written by David N. Junod
 *
 */

static UWORD chip WaitPointer[] =
{
    0x0000, 0x0000,

    0x0400, 0x07C0,
    0x0000, 0x07C0,
    0x0100, 0x0380,
    0x0000, 0x07E0,
    0x07C0, 0x1FF8,
    0x1FF0, 0x3FEC,
    0x3FF8, 0x7FDE,
    0x3FF8, 0x7FBE,
    0x7FFC, 0xFF7F,
    0x7EFC, 0xFFFF,
    0x7FFC, 0xFFFF,
    0x3FF8, 0x7FFE,
    0x3FF8, 0x7FFE,
    0x1FF0, 0x3FFC,
    0x07C0, 0x1FF8,
    0x0000, 0x07E0,

    0x0000, 0x0000,		/* reserved, must be NULL */
};

/* This function sets the busy pointer in the specified window */
VOID SetWaitPointer (struct Window * w)
{

    /* Make sure we have a window pointer */
    if (w)
    {
	/* Set the pointer to the clock image */
	SetPointer (w, WaitPointer, 16, 16, -6, 0);
    }
}

/* This function sets the busy pointer, and locks the gadgets for the
 * specified window.
 *
 * Example:
 *
 *    VOID DoSomethingLong (struct Window *w)
 *    {
 *        struct Requester r;
 *
 *        LockWindow (w, &r);
 *
 *        ... do the work ...
 *
 *        UnlockWindow (w, &r);
 *    }
 *
 */

VOID LockWindow (struct Window *w, struct Requester *r)
{
    /* Make sure we have a window */
    if (w)
    {
	/* Set the wait pointer */
	SetWaitPointer (w);

	/* See if we have a requester */
	if (r)
	{
            /* Clear the requester fields */
            InitRequester (r);

            /* Set the required fields */
            r->LeftEdge = r->TopEdge = (-1);
            r->Width = r->Height = 1;
            r->Flags = SIMPLEREQ | NOREQBACKFILL;

            /* Bring up the locking requester */
            Request (r, w);
	}
    }
}

VOID UnlockWindow (struct Window *w, struct Requester *r)
{
    /* Make sure we have a window */
    if (w)
    {
	/* See if we have a requester to clear */
	if (r)
	{
	    /* Turn off the requester */
	    EndRequest (r, w);
	}

	/* Turn off the busy pointer */
	ClearPointer (w);
    }
}
