;/* GetFileName.c - Execute me to compile me with SAS/C v5.10a
LC -b1 -cfistq -v -y -j73 getfilename.c
Blink FROM LIB:c.o,getfilename.o TO getfilename LIBRARY LIB:LC.lib,LIB:Amiga.lib
quit

This simple example provides a subroutine getfilename(buffer,win,mode) which
gets a filename using the ASL file requester if asl.library is available.
Otherwise it calls oldgetfilename(buffer,win,mode) which could call your old
file request code (here it just prompts for a filename from stdin).

Mode is 0 (MODE_LOAD) for a load, and 1 (MODE_SAVE) for a save.

If a window pointer is provided, the requester will come up on that window's
screen.  This example first opens a load requester, then a save requester.
A custom title string and OK gadget string are used.
*/

#include <exec/types.h>
#include <exec/memory.h>
#include <dos/dos.h>
#include <intuition/intuition.h>
#include <libraries/asl.h>

#ifdef LATTICE
#include <clib/exec_protos.h>
#include <clib/dos_protos.h>
#include <clib/asl_protos.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>


int CXBRK(void) { return(0); }  /* Disable Lattice CTRL/C handling */
int chkabort(void) { return(0); }  /* really */
#endif


/**********    debug macros     ***********/
#define MYDEBUG     0    /* Set to 1 for debugging output. */
void kprintf(UBYTE *fmt,...);
void dprintf(UBYTE *fmt,...);
#define DEBTIME 0
#define bug printf
#if MYDEBUG
#define D(x) (x); if(DEBTIME>0) Delay((ULONG)DEBTIME);
#else
#define D(x) ;
#endif /* MYDEBUG */
/********** end of debug macros **********/


#define MINARGS 1
#define ANY_LIB_VER 0L

UBYTE *vers = "$VER: getfilename 37.3 (07.08.91)";
UBYTE *Copyright = 
  "getfilename v37.3\nCopyright (c) 1990-91 Commodore-Amiga, Inc.  All Rights Reserved";
UBYTE *usage = "Usage: getfilename";

/* protos */
UBYTE  *getfilename(UBYTE *copybuf, struct Window *win, int mode);
UBYTE  *oldgetfilename(UBYTE *copybuf, struct Window *win, int mode);
BOOL   AslRequestTags( APTR request, ULONG tags, ...);
void bye(UBYTE *s, int e);
void cleanup(void);

/* for file requester */
#define MODE_LOAD 0
#define MODE_SAVE 1
#define NBUFSZ (256)
UBYTE fnamebuf[NBUFSZ] = {0};
#define INITDIR "SYS:"


struct Library    *AslBase = NULL;
struct FileRequester *freq = NULL;

BOOL FromWb;

/*
 *  MAIN
 */
void main(int argc, char **argv)
    {
    UBYTE *filename;

    FromWb = (argc==0) ? TRUE : FALSE;

    if((argc)&&(argc<MINARGS))
    {
    printf("%s\n%s\n",Copyright,usage);
    bye("",RETURN_OK);
    }


    AslBase = OpenLibrary("asl.library", ANY_LIB_VER); /* used if available */

    /* if on a custom screen, we'd pass window as second arg */

    printf("\nHere is a load requester.\n");
    printf("When requester appears, go to any volume:dir and select a file\n");
    Delay(1L * TICKS_PER_SECOND);

    if(filename = getfilename(fnamebuf,NULL,MODE_LOAD))
    {
    printf("filename for load is %s\n",fnamebuf);
    }
    else printf("No filename selected for load.\n");


    printf("\nHere is a save requester (allows directory creation).\n");
    printf("\nNote that the previous directory and file are remembered.\n");
    Delay(1L * TICKS_PER_SECOND);

    if(filename = getfilename(fnamebuf,NULL,MODE_SAVE))
    {
    printf("filename for save is %s\n",fnamebuf);
    }
    else printf("No filename selected for save.\n");

    bye("",RETURN_OK);
    }


void bye(UBYTE *s, int e)
   {
   if(*s)
    {
    printf("%s\n",s);
    if(FromWb)
        {
        printf("Press <RET> to exit: ");
        getchar();
        }
    }
   cleanup();
   exit(e);
   }


void cleanup()
   {
   if (freq)        FreeAslRequest(freq);
   if (AslBase)        CloseLibrary(AslBase);
   }


UBYTE *getfilename(UBYTE *copybuf, struct Window *win, int mode)
{
ULONG funcflags;
UBYTE *hail, *oktext;

hail   = (mode == MODE_LOAD) ? "Load File" : "Save File";
oktext = (mode == MODE_LOAD) ? "Load" : "Save";
funcflags = (mode == MODE_SAVE ) ? FILF_SAVE : 0;
funcflags |= ((win)&&(win->UserPort)) ? 0 : FILF_NEWIDCMP;


D(bug("In getfilename\n"));

/* If have asl.library, try requester */
if(AslBase)
    {
    /* if we don't have one, alloc it */
    if(!freq) freq = AllocAslRequest(ASL_FileRequest, NULL);

    if(freq)
    {
    D(bug("About to Request File\n"));

    if(AslRequestTags((APTR)freq,
                ASL_Hail,hail,
                ASL_OKText,oktext,
                ASL_Window, win,
                ASL_FuncFlags, funcflags,
                TAG_DONE ))
        {
        D(bug("Request File successful\n"));
        strcpy(copybuf,freq->rf_Dir);
        if(AddPart(copybuf,freq->rf_File,NBUFSZ)) return(copybuf);
        }
    else return(NULL);
    }
    }
else return(oldgetfilename(copybuf,win,mode));
}


/* Replace this with code that calls your
 * old file requester or brings up a string gadget, etc.
 */
UBYTE *oldgetfilename(UBYTE *copybuf, struct Window *win, int mode)
{
    printf("\nEnter filename, or <Return> to exit: ");
    copybuf[0] = '\0';
    gets(copybuf);
    return(copybuf[0] ? copybuf : NULL);
}

/*------------------------------------------------------------------------*/


BOOL AslRequestTags(request, tags)
APTR request;
ULONG tags;
    {
    return(AslRequest(request, (struct TagItem *)&tags));
    }
