/*
 * timer.h
 *
 * Appshell Timer Handler Include Data
 * Copyright (C) 1991 Kompositor Software
 * Written by John F Wiederhirn
 *
 */

/* This defines the memory class wanted from all allocations */
/* within the handler.  The MEMF_PUBLIC may or may not be */
/* necessary, but this is the safe approach. */

#define MEMFLAGS (MEMF_CLEAR|MEMF_PUBLIC)

/* These flag values can also be allocated for Timer Handler */
/* from Commodore-Amiga.  Again, I hope a gap is left. */

#define APSH_TIMER_ID		9000L

/* The following Tags can be allocated for Timer Handler from */
/* Commodore-Amiga.  Hopefully, a gap will be left in case */
/* more are needed. */

#define TIMER_Dummy		TAG_USER+26000L
#define APSH_TimerMode		(TIMER_Dummy + 1L)
#define APSH_TimerLen		(TIMER_Dummy + 2L)
#define APSH_TimerKill		(TIMER_Dummy + 3L)

/* These flag values are handler-private and can thus be whatever */
/* happens to be convenient. */

#define TH_STRTMODE		0L
#define TH_TICKING		1L
#define TH_ONESHOT		2L
#define TH_ENDMODE		3L

#ifndef	ASM
#define	ASM	__asm
#endif

#ifndef	REG
#define	REG(x)	register __ ## x
#endif

/* Only public function. */
struct MsgHandler * ASM setup_timerA (REG(d0) struct AppInfo *, REG(d1) struct TagItem *);

/* END OF TIMER_HAN.H */
