/************************************************************************
 *                                                                      *
 *                            Preliminary                               *
 *                        Amiga AppShell (tm)                           *
 *                                                                      *
 *  Copyright (c) 1990,1991 Commodore-Amiga, Inc. All Rights Reserved.  *
 *                                                                      *
 *   This software and information is proprietary, preliminary, and     *
 *   subject to change without notice.                                  *
 *                                                                      *
 *                            DISCLAIMER                                *
 *                                                                      *
 *   THIS SOFTWARE IS PROVIDED "AS IS".                                 *
 *   NO REPRESENTATIONS OR WARRANTIES ARE MADE WITH RESPECT TO THE      *
 *   ACCURACY, RELIABILITY, PERFORMANCE, CURRENTNESS, OR OPERATION      *
 *   OF THIS SOFTWARE, AND ALL USE IS AT YOUR OWN RISK.                 *
 *   NEITHER COMMODORE NOR THE AUTHORS ASSUME ANY RESPONSIBILITY OR     *
 *   LIABILITY WHATSOEVER WITH RESPECT TO YOUR USE OF THIS SOFTWARE.    *
 *                                                                      *
 *                          Non-Disclosure                              *
 *                                                                      *
 *   This information is not to be disclosed to any other company,      *
 *   individual or party.  Discussion is to be restricted to CBM        *
 *   approved discussion areas, such as the closed conferences on bix;  *
 *   amiga.cert, amiga.com, amiga.beta/appshell.                        *
 *                                                                      *
 ************************************************************************
 * Copyright (C) 1990,1991 Commodore-Amiga, Inc.
 * written by David N. Junod
 */

#include <exec/types.h>
#include <exec/libraries.h>
#include <intuition/intuition.h>
#include <libraries/appshell.h>
#include <workbench/startup.h>
#include <clib/alib_protos.h>
#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/appshell_protos.h>
#include <pragmas/appshell_pragmas.h>
#include <string.h>

struct Library *AppShellBase;

static struct TextAttr T80 = {"topaz.font", 8, NULL, NULL};
static struct IntuiText T0 = {2,1,JAM2,20,24,&T80,"Requires appshell.library",NULL};
static struct IntuiText T1 = {0,1,JAM2,20,10,&T80,NULL,&T0};
static struct IntuiText T2 =
{
    AUTOFRONTPEN, AUTOBACKPEN, AUTODRAWMODE, AUTOLEFTEDGE,
    AUTOTOPEDGE, &T80, " OK ", NULL
};

extern char *_ProgramName;

static VOID RequiresAppShell(VOID)
{
    extern struct Library *IntuitionBase;
    char buffer[80];

    /* Open Intuition, so that we can bring up an AutoRequest */
    if (IntuitionBase = OpenLibrary ("intuition.library", 0))
    {
	/* Copy the name of the application into the buffer.  This is
	 * SAS specific. */
	memcpy (buffer, _ProgramName, (long) _ProgramName[-1]);
	buffer[(int)_ProgramName[-1]] = '\0';
	T1.IText = buffer;

	/* Display the error message */
	AutoRequest (NULL, &T1, NULL, &T2, 0, 0, 320, 60);
    }
}

#define	MY_OWN_HOOK	FALSE

#if MY_OWN_HOOK

/* This is an example of how to define your own hook */
VOID __asm newdispatchHook (
    register __a0 struct Hook * h,
    register __a2 struct AppInfo *ai,
    register __a1 struct AppFunction *af)
{
    VOID (* __asm func)(
	register __a0 struct Hook *,
	register __a2 struct AppInfo *,
	register __a1 struct AppFunc *);

    func = h->h_SubEntry;
    (*func)(h, ai, af);
}

/* Application initialization and startup */
VOID main (int argc, char **argv)
{
    extern struct WBStartup *WBenchMsg;
    extern struct TagItem Our_App[];
    struct TagItem tag[3];

    /* open the AppShell library */
    if (AppShellBase = OpenLibrary ("appshell.library", 36))
    {
	struct Hook hook;

	hook.h_Entry = newdispatchHook;

	tag[0].ti_Tag = APSH_DispatchHook;
	tag[0].ti_Data = &hook;
	tag[1].ti_Tag = TAG_MORE;
	tag[1].ti_Data = (ULONG) Our_App;

	/* Main AppShell entry point */
	HandleApp (argc, argv, WBenchMsg, tag);

	/* close the AppShell library */
	CloseLibrary (AppShellBase);
    }
    else
    {
	RequiresAppShell();
    }
}

#else

/* Application initialization and startup */
VOID main (int argc, char **argv)
{
    extern struct WBStartup *WBenchMsg;
    extern struct TagItem Our_App[];
    struct TagItem tag[3];

    /* open the AppShell library */
    if (AppShellBase = OpenLibrary ("appshell.library", 36))
    {
	/* Tell the AppShell that we understand new-style functions */
	tag[0].ti_Tag = APSH_HookClass;
	tag[0].ti_Data = TRUE;
	tag[1].ti_Tag = TAG_MORE;
	tag[1].ti_Data = (ULONG) Our_App;

	/* Main AppShell entry point */
	HandleApp (argc, argv, WBenchMsg, tag);

	/* close the AppShell library */
	CloseLibrary (AppShellBase);
    }
    else
    {
	RequiresAppShell();
    }
}
#endif
