/*************************************************************************
  *                                                                      *
  *                            Preliminary                               *
  *                        Amiga AppShell (tm)                           *
  *                                                                      *
  *  Copyright (c) 1990,1991 Commodore-Amiga, Inc. All Rights Reserved.  *
  *                                                                      *
  *   This software and information is proprietary, preliminary, and     *
  *   subject to change without notice.                                  *
  *                                                                      *
  *                            DISCLAIMER                                *
  *                                                                      *
  *   THIS SOFTWARE IS PROVIDED "AS IS".                                 *
  *   NO REPRESENTATIONS OR WARRANTIES ARE MADE WITH RESPECT TO THE      *
  *   ACCURACY, RELIABILITY, PERFORMANCE, CURRENTNESS, OR OPERATION      *
  *   OF THIS SOFTWARE, AND ALL USE IS AT YOUR OWN RISK.                 *
  *   NEITHER COMMODORE NOR THE AUTHORS ASSUME ANY RESPONSIBILITY OR     *
  *   LIABILITY WHATSOEVER WITH RESPECT TO YOUR USE OF THIS SOFTWARE.    *
  *                                                                      *
  *                          Non-Disclosure                              *
  *                                                                      *
  *   This information is not to be disclosed to any other company,      *
  *   individual or party.  Discussion is to be restricted to CBM        *
  *   approved discussion areas, such as the closed conferences on bix;  *
  *   amiga.cert, amiga.com, amiga.beta/appshell.                        *
  *                                                                      *
  ************************************************************************
  */

/* multiproj.h
 * Header file for the multi-project skeleton
 * Written by David N. Junod
 *
 */

#include <exec/types.h>
#include <exec/memory.h>
#include <exec/lists.h>
#include <exec/ports.h>
#include <exec/libraries.h>
#include <intuition/intuition.h>
#include <graphics/gfx.h>
#include <dos/dos.h>
#include <dos/dosextens.h>
#include <libraries/asl.h>
#include <libraries/gadtools.h>
#include <libraries/appshell.h>
#include <utility/tagitem.h>
#include <workbench/workbench.h>
#include <clib/macros.h>
#include <clib/exec_protos.h>
#include <clib/alib_protos.h>
#include <clib/asl_protos.h>
#include <clib/dos_protos.h>
#include <clib/intuition_protos.h>
#include <clib/graphics_protos.h>
#include <clib/gadtools_protos.h>
#include <clib/appshell_protos.h>
#include <clib/appobjects_protos.h>
#include <clib/utility_protos.h>
#include <pragmas/asl.h>
#include <pragmas/dos.h>
#include <pragmas/exec.h>
#include <pragmas/intuition.h>
#include <pragmas/graphics.h>
#include <pragmas/gadtools.h>
#include <pragmas/appshell.h>
#include <pragmas/appobjects.h>
#include <pragmas/utility.h>
#include <string.h>
#include <stdio.h>

#include "ae:support/misc_protos.h"

/* The AppShell maintains some basic information on the application.  This
 * information would appear in the About requester, and in AppExchange. */
#define	APPNAME "MultiProj"
#define	PROJNAME "MultiProj_Project"
#define	APPVERS	"MultiProj 36.1 (2-Feb-91)"
#define	APPCOPY "Copyright (C) 1991 Commodore-Amiga, Inc."
#define	APPAUTH "David N. Junod"

/* File requester ID's. */
#define	FR_PROJ	0
#define	FR_MAX	1

/* This structure contains all the data that our application will need.
 * Change to suit your application. */
struct AppData
{
    struct FileRequester *ad_FR[FR_MAX];	/* File requesters */

    UBYTE ad_Name[512];		/* Temporary project name */
    UBYTE ad_Tmp[512];		/* Temporary work buffer */
    struct TagItem ad_TL[5];	/* Temporary tag array */

    struct AppInfo *ad_MAI;	/* Master AppInfo */
    struct ProjNode *ad_PN;	/* Our project node */

    /* File requester positioning */
    WORD ad_LeftEdge;
    WORD ad_TopEdge;
    WORD ad_Width;
    WORD ad_Height;
};

/* This structure contains all the data that our application will need.
 * Change to suit your application. */
struct MasterData
{
    UBYTE md_Tmp[512];		/* Temporary work buffer */
    ULONG md_Flags;		/* Control Flags */
    struct MsgPort *md_SIPC;	/* Our master SIPC port */
};

/* Indicate that we're supposed to stick around when there are no projects. */
#define	MADF_BACKG	0x00000001

/* Attach this to each project node */
struct ProjData
{
    struct TagItem *pd_Clone;	/* Temporary clone of tags */
    struct AppInfo *pd_AI;	/* AppInfo structure */
    STRPTR pd_Port;		/* Pointer to the name of the SIPC port */
};

/* Each public function gets a numeric ID assigned to it.  You must
 * assign an ID to each one of your functions.  Look at appshell.h for
 * standard function ID's for things like New, Open, Cut, Copy, Paste,
 * Quit, etc... */
#define DUMMYID		APSH_USER_ID
#define CInitID		(DUMMYID +  1L)
#define	CExitID		(DUMMYID +  2L)
#define	IsActiveID	(DUMMYID +  3L)
#define	SetAttrsID	(DUMMYID +  4L)

/* These are the function ID's for our project process */
#define	PInitID		(DUMMYID + 10L)
#define	PExitID		(DUMMYID + 11L)
#define	OpenMainID	(DUMMYID + 12L)
#define	OpenAboutID	(DUMMYID + 13L)
#define	ChangeID	(DUMMYID + 14L)
#define LAST_ID		(DUMMYID + 15L)


/* These are the function prototypes for all the application implemented
 * functions used in this example.  You must prototype all the functions
 * that your application is going use in the function table. */
VOID CInitFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID NewFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID OpenFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID CloseFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID QuitFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID IsActiveFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID ActiveToolFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID SetAttrsFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID CExitFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);

/* These are project related functions */
VOID PInitFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID PExitFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID PNewFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID PClearFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID POpenFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID PSaveFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID PSaveAsFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID PCloseFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID PAboutFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID PQuitFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID OpenMainFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID OpenAboutFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID DropIconFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);
VOID ChangeFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af);

BOOL HandlerFunc (struct AppInfo * ai, ULONG tags,...);

void kprintf (void *, ...);

/* Shared system libraries */
extern struct Library *SysBase;
extern struct Library *DOSBase;
extern struct Library *AslBase;
extern struct Library *GadToolsBase;
extern struct Library *GfxBase;
extern struct Library *IconBase;
extern struct Library *IntuitionBase;
extern struct Library *UtilityBase;
extern struct Library *AppShellBase;
extern struct Library *AppObjectsBase;
extern struct Library *MySpecialBase;
