/*************************************************************************
  *                                                                      *
  *                            Preliminary                               *
  *                        Amiga AppShell (tm)                           *
  *                                                                      *
  *  Copyright (c) 1990,1991 Commodore-Amiga, Inc. All Rights Reserved.  *
  *                                                                      *
  *   This software and information is proprietary, preliminary, and     *
  *   subject to change without notice.                                  *
  *                                                                      *
  *                            DISCLAIMER                                *
  *                                                                      *
  *   THIS SOFTWARE IS PROVIDED "AS IS".                                 *
  *   NO REPRESENTATIONS OR WARRANTIES ARE MADE WITH RESPECT TO THE      *
  *   ACCURACY, RELIABILITY, PERFORMANCE, CURRENTNESS, OR OPERATION      *
  *   OF THIS SOFTWARE, AND ALL USE IS AT YOUR OWN RISK.                 *
  *   NEITHER COMMODORE NOR THE AUTHORS ASSUME ANY RESPONSIBILITY OR     *
  *   LIABILITY WHATSOEVER WITH RESPECT TO YOUR USE OF THIS SOFTWARE.    *
  *                                                                      *
  *                          Non-Disclosure                              *
  *                                                                      *
  *   This information is not to be disclosed to any other company,      *
  *   individual or party.  Discussion is to be restricted to CBM        *
  *   approved discussion areas, such as the closed conferences on bix;  *
  *   amiga.cert, amiga.com, amiga.beta/appshell.                        *
  *                                                                      *
  ************************************************************************
  */

/* about.c
 * Copyright (C) 1991 Commodore-Amiga, Inc.
 * About requester for a multi-project applicaton
 * Written by David N. Junod
 *
 * Must be compiled with Lattice options: -b0 -cfist -ms -v
 *
 */

#include "multiproj.h"

STRPTR about_text[] =
{
 /* Padding */
    "",

    "About MultiProj",
    APPNAME,
    APPVERS,
    APPCOPY,
    APPAUTH,
    "_Continue",

    "<no ARexx port>",
    NULL
};

struct TagItem icon_tags[] =
{
    {CGTA_MaxWidth, 80},
    {CGTA_MaxHeight, 40},
    {CGTA_LabelInfo, LABEL_CENTER},
    {CGTA_FrameInfo, FRAME_CENTER},
    {TAG_DONE,},
};

extern struct TagItem td_tags[];

struct TagItem text_tags[] =
{
    {CGTA_Borderless, TRUE},
    {GA_TEXT, NULL},
    {TAG_DONE,},
};

/* MAIN window environment */
/* This is the object array for the About window. */
struct Object about[] =
{
    {&about[1], 0, 0, OBJ_Window, NULL, APSH_OBJF_LOCALTEXT, NULL, "About", 1L,
     {1, 1, 0, 0},},

    {&about[2], 0, 0, OBJ_Display, NULL, NULL, NULL, "Icon", 0L,
     {8, 4, 90, 44}, icon_tags,},

 /* Using the Label as the contents... */
    {&about[3], 0, 0, OBJ_Text, NULL, APSH_OBJF_LOCALTEXT, NULL, "Name", 2L,
     {116, 4, 320, 10}, td_tags,},

    {&about[4], 0, 0, OBJ_Text, NULL, APSH_OBJF_LOCALTEXT, NULL, "Copyright", 3L,
     {116, 14, 320, 10}, td_tags,},

    {&about[5], 0, 0, OBJ_Text, NULL, APSH_OBJF_LOCALTEXT, NULL, "Version", 4L,
     {116, 24, 320, 10}, td_tags,},

    {&about[6], 0, 0, OBJ_Text, NULL, APSH_OBJF_LOCALTEXT, NULL, "Author", 5L,
     {116, 34, 320, 10}, td_tags,},

    {&about[7], 0, 0, OBJ_Display, NULL, NULL, NULL, "ARexx", NULL,
     {116, 44, 320, 10}, text_tags,},

    {NULL, 0, 0, OBJ_Button, NULL, APSH_OBJF_LOCALTEXT | APSH_OBJF_CLOSEWINDOW,
     NULL, "Continue", 6L, {-94, 58, 80, 12},},
};

/* This is the Window Environment tag array for the About window. */
struct TagItem aboutenv[] =
{
    {APSH_NameTag, (ULONG) "About"},	/* name to give to window */
    {APSH_Objects, (ULONG) about},	/* object list */
    {APSH_WinText, (ULONG) about_text},
    {APSH_WinAOpen, OpenAboutID},
    {TAG_DONE,}
};

VOID PAboutFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af)
{
    /* open the About window */
    HandlerFunc (ai,
		 APSH_Handler, "IDCMP",
		 APSH_Command, APSH_MH_OPEN,
		 APSH_WindowEnv, (ULONG) aboutenv,
		 TAG_DONE);

}

VOID
OpenAboutFunc (struct Hook *h, struct AppInfo *ai, struct AppFunction *af)
{
    struct AppData *ad = (struct AppData *) ai->ai_UserData;
    STRPTR port_name = about_text[7];
    struct MsgHandler *mh;
    struct Window *win;
    struct Gadget *gad;

    /* See if we have a tool icon */
    if (ai->ai_ProgDO)
    {
	struct Image *im;

	im = (struct Image *) (ai->ai_ProgDO->do_Gadget.GadgetRender);

	/* Update the imagry */
	if (APSHGetGadgetInfo (ai, "About", "Icon",
			       (ULONG *) & win, (ULONG *) & gad))
	{
	    /* Let the gadget know that there is an image */
	    SetGadgetAttrs (gad, win, NULL,
			    GA_LABELIMAGE, im, TAG_DONE);
	}
    }
    else
    {
	/* Update the imagry to show the program name */
	if (APSHGetGadgetInfo (ai, "About", "Icon",
			       (ULONG *) & win, (ULONG *) & gad))
	{
	    /* Let the gadget know that there is an image */
	    SetGadgetAttrs (gad, win, NULL,
			    GA_TEXT, ai->ai_ProgName, TAG_DONE);
	}
    }

    /* See if we have an ARexx port */
    if (mh = HandlerData (ai, APSH_Handler, "AREXX", TAG_DONE))
    {
	/* Get a pointer to the port name */
	port_name = mh->mh_PortName;
    }

    /* Get a pointer to the ARexx port name text gadget */
    if (APSHGetGadgetInfo (ai, "About", "ARexx",
			   (ULONG *) & win, (ULONG *) & gad))
    {
	/* Build the description string */
	sprintf (ad->ad_Tmp, "ARexx port: %s", port_name);

	/* Update the string gadget */
	SetGadgetAttrs (gad, win, NULL,
			   GA_Text, ad->ad_Tmp,
			   TAG_DONE);
    }
}
