#include <exec/types.h>
#include <intuition/intuition.h>
#include <intuition/intuitionbase.h>
#include <graphics/gfx.h>
#include <graphics/displayinfo.h>
#include <graphics/sprite.h>
#include <iff/ilbm.h>

#define	MAXCOLORS	32

/* Work structure */
typedef struct ILBMRec
{
    ULONG ir_ModeID;		/* Display mode id */
    UWORD ir_Width;		/* Width of image */
    UWORD ir_Height;		/* Height of image */
    UWORD ir_Depth;		/* Depth of image */
    struct BitMap ir_BMap;	/* Bitmap */
    struct RastPort ir_RPort;	/* RastPort */
    struct Point2D ir_Grab;	/* Grab coordinates */
    WORD ir_CRegs[MAXCOLORS];	/* Color table used by LoadRGB4() */
    WORD ir_NumColors;		/* Number of colors in color table */
} ILBM;

#define	BPR(w)		((w) + 15 >> 4 << 1)	/* Bytes per row */

/* ilbm.c */
ILBM *ReadILBM (BPTR drawer, STRPTR name, struct TagItem * attrs);
VOID FreeILBM (ILBM * ilbm);
ILBM *GetILBM (struct IFFHandle * iff);
BOOL GetBMHD (struct IFFHandle * iff, struct BitMapHeader * bmhd);
BOOL PutBMHD (struct IFFHandle * iff, struct BitMapHeader * bmhd, struct BitMap * bm);
WORD GetColors (struct IFFHandle * iff, struct ColorRegister * cmap);
BOOL PutColors (struct IFFHandle * iff, struct BitMapHeader * bmhd, struct ColorRegister * cmap);
void GetHotSpot (struct IFFHandle * iff, struct Point2D * grab, WORD, WORD);
BOOL PutHotSpot (struct IFFHandle * iff, struct Point2D * grab);
BOOL GetBody (struct IFFHandle * iff, struct BitMapHeader * bmhd, struct BitMap * bm);
BOOL GetLine (struct IFFHandle * iff, UBYTE * buf, WORD wide, WORD deep, UBYTE cmptype);
BOOL PutBody (struct IFFHandle * iff, struct BitMapHeader * bmhd, struct BitMap * bitmap);
BOOL AllocBMRasters (struct BitMap * bm, BYTE depth, WORD width, WORD height);

/* Pointer preference record */
struct PointerPref
{
    struct Prefs pp_Header;	/* Preference header */
    UWORD *pp_PData;		/* Pointer data */
    WORD pp_Height;		/* Height of pointer */
    WORD pp_Width;		/* Width of pointer */
    WORD pp_XOffset;		/* X offset of hotspot */
    WORD pp_YOffset;		/* Y offset of hotspot */
    WORD pp_CRegs[3];		/* Color spec */
    LONG pp_DSize;		/* Size of data */
};
