/*
**	$Filename: dynamicimages.h $
**	$Release: 1.4 $
**
**	definitions for use with dynamicimages
**
**	(C) Copyright 1989 Commodore-Amiga, Inc.
**	    All Rights Reserved Worldwide
*/

#define AREA_SIZE 200

struct DynamicImage
{
    struct Image di_image;	/* Image structure to draw/display */
    struct BitMap di_bmap;	/* Image's BitMap */
    struct RastPort di_rport;	/* Image's RastPort */
    ULONG di_size;		/* Size of ImageData */

    struct TmpRas di_tmpras;	/* Flood Fill TmpRas */
    UBYTE *di_workspace;	/* Flood Fill workspace */

    struct AreaInfo di_area;	/* Area Fill AreaInfo */
    WORD di_array[AREA_SIZE];	/* Area Fill workspace */

    struct Layer_Info *di_li;	/* Layer_Info for layer manipulations */
    struct Layer *di_layer;	/* Layer structure */
    ULONG Flags;		/* Application Flags -- see defines */
};

/* Application Flags.
 * Used to indicate what parts of the DynamicImage need
 * to be initialized.
 */
#define DI_FILL		(1L<<0)
#define	DI_LAYER	(1L<<1)

/* DynamicImages.c: Function Prototypes */
VOID InitDynamicImage (struct DynamicImage *, USHORT, USHORT, USHORT);
BOOL AllocDynamicImage (struct DynamicImage *);
VOID FreeDynamicImage (struct DynamicImage *);
