/*************************************************************************
  *                                                                      *
  *                            Preliminary                               *
  *                        Amiga AppShell (tm)                           *
  *                                                                      *
  *  Copyright (c) 1990,1991 Commodore-Amiga, Inc. All Rights Reserved.  *
  *                                                                      *
  *   This software and information is proprietary, preliminary, and     *
  *   subject to change without notice.                                  *
  *                                                                      *
  *                            DISCLAIMER                                *
  *                                                                      *
  *   THIS SOFTWARE IS PROVIDED "AS IS".                                 *
  *   NO REPRESENTATIONS OR WARRANTIES ARE MADE WITH RESPECT TO THE      *
  *   ACCURACY, RELIABILITY, PERFORMANCE, CURRENTNESS, OR OPERATION      *
  *   OF THIS SOFTWARE, AND ALL USE IS AT YOUR OWN RISK.                 *
  *   NEITHER COMMODORE NOR THE AUTHORS ASSUME ANY RESPONSIBILITY OR     *
  *   LIABILITY WHATSOEVER WITH RESPECT TO YOUR USE OF THIS SOFTWARE.    *
  *                                                                      *
  *                          Non-Disclosure                              *
  *                                                                      *
  *   This information is not to be disclosed to any other company,      *
  *   individual or party.  Discussion is to be restricted to CBM        *
  *   approved discussion areas, such as the closed conferences on bix;  *
  *   amiga.cert, amiga.com, amiga.beta/appshell.                        *
  *                                                                      *
  ************************************************************************
  */

/* clipiff.h
 * Header file for IFF clipboard routines.
 * Copyright (C) 1990 Commodore-Amiga, Inc.
 * Written by David N. Junod, 26-Aug-90
 *
 */

#include <exec/types.h>
#include <exec/semaphores.h>
#include <devices/clipboard.h>
#include <libraries/iffparse.h>
#include <utility/hooks.h>

#define	EXAMPLE	TRUE
#define	MAX_UNITS	256

/* Our errors */
#define	RC_EMPTY_CLIP		-1L	/* Clipboard is empty */
#define	RC_NOT_ENOUGH_MEMORY	-4L	/* not enough memory */
#define	RC_COULDNT_READ		-5L	/* Couldn't read a chunk */
#define	RC_BAD_IFF		-8L	/* Clipboard contains a bad IFF */
#define	RC_INVALID_TYPE		-9L	/* don't understand FORM type */

/* text stuff */
#define	ID_FTXT		MAKE_ID('F','T','X','T')
#define	ID_CHRS		MAKE_ID('C','H','R','S')
#define	ID_AUTH		MAKE_ID('A','U','T','H')
#define	ID_NAME		MAKE_ID('N','A','M','E')

/* not really a valid chunk type */
#define	ID_SPACE	MAKE_ID(' ',' ',' ',' ')

/* Clip.c: function prototypes */
struct ClipManager * __asm AllocClip (VOID);
VOID __asm FreeClip (register __a1 struct ClipManager *cm);
struct ClipBuff * __asm ReadClip (register __a1 struct ClipManager *,register __d0 LONG,register __d1 LONG );
LONG __asm WriteClip (register __a1 struct ClipManager *,register __a2 struct ClipBuff *,register __d0 LONG);
struct IFFHandle *__asm OpenClip (register __d0 LONG id);
VOID __asm CloseClip (register __a1 struct IFFHandle *iff);
VOID __asm FreeBuffer (register __a1 struct ClipBuff *buff);
LONG __asm WriteChunk (register __a1 struct IFFHandle *iff , register __d0 LONG id, register __a2 STRPTR );
struct ClipBuff * __asm ReadFTXT (register __a1 struct IFFHandle * iff );
LONG __asm WriteFTXT (register __a1 struct IFFHandle *iff , register __a2 STRPTR buffer );
LONG __asm QueryClip (register __a1 struct ClipManager *,register __d0 LONG,register __a2 ULONG *,register __a3 ULONG *);
LONG __asm StartClipChangeHook (register __a1 struct ClipManager *,register __d0 LONG);
LONG __asm StopClipChangeHook (register __a1 struct ClipManager *);

/* Return the contents of the clipboard */
struct ClipBuff
{
    LONG b_ClipID;		/* Clip ID of assigned to contents */
    LONG b_Type;		/* Content type of buffer */
    VOID *b_Buff;		/* Pointer to the buffer area */
    LONG b_Size;		/* Size of buffer (plus structure) */
};

/* Clipboard manager */
struct ClipManager
{
    struct IFFHandle *cm_Unit[MAX_UNITS];/* Handle for each possible unit */
    struct ClipBuff *cm_Buff[MAX_UNITS];/* Buffer for each possible unit */
    struct Hook cm_Hook;		/* Change hook (only one for me) */
    LONG cm_HookUnit;			/* Unit hook was installed for */
};

/* IFF parse library base */
extern struct Library *IFFParseBase;
