typedef	struct 
{
   short x,y;
} POINT;

int install_rlm(void *Unit,char *filename, ULONG *ModuleStart);


/* Prototypes for functions defined in a2410.c */
void bitblt(short w,
            short h,
            short xs,
            short ys,
            short xd,
            short yd);
int cd_is_alive(void);
void clear_frame_buffer(long color);
void clear_page(long color);
void clear_screen(unsigned long color);
void cop2gsp(short copid,
             long copaddr,
             long gspaddr,
             long length);
short cpw(short x,
          short y);
int create_alm(char *rlm_name,
               char *alm_name);
short create_esym(void);
int delete_font(short id);
void dma16_gsp2gsp(int a,
                   int b,
                   int c,
                   int d);
void dma_gsp2hostxy(unsigned long saddr,
                    unsigned long sptch,
                    unsigned long daddr,
                    unsigned long dptch,
                    short sx,
                    short sy,
                    short dx,
                    short dy,
                    short xext,
                    short yext,
                    short psize,
                    short swap);
void dma_host2gspxy(unsigned long saddr,
                    unsigned long sptch,
                    unsigned long daddr,
                    unsigned long dptch,
                    short sx,
                    short sy,
                    short dx,
                    short dy,
                    short xext,
                    short yext,
                    short psize,
                    short swap);
void draw_line(short x1,
               short y1,
               short x2,
               short y2);
void draw_oval(short w,
               short h,
               short xleft,
               short ytop);
void draw_ovalarc(short w,
                  short h,
                  short xleft,
                  short ytop,
                  short theta,
                  short arc);
void draw_piearc(short w,
                 short h,
                 short xleft,
                 short ytop,
                 short theta,
                 short arc);
int draw_plane(short planecode);
void draw_point(short x,
                short y);
void draw_polyline(short n,
                   POINT *vert);
void draw_polyline_a(short n,
                     POINT *vert);
void draw_rect(short w,
               short h,
               short xleft,
               short ytop);
unsigned long field_extract(PTR gptr,
                            unsigned short fs);
void field_insert(PTR gptr,
                  unsigned short fs,
                  unsigned long val);
void fill_convex(short n,
                 POINT *vert);
void fill_convex_a(short n,
                   POINT *vert);
void fill_oval(short w,
               short h,
               short xleft,
               short ytop);
void fill_piearc(short w,
                 short h,
                 short xleft,
                 short ytop,
                 short theta,
                 short arc);
void fill_polygon(short n,
                  POINT *vert);
void fill_polygon_a(short n,
                    POINT *vert);
void fill_rect(short w,
               short h,
               short xleft,
               short ytop);
int flush_esym(void);
void frame_oval(short w,
                short h,
                short xleft,
                short ytop,
                short dx,
                short dy);
void frame_rect(short w,
                short h,
                short xleft,
                short ytop,
                short dx,
                short dy);
int function_implemented(short function_code);
void get_colors(short *fcolor,
                short *bcolor);
void get_config(CONFIG *config);
int get_curs_state(void);
void get_curs_xy(short *px,
                 short *py);
void get_env(ENVIRONMENT *env);
int get_fontinfo(short id,
                 FONTINFO *pfontinfo);
void get_isr_priorities(short numisrs,
                        short *ptr);
int get_modeinfo(short index,
                 MODEINFO *modeinfo);
long get_nearest_color(char r,
                       char g,
                       char b,
                       char i);
void get_offscreen_memory(short num_blocks,
                          OFFSCREEN_AREA *offscreen);
void get_palet(short palet_size,
               PALET *palet);
int get_palet_entry(long index,
                    char *r,
                    char *g,
                    char *b,
                    char *i);
long get_pixel(short x,
               short y);
long get_pmask(void);
int get_ppop(void);
int get_state(void);
int get_textattr(char *pcontrol,
                 short count,
                 short *val);
int get_transp(void);
PTR get_vector(unsigned short trapnum);
int get_videomode(void);
int get_windowing(void);
short get_wksp(PTR *addr,
               unsigned long *pitch);
void gsp2cop(short copid,
             long gspaddr,
             long copaddr,
             long length);
void gsp2gsp(long src,
             long dst,
             unsigned long length);
void gsp2host(long gptr,
              char *hptr,
              unsigned short length,
              short swizzle);
void gsp2hostxy(long saddr,
                long sptch,
                char *daddr,
                long dptch,
                short sx,
                short sy,
                short dx,
                short dy,
                short xext,
                short yext,
                short psize,
                short swizzle);
long gsp_calloc(long nmemb,
                long size);
void gsp_execute(unsigned long entry_point);
int gsp_free(long ptr);
int gsp_halt(void);
long gsp_malloc(long size);
long gsp_maxheap(void);
void gsp_minit(long stack_size);
unsigned long gsp_realloc(long ptr,
                          long size);
void host2gsp(char *hptr,
              long gptr,
              unsigned short length,
              short swizzle);
void host2gspxy(char *saddr,
                long sptch,
                long daddr,
                long dptch,
                short sx,
                short sy,
                short dx,
                short dy,
                short xext,
                short yext,
                short psize,
                short swizzle);
void init_palet(void);
void init_text(void);
int install_alm(char *alm_name);
int install_font(unsigned long pfont);
int install_primitives(void);
void install_usererror(void (*function_name)(void));
short lmo(long n);
unsigned long loadcoff(char *filename);
short page_busy(void);
short page_flip(short disp,
                short draw);
void patnfill_convex(short n,
                     POINT *vert);
void patnfill_oval(short w,
                   short h,
                   short xleft,
                   short ytop);
void patnfill_piearc(short w,
                     short h,
                     short xleft,
                     short ytop,
                     short theta,
                     short arc);
void patnfill_polygon(short n,
                      POINT *vert);
void patnfill_polygon_a(short n,
                        POINT *vert);
void patnfill_rect(short w,
                   short h,
                   short xleft,
                   short ytop);
void patnframe_oval(short w,
                    short h,
                    short xleft,
                    short ytop,
                    short dx,
                    short dy);
void patnframe_rect(short w,
                    short h,
                    short xleft,
                    short ytop,
                    short dx,
                    short dy);
void patnpen_line(short x1,
                  short y1,
                  short x2,
                  short y2);
void patnpen_ovalarc(short w,
                     short h,
                     short xleft,
                     short ytop,
                     short theta,
                     short arc);
void patnpen_piearc(short w,
                    short h,
                    short xleft,
                    short ytop,
                    short theta,
                    short arc);
void patnpen_point(short x,
                   short y);
void patnpen_polyline(short n,
                      POINT *vert);
void patnpen_polyline_a(short n,
                        POINT *vert);
long peek_breg(short breg);
void pen_line(short x1,
              short y1,
              short x2,
              short y2);
void pen_ovalarc(short w,
                 short h,
                 short xleft,
                 short ytop,
                 short theta,
                 short arc);
void pen_piearc(short w,
                short h,
                short xleft,
                short ytop,
                short theta,
                short arc);
void pen_point(short x,
               short y);
void pen_polyline(short n,
                  POINT *vert);
void pen_polyline_a(short n,
                    POINT *vert);
void poke_breg(long breg,
               short val);
int rmo(long n);
void seed_fill(short x,
               short y,
               long buf,
               short maxbytes);
void seed_patnfill(short x,
                   short y,
                   long buf,
                   short maxbytes);
int see_planes(short planecode);
int select_font(short id);
int select_plane(int a);
void set_bcolor(long color);
void set_clip_rect(unsigned short w,
                   unsigned short h,
                   short xleft,
                   short ytop);
void set_colors(long fcolor,
                long bcolor);
int set_config(short graphics_mode,
               short init_draw);
void set_curs_shape(long shape);
void set_curs_state(short enable);
void set_curs_xy(short x,
                 short y);
void set_draw_origin(short x,
                     short y);
void set_dstbm(long baseaddr,
               short pitch,
               short xext,
               short yext,
               short psize);
void set_fcolor(long color);
short set_interrupt(short level,
                    short priority,
                    short enable,
                    short scan_line);
int set_mode_bit(unsigned short bitval);
int set_ovl_color(short i,
                  short r,
                  short g,
                  short b);
void set_palet(long count,
               long index,
               PALET *palet);
short set_palet_entry(long index,
                      unsigned char r,
                      unsigned char g,
                      unsigned char b,
                      unsigned char i);
void set_patn(PATTERN *ppatn);
void set_pensize(short w,
                 short h);
void set_pmask(long pmask);
void set_ppop(short ppop);
int set_spec_reg(unsigned short regval);
void set_srcbm(long baseaddr,
               short pitch,
               short xext,
               short yext,
               short psize);
int set_swap_bit(unsigned short bitval);
int set_sync_bit(unsigned short bitval);
int set_textattr(char *pcontrol,
                 short count,
                 short *val);
void set_timeout(short value);
void set_transp(short mode);
unsigned long set_vector(short trapnum,
                         unsigned long gptr);
int set_videomode(short mode,
                  short style);
void set_windowing(short mode);
void set_wksp(unsigned long addr,
              unsigned long pitch);
void styled_line(short x1,
                 short y1,
                 short x2,
                 short y2,
                 long style,
                 short mode);
void swap_bm(void);
void synchronize(void);
int text_out(short x,
             short y,
             unsigned char *s);
int text_width(unsigned char *s);
void transp_off(void);
void transp_on(void);
void wait_scan(short line);
void zoom_rect(short ws,
               short hs,
               short xs,
               short ys,
               short wd,
               short hd,
               short xd,
               short yd,
               PTR rowbuf);
