#ifndef TIGA_TYPEDEFS_H
#define TIGA_TYPEDEFS_H
/*
**	$Filename: tiga/typedefs.h $
**	$Release: $$$RELEASE$$$ $
**
**	PUBLIC FILE
**
**	(C) Copyright 1988,1989,1990 University of Lowell
**                    Center for Productivity Enhancement
**      All Rights Reserved
**
**
** Purpose:
**    This file contains type definitions used in the Applications
**    Interface. This file should be included in any C program
**    accessing data of these types.
**
*/

#ifndef EXEC_TYPES_H
#include <exec/types.h>
#endif	/* !EXEC_TYPES_H */


#define MAX_PAGES               2     /* maximum number of display pages   */
#define MAX_OFFSCREEN           2     /* maximum number of offscreen areas */


/* ======================================================================= */
/* = Define integral data types ========================================== */
/* ======================================================================= */
typedef unsigned long   PTR;
typedef UBYTE far       *HPTR;



/* ======================================================================= */
/* = This structure contains cursor description information ============== */
/* ======================================================================= */
typedef struct 
{
    short   hot_x;      /* offset from top...  */
    short   hot_y;      /* ...left-hand corner */
    UWORD  width;      /* array width         */
    UWORD  height;     /* array height        */
    UWORD  pitch;
    ULONG   color;      /* color of cursor     */
    UWORD  mask_rop;   /* cursor mask rop     */
    UWORD  shape_rop;  /* cursor shape rop    */
    PTR     data;       /* pointer to cursor data in GSP memory */
} CURSOR;



/* ======================================================================= */
/* = This structure contains pattern description information ============= */
/* ======================================================================= */
typedef struct 
{
    UWORD  width;      /* width of pattern    */
    UWORD  height;     /* height of pattern   */
    UWORD  depth;      /* depth (bits/pixel)  */
    PTR     data;       /* address of pattern in GSP memory */
} PATTERN;



/* ======================================================================= */
/* = This structure contains the RGB and intensity components for a ====== */
/* = palette entry.                                                 ====== */
/* ======================================================================= */
typedef struct 
{
    UBYTE   r;
    UBYTE   g;
    UBYTE   b;
    UBYTE   i;
} PALET;



/* ======================================================================= */
/* = This structure contains video timing parameters ===================== */
/* ======================================================================= */
typedef struct
{
    UWORD  hesync;
    UWORD  heblnk;
    UWORD  hsblnk;
    UWORD  htotal;
    UWORD  vesync;
    UWORD  veblnk;
    UWORD  vsblnk;
    UWORD  vtotal;
    UWORD  dpyctl;
    UWORD  screen_delay;
    UWORD  flags;
} MONITORINFO;



/* ======================================================================= */
/* = These structures contain definitions of offscreen work areas ======== */
/* ======================================================================= */
typedef struct 
{
    PTR     addr;   /* address in gsp space of an offscreen work area */
    UWORD  xext;   /* x extension in the current screen pixel size   */
    UWORD  yext;   /* y extension using default screen pitch         */
} OFFSCREEN_AREA;



/* ======================================================================= */
/* = These structures contain definitions used to implement multiple ===== */
/* = display pages. The information in these structures is used to   ===== */
/* = display a given page                                            ===== */
/* ======================================================================= */
typedef struct 
{
    PTR     BaseAddr;   /* Base address of start of page                */
    UWORD  DpyStart;   /* Value loaded in Display Start i/o register   */
    short   DummyPad;   /* 16 bits to pad structure to power of 2 size  */
} PAGE;                 



/* ======================================================================= */
/* = This structure contains information pertaining to the current mode == */
/* = of operation                                                       == */
/* ======================================================================= */
typedef struct
{
    ULONG   disp_pitch;         /* display pitch y::x                   */
    UWORD  disp_vres;          /* vertical resolution (pixels)         */
    UWORD  disp_hres;          /* horizontal resolution (pixels)       */
    short   screen_wide;        /* screen width                         */
    short   screen_high;        /* screen height                        */
    UWORD  disp_psize;         /* pixel size                           */
    ULONG   pixel_mask;         /* pixel mask                           */
    UWORD  palet_gun_depth;    /* # of bits per gun                    */    
    ULONG   palet_size;         /* number of palette entries            */
    short   palet_inset;        /* offset from frame start to data      */ 
    UWORD  num_pages;          /* number of display pages              */
    short   num_offscrn_areas;  /* number off offscreen work areas      */
    ULONG   wksp_addr;          /* address of offscreen workspace       */
    ULONG   wksp_pitch;         /* pitch of offscreen workspace         */
} MODEINFO;



/* ======================================================================= */
/* = This structure contains the current hardware operating configuration= */
/* ======================================================================= */
typedef struct 
{
    UWORD      version_number;
    ULONG       comm_buff_size;
    ULONG       sys_flags;
    ULONG       device_rev;
    UWORD      num_modes;
    UWORD      current_mode;
    ULONG       program_mem_start;
    ULONG       program_mem_end;
    ULONG       display_mem_start;
    ULONG       display_mem_end;
    ULONG       stack_size;
    ULONG       shared_mem_size;
    HPTR        shared_host_addr;
    PTR         shared_gsp_addr;
    MODEINFO    mode;
} CONFIG;



/* ======================================================================= */
/* = This structure contains the current values of environment global ==== */
/* = variables                                                        ==== */
/* ======================================================================= */
typedef struct 
{
    ULONG   xyorigin;      /* xy drawing origin      */
    ULONG   pensize;       /* pensize height::width  */
    PTR     srcbm;         /* source bitmap struct   */
    PTR     dstbm;         /*   dest bitmap struct   */
    ULONG   stylemask;     /* styled line patn mask  */
} ENVIRONMENT;



/* ======================================================================= */
/* = This structure defines the data associated with a function module === */
/* ======================================================================= */
typedef struct
{
    PTR     ListAddr;
    PTR     MallocAddr;
    ULONG   MallocBytes;
    UWORD  NumFuncs;
    UWORD  Dummy;
} MODULE;



/* ======================================================================= */
/* = This structure defines the data associated with a font ============== */
/* ======================================================================= */
typedef struct
{
    UWORD magic;        /* font type code                               */
    long   length;       /* Length of font in bytes                      */
    char   facename[32];
    short  first;        /* ASCII code of first character                */
    short  last;         /* ASCII code of last character                 */
    short  maxwide;      /* maximum character width                      */
    short  maxkern;      /* maximum character kerning amount             */
    short  charwide;     /* Width of characters (0 if proportional)      */
    short  avgwide;      /* Average width of characters                  */
    short  charhigh;     /* character height                             */
    short  ascent;       /* ascent (how far above base line)             */
    short  descent;      /* descent (how far below base line)            */
    short  leading;      /* leading (row bottom to next row top)         */
    long   rowpitch;     /* bits per row of char patterns                */
    long   oPatnTbl;     /* Bit offset to PatnTbl (from bof)             */
    long   oLocTbl;      /* Bit offset to LocTbl (from bof)              */
    long   oOwTbl;       /* Bit offset to OWTbl (from bof)               */
} FONT;



/* ======================================================================= */
/* = FONTINFO   structure definition ===================================== */
/* ======================================================================= */
typedef struct
{
    char  facename[32];
    short first;        /* ASCII code of first character                */
    short last;         /* ASCII code of last character                 */
    short maxwide;      /* maximum character width                      */
    short avgwide;      /* Average width of characters                  */
    short maxkern;      /* Max character kerning amount                 */
    short charwide;     /* Width of characters (0=proportional)         */
    short charhigh;     /* character height                             */
    short ascent;       /* ascent (how far above base line)             */
    short descent;      /* descent (how far below base line)            */
    short leading;      /* leading (row bottom to next row top)         */
    PTR   fontptr;      /* address of font in gsp memory                */
    short id;           /* id of font (set at install time)             */
} FONTINFO;

/* ======================================================================= */
/* = HEADER structure definition ========================================= */
/* ======================================================================= */

typedef struct
{
   UWORD         Monitor;
   UWORD         Mode_Info_offset;
   UWORD         Monitor_Info_offset;
   UWORD         Page_Info_offset;
   UWORD         Off_Screen_offset;
   UWORD         endsetup_offset;
} HEADER;

/* ======================================================================= */
/* = SETUP structure definition ========================================== */
/* ======================================================================= */

typedef struct
{
   HEADER         header;
   MODEINFO       Mode_Info;
   MONITORINFO    Monitor_Info;
   PAGE           Page_Info[MAX_PAGES];
   OFFSCREEN_AREA Off_Screen[MAX_OFFSCREEN];
} SETUP;


#endif	/* TIGA_TYPEDEFS_H */
