#ifndef TIGA_TI_FUNCTION_NUMS_H
#define TIGA_TI_FUNCTION_NUMS_H
/*
**	$Filename: tiga/ti_function_nums.h $
**	$Release: $$$RELEASE$$$ $
**
**	PUBLIC FILE
**
**	(C) Copyright 1988,1989,1990 University of Lowell
**                    Center for Productivity Enhancement
**      All Rights Reserved
**
**
** Purpose:
**   Define command number modifiers
**
**
*/

#ifndef EXEC_TYPES_H
#include <exec/types.h>
#endif	/* !EXEC_TYPES_H */


#define CORE_CP(a)              ((a) | 0x7E00)		/* module 31 */
#define CORE_DM(a)              ((a) | 0x3E00)

#define EXT_CP(a)               ((a) | 0x7C00)		/* module 30 */
#define EXT_DM(a)               ((a) | 0x3C00)

/* Amiga-Specific Primitives                                         */
#define ASP_CP(a)               ((a) | 0x7A00)		/* module 29 */
#define ASP_DM(a)               ((a) | 0x3A00)	

#define USER_CP(a)              ((a) | 0x4000)
#define USER_DM(a)              ((a) | 0x0000)



/* ======================================================================= */
/* === Core Primitives =================================================== */
/* ======================================================================= */
#define ADD_INTERRUPT         CORE_CP( 0) 
#define DEL_INTERRUPT         CORE_CP( 1) 
#define FUNCTION_IMPLEMENTED  CORE_CP( 2) 
#define GET_COLORS            CORE_CP( 3) 
#define GET_CONFIG            CORE_CP( 4) 
#define GSP_MAXHEAP           CORE_CP( 6) 
#define GET_OFFSCREEN_MEMORY  CORE_CP( 7) 
#define GET_PALET_ENTRY       CORE_CP( 8) 
#define GET_PMASK             CORE_CP( 9) 
#define GET_PPOP              CORE_CP(10) 
#define GET_TRANSP            CORE_CP(11) 
#define GET_WINDOWING         CORE_CP(12) 
#define GSP_CALLOC            CORE_CP(13) 
#define GSP_FREE              CORE_CP(14) 
#define GSP_MALLOC            CORE_CP(15) 
#define GSP_MINIT             CORE_CP(16) 
#define GSP_REALLOC           CORE_CP(17) 
#define INIT_CURSOR           CORE_CP(18) 
#define SET_CONFIG            CORE_CP(20) 
#define PAGE_FLIP             CORE_CP(21) 
#define SET_PALET             CORE_CP(22) 
#define TRANSP_OFF            CORE_CP(23) 
#define TRANSP_ON             CORE_CP(24) 
#define VIDEO_ENABLE          CORE_CP(25) 
#define GET_STATE             CORE_CP(26) 
#define CLEAR_SCREEN          CORE_DM(27) 
#define GET_NEAREST_COLOR     CORE_DM(28) 
#define GET_PALET             CORE_CP(29) 
#define GSP2GSP               CORE_DM(30) 
#define INIT_PALET            CORE_DM(31) 
#define LMO                   CORE_DM(32) 
#define PALLOC                CORE_DM(33) 
#define PEEK_BREG             CORE_DM(34) 
#define POKE_BREG             CORE_DM(35) 
#define RMO                   CORE_DM(36) 
#define SET_BCOLOR            CORE_DM(37) 
#define SET_COLORS            CORE_DM(38) 
#define SET_FCOLOR            CORE_DM(39) 
#define SET_INTERRUPT         CORE_CP(40) 
#define SET_PALET_ENTRY       CORE_DM(41) 
#define SET_PMASK             CORE_DM(42) 
#define SET_PPOP              CORE_DM(43) 
#define SET_WINDOWING         CORE_DM(44) 
#define SET_CLIP_RECT         CORE_DM(45) 
#define WAIT_SCAN             CORE_CP(46) 
#define SET_WKSP              CORE_DM(47) 
#define ADD_MODULE            CORE_CP(48) 
#define DEL_MODULE            CORE_CP(49) 
#define DEL_ALL_MODULES       CORE_CP(50) 
#define GET_ISR_PRIORITIES    CORE_CP(51) 
#define INIT_INTERRUPTS       CORE_CP(52) 
#define SET_CURS_SHAPE        CORE_DM(53)
#define SET_CURS_STATE        CORE_DM(54) 
#define GET_CURS_STATE        CORE_CP(55) 
#define GET_CURS_XY           CORE_CP(56) 
#define FLUSH_EXTENDED        CORE_CP(57) 
#define PAGE_BUSY             CORE_CP(58) 
#define CLEAR_FRAME_BUFFER    CORE_DM(59) 
#define CLEAR_PAGE            CORE_DM(60) 
#define GET_WKSP              CORE_CP(61) 
#define CPW                   CORE_DM(62) 
#define INIT_TEXT             CORE_CP(63) 
#define TEXT_OUT              CORE_CP(64) 
#define GET_FONTINFO          CORE_CP(65) 
#define GET_MODULE            CORE_CP(66)
/* The following are NOT implemented due to hardware factors. */
#define COP2GSP		      CORE_CP(69)
#define GSP2COP		      CORE_CP(70)
#define SET_TRANSP	      CORE_CP(71)



/* ======================================================================= */
/* === Amiga Specific Primitives ========================================= */
/* ======================================================================= */
#define SET_SPEC_REG	      ASP_CP(0)
#define SET_MODE_BIT	      ASP_CP(1)
#define SET_SYNC_BIT          ASP_CP(2)
#define SET_SWAP_BIT	      ASP_CP(3)
#define SEE_PLANES	      ASP_CP(4)
#define DRAW_PLANE            ASP_CP(5)
#define SET_OVL_COLOR	      ASP_CP(6)
#define DMA16_GSP2GSP         ASP_DM(7) 
#define DMA_HOST2GSPXY	      ASP_CP(8)
#define DMA_GSP2HOSTXY	      ASP_CP(9)



/* ======================================================================= */
/* = Extended Function Command Numbers =================================== */
/* ======================================================================= */
#define SET_DSTBM           EXT_CP( 0)
#define SET_SRCBM           EXT_CP( 1)
#define STYLED_LINE         EXT_CP( 2)
#define SWAP_BM             EXT_CP( 3)
#define DRAW_POLYLINE_A     EXT_CP( 4)
#define FILL_CONVEX_A       EXT_CP( 5)
#define FILL_POLYGON_A      EXT_CP( 6)
#define PATNFILL_CONVEX_A   EXT_CP( 7)
#define PATNFILL_POLYGON_A  EXT_CP( 8)
#define PATNPEN_POLYLINE_A  EXT_CP( 9)
#define PEN_POLYLINE_A      EXT_CP(10)
#define BITBLT              EXT_DM(11)
#define DRAW_LINE           EXT_DM(12)
#define DRAW_OVAL           EXT_DM(13)
#define DRAW_OVALARC        EXT_DM(14)
#define DRAW_PIEARC         EXT_DM(15)
#define DRAW_POINT          EXT_DM(16)
#define DRAW_POLYLINE       EXT_DM(17)
#define DRAW_RECT           EXT_DM(18)
#define FILL_CONVEX         EXT_DM(19)
#define FILL_OVAL           EXT_DM(20)
#define FILL_PIEARC         EXT_DM(21)
#define FILL_POLYGON        EXT_DM(22)
#define FILL_RECT           EXT_DM(23)
#define FRAME_OVAL          EXT_DM(24)
#define FRAME_RECT          EXT_DM(25)
#define GET_PIXEL           EXT_DM(26)
#define PATNFILL_CONVEX     EXT_DM(27)
#define PATNFILL_OVAL       EXT_DM(28)
#define PATNFILL_PIEARC     EXT_DM(29)
#define PATNFILL_POLYGON    EXT_DM(30)
#define PATNFILL_RECT       EXT_DM(31)
#define PATNFRAME_OVAL      EXT_DM(32)
#define PATNFRAME_RECT      EXT_DM(33)
#define PATNPEN_LINE        EXT_DM(34)
#define PATNPEN_OVALARC     EXT_DM(35)
#define PATNPEN_PIEARC      EXT_DM(36)
#define PATNPEN_POINT       EXT_DM(37)
#define PATNPEN_POLYLINE    EXT_DM(38)
#define PEN_LINE            EXT_DM(39)
#define PEN_OVALARC         EXT_DM(40)
#define PEN_PIEARC          EXT_DM(41)
#define PEN_POINT           EXT_DM(42)
#define PEN_POLYLINE        EXT_DM(43)
#define SEED_FILL           EXT_DM(44)
#define SEED_PATNFILL       EXT_DM(45)
#define SET_DRAW_ORIGIN     EXT_DM(46)
#define SET_PENSIZE         EXT_DM(47)
#define ZOOM_RECT           EXT_DM(48)
#define SET_PATN            EXT_DM(49)
#define INSTALL_FONT        EXT_CP(50)
#define SELECT_FONT         EXT_CP(51)
#define DELETE_FONT         EXT_CP(52)
#define SET_TEXTATTR        EXT_CP(53)
#define GET_TEXTATTR        EXT_CP(54)
#define TEXT_WIDTH          EXT_CP(55)
#define GET_ENV             EXT_CP(56)

#endif	/*  TIGA_TI_FUNCTION_NUMS_H */
