#ifndef TIGA_GSPREGS_H
#define TIGA_GSPREGS_H
/*
**	$Filename: tiga/gspregs.h $
**	$Release: $$$RELEASE$$$ $
**
**	PUBLIC EXTENDER FILE
**
**	(C) Copyright 1988,1989,1990 University of Lowell
**                    Center for Productivity Enhancement
**      All Rights Reserved
**
**
** Purpose:
**    This file contains definitions for GSP registers It is useful for the
**    gsp side of an application, written in GSP-C, to use symbolic names
**    for GSP hardware
**
**
*/

/* ====================================================================== */
/* = Define names of special A- and B-file registers ==================== */
/* ====================================================================== */
#define FP        13    /* register A13 - Frame pointer, param. stack */
#define STK       14    /* register A14 - Parameter stack pointer     */
#define SADDR     0     /* register B0  - Source address register     */
#define SPTCH     1     /* register B1  - Source pitch register       */
#define DADDR     2     /* register B2  - Dest. address register      */
#define DPTCH     3     /* register B3  - Dest. pitch register        */
#define OFFSET    4     /* register B4  - XY offset register          */
#define WSTART    5     /* register B5  - Window start register       */
#define WEND      6     /* register B6  - Window end register         */
#define DYDX      7     /* register B7  - Delta X/delta Y register    */
#define COLOR0    8     /* register B8  - Color 0 register            */
#define COLOR1    9     /* register B9  - Color 1 register            */



/* ====================================================================== */
/* = Define base location of TMS34010's on-chip I/O register file. ====== */
/* ====================================================================== */
#define IO_BASE   0xC0000000    /* address of 1st I/O register */



/* ====================================================================== */
/* = Define names of I/O registers. ===================================== */
/* ====================================================================== */
#define HESYNC    0xC0000000
#define HEBLNK    0xC0000010
#define HSBLNK    0xC0000020
#define HTOTAL    0xC0000030
#define VESYNC    0xC0000040
#define VEBLNK    0xC0000050
#define VSBLNK    0xC0000060
#define VTOTAL    0xC0000070
#define DPYCTL    0xC0000080
#define DPYSTRT   0xC0000090
#define DPYINT    0xC00000A0
#define CONTROL   0xC00000B0
#define HSTDATA   0xC00000C0
#define HSTADRL   0xC00000D0
#define HSTADRH   0xC00000E0
#define HSTCTLL   0xC00000F0
#define HSTCTLH   0xC0000100
#define INTENB    0xC0000110
#define INTPEND   0xC0000120
#define CONVSP    0xC0000130
#define CONVDP    0xC0000140
#define PSIZE     0xC0000150
#define PMASK     0xC0000160
/*----- I/O registers 23-26 are reserved -----*/
#define DPYTAP    0xC00001B0
#define HCOUNT    0xC00001C0
#define VCOUNT    0xC00001D0
#define DPYADR    0xC00001E0
#define REFCNT    0xC00001F0



/* ====================================================================== */
/* = Masks for I/O register fields: ===================================== */
/* ====================================================================== */
#define TRN_MASK  0x20    /* Mask for T field in CONTROL */
#define WDW_MASK  0xC0    /* Mask for W field in CONTROL */
#define PBH_MASK  0x100   /* Mask for Pixblt Horizontal Dir. in CONTROL */
#define PBV_MASK  0x200   /* Mask for Pixblt Vertical Dir. in CONTROL   */
#define PPOP_MASK 0x7C00  /* Mask for PPOP in CONTROL    */
#define SRT_MASK  0x800   /* Mask for SRT bit in DPYCTL  */
#define SRE_MASK  0x1000  /* Mask for SRT bit in DPYCTL  */
#define ENV_MASK  0x8000  /* Mask for SRT bit in DPYCTL  */
#define DI_MASK   0x400   /* Mask for DI bit in INTPEND  */



/* ====================================================================== */
/* = Additional defines used for an Amiga host program ================== */
/* ====================================================================== */
#define HCTLHIADDR      0xC000
#define HCTLLOLOADDR    0X00F0
#define HCTLHILOADDR    0X0100

struct GSP_REG {
  unsigned short  hstadrl;
  unsigned short  hstadrh;
  unsigned short  hstdata;
  unsigned short  hstctl;
};


#endif	/*  TIGA_GSPREGS_H */
