#ifndef TIGA_DEV_MACROS_H
#define TIGA_DEV_MACROS_H
/*
**	$Filename: tiga/dev_macros.h $
**	$Release: $$$RELEASE$$$ $
**
**	PUBLIC FILE
**
**	(C) Copyright 1988,1989,1990 University of Lowell
**                    Center for Productivity Enhancement
**      All Rights Reserved
**
**
** Purpose:
**   Define C-interface device macros                                     
**
*/

#ifndef TIGA_DEVTIGA_H
#include <a2410/devtiga.h>
#endif	/* !TIGA_DEVTIGA_H */


#define add_commands(a,b,c,d,e)                    	\
(( 							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_ADD_COMMANDS,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define add_interrupt(a,b)                    		\
(( 							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_ADD_INTERRUPT,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define add_module(a,b)                    		\
(( 							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_ADD_MODULE,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define bitblt(a,b,c,d,e,f)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_BITBLT,		\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define cd_is_alive()					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_CD_IS_ALIVE,	\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)


#define clear_frame_buffer(a)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_CLEAR_FRAME_BUFFER,\
TIGADATANAME[0] = (LONG)(a),				\
DoIO(&TIGAREQNAME)					\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define clear_page(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_CLEAR_PAGE,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO(&TIGAREQNAME)					\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define clear_screen(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_CLEAR_SCREEN,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO(&TIGAREQNAME)					\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define del_commands(a,b,c)                    		\
(( 							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_DEL_COMMANDS,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define del_module(a)                    		\
(( 							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_DEL_MODULE,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define dma16_gsp2gsp(a,b,c,d)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_DMA16_GSP2GSP,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define delete_font(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_DELETE_FONT,	\
TIGADATANAME[0]=(LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define draw_line(a,b,c,d)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_DRAW_LINE, 	\
TIGADATANAME[0] = (LONG)(a), 				\
TIGADATANAME[1] = (LONG)(b), 				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define draw_oval(a,b,c,d)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_DRAW_OVAL,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define draw_ovalarc(a,b,c,d,e,f)			\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_DRAW_OVALARC,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define draw_plane(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_DRAW_PLANE,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define select_plane(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_DRAW_PLANE,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define draw_piearc(a,b,c,d,e,f)			\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_DRAW_PIEARC,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define draw_point(a,b)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_DRAW_POINT,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define draw_polyline(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_DRAW_POLYLINE_A,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define draw_polyline_a(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_DRAW_POLYLINE_A,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define draw_rect(a,b,c,d)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_DRAW_RECT, 	\
TIGADATANAME[0] = (LONG)(a), 				\
TIGADATANAME[1] = (LONG)(b), 				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define field_extract(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_FIELD_EXTRACT,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define field_insert(a,b,c)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_FIELD_INSERT,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define fill_convex(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_FILL_CONVEX,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define fill_convex_a(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_FILL_CONVEX_A,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)


#define fill_oval(a,b,c,d)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_FILL_OVAL,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define fill_piearc(a,b,c,d,e,f)			\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_FILL_PIEARC,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define fill_polygon(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_FILL_POLYGON,	\
TIGADATANAME[0] = (ULONG)(a),				\
TIGADATANAME[1] = (ULONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define fill_polygon_a(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_FILL_POLYGON_A,	\
TIGADATANAME[0] = (ULONG)(a),				\
TIGADATANAME[1] = (ULONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define fill_rect(a,b,c,d)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_FILL_RECT,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)


#define frame_oval(a,b,c,d,e,f)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_FRAME_OVAL,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define frame_rect(a,b,c,d,e,f)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_FRAME_RECT,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define function_implemented(a)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_FUNCTION_IMPLEMENTED,	\
TIGADATANAME[0] = (ULONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_colors(a,b)             			\
(( 							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_COLORS,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_config(a)					\
((   							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_CONFIG,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_curs_state()				\
((   							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_CURS_STATE,	\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_curs_xy(a,b)				\
((   							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_CURS_XY,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_env(a)					\
((   							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_ENV,		\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_fontinfo(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_FONTINFO,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_modeinfo(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_MODEINFO,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_nearest_color(a,b,c,d)			\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_NEAREST_COLOR,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_offscreen_memory(a,b)			\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_OFFSCREEN_MEMORY,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_palet(a,b)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_PALET,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_palet_entry(a,b,c,d,e)			\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_PALET_ENTRY,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_pixel(a,b)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_PIXEL,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_pmask()					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_PMASK,	\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_ppop()					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_PPOP,	\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_state()					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_STATE,	\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_textattr(a,b,c)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_TEXTATTR,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_transp()					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_TRANSP,	\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_videomode()					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_VIDEOMODE,	\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_windowing()					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_WINDOWING,	\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define get_wksp(a,b)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GET_WKSP,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define gsp_execute(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GSP_EXECUTE,	\
TIGADATANAME[0]=(LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define gsp_halt()					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GSP_HALT,	\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define gsp_calloc(a,b)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GSP_CALLOC,	\
TIGADATANAME[0]=(LONG)(a),				\
TIGADATANAME[1]=(LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define gsp_free(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GSP_FREE,	\
TIGADATANAME[0]=(LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define gsp_malloc(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GSP_MALLOC,	\
TIGADATANAME[0]=(LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define gsp_maxheap()					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GSP_MAXHEAP,	\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define gsp_realloc(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GSP_REALLOC,	\
TIGADATANAME[0]=(LONG)(a),				\
TIGADATANAME[1]=(LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define gsp2gsp(a,b,c)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GSP2GSP,		\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define gsp2host(a,b,c,d)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GSP2HOST,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define host2gsp(a,b,c,d)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_HOST2GSP,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define gsp2hostxy(a,b,c,d,e,f,g,h,i,j,k,l)		\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_GSP2HOSTXY,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
TIGADATANAME[6] = (LONG)(g),				\
TIGADATANAME[7] = (LONG)(h),				\
TIGADATANAME[8] = (LONG)(i),				\
TIGADATANAME[9] = (LONG)(j),				\
TIGADATANAME[10] = (LONG)(k),				\
TIGADATANAME[11] = (LONG)(l),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define host2gspxy(a,b,c,d,e,f,g,h,i,j,k,l)		\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_HOST2GSPXY,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
TIGADATANAME[6] = (LONG)(g),				\
TIGADATANAME[7] = (LONG)(h),				\
TIGADATANAME[8] = (LONG)(i),				\
TIGADATANAME[9] = (LONG)(j),				\
TIGADATANAME[10] = (LONG)(k),				\
TIGADATANAME[11] = (LONG)(l),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define dma_gsp2hostxy(a,b,c,d,e,f,g,h,i,j,k,l)		\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_DMA_GSP2HOSTXY,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
TIGADATANAME[6] = (LONG)(g),				\
TIGADATANAME[7] = (LONG)(h),				\
TIGADATANAME[8] = (LONG)(i),				\
TIGADATANAME[9] = (LONG)(j),				\
TIGADATANAME[10] = (LONG)(k),				\
TIGADATANAME[11] = (LONG)(l),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define dma_host2gspxy(a,b,c,d,e,f,g,h,i,j,k,l)		\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_DMA_HOST2GSPXY,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
TIGADATANAME[6] = (LONG)(g),				\
TIGADATANAME[7] = (LONG)(h),				\
TIGADATANAME[8] = (LONG)(i),				\
TIGADATANAME[9] = (LONG)(j),				\
TIGADATANAME[10] = (LONG)(k),				\
TIGADATANAME[11] = (LONG)(l),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define init_palet()					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_INIT_PALET,	\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define init_text()					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_INIT_TEXT,	\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define install_font(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_INSTALL_FONT,	\
TIGADATANAME[0]=(LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define install_primitives() (1)

#define lmo(a)						\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_LMO,		\
TIGADATANAME[0]=(LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define page_busy()					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PAGE_BUSY,	\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define page_flip(a,b)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PAGE_FLIP,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define patnfill_convex(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PATNFILL_CONVEX,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define patnfill_oval(a,b,c,d)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PATNFILL_OVAL,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define patnfill_piearc(a,b,c,d,e,f)			\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PATNFILL_PIEARC,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define patnfill_polygon(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PATNFILL_POLYGON,\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define patnfill_polygon_a(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PATNFILL_POLYGON_A,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define patnfill_rect(a,b,c,d)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PATNFILL_RECT,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define patnframe_oval(a,b,c,d,e,f)			\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PATNFRAME_OVAL,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define patnframe_rect(a,b,c,d,e,f)			\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PATNFRAME_RECT,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define patnpen_line(a,b,c,d)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PATNPEN_LINE, 	\
TIGADATANAME[0] = (LONG)(a), 				\
TIGADATANAME[1] = (LONG)(b), 				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define patnpen_ovalarc(a,b,c,d,e,f)			\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PATNPEN_OVALARC,	\
TIGADATANAME[0] = (LONG)(a), 				\
TIGADATANAME[1] = (LONG)(b), 				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define patnpen_piearc(a,b,c,d,e,f)			\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PATNPEN_PIEARC, 	\
TIGADATANAME[0] = (LONG)(a), 				\
TIGADATANAME[1] = (LONG)(b), 				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define patnpen_point(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PATNPEN_POINT, 	\
TIGADATANAME[0] = (LONG)(a), 				\
TIGADATANAME[1] = (LONG)(b), 				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define patnpen_polyline(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PATNPEN_POLYLINE,\
TIGADATANAME[0] = (LONG)(a), 				\
TIGADATANAME[1] = (LONG)(b), 				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)


#define patnpen_polyline_a(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PATNPEN_POLYLINE_A,	\
TIGADATANAME[0] = (LONG)(a), 				\
TIGADATANAME[1] = (LONG)(b), 				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)


#define peek_breg(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PEEK_BREG,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define pen_line(a,b,c,d)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PEN_LINE, 	\
TIGADATANAME[0] = (LONG)(a), 				\
TIGADATANAME[1] = (LONG)(b), 				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define pen_ovalarc(a,b,c,d,e,f)			\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PEN_OVALARC,	\
TIGADATANAME[0] = (LONG)(a), 				\
TIGADATANAME[1] = (LONG)(b), 				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define pen_piearc(a,b,c,d,e,f)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PEN_PIEARC, 	\
TIGADATANAME[0] = (LONG)(a), 				\
TIGADATANAME[1] = (LONG)(b), 				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define  pen_point(a,b)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PEN_POINT, 	\
TIGADATANAME[0] = (LONG)(a), 				\
TIGADATANAME[1] = (LONG)(b), 				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define  pen_polyline(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PEN_POLYLINE,	\
TIGADATANAME[0] = (LONG)(a), 				\
TIGADATANAME[1] = (LONG)(b), 				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define  pen_polyline_a(a,b)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_PEN_POLYLINE_A, 	\
TIGADATANAME[0] = (LONG)(a), 				\
TIGADATANAME[1] = (LONG)(b), 				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)


#define poke_breg(a,b)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_POKE_BREG,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define rmo(a)						\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_RMO,		\
TIGADATANAME[0]=(LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define seed_fill(a,b,c,d)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SEED_FILL,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define seed_patnfill(a,b,c,d)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SEED_PATNFILL,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define select_font(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SELECT_FONT,	\
TIGADATANAME[0]=(LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_bcolor(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_BCOLOR,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_clip_rect(a,b,c,d)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_CLIP_RECT,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_colors(a,b)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_COLORS,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_config(a,b)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_CONFIG,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_draw_origin(a,b)		  		\
((					  		\
   TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_DRAW_ORIGIN,	\
   TIGADATANAME[0] = (LONG)(a),		  		\
   TIGADATANAME[1] = (LONG)(b),		  		\
   DoIO((struct IORequest *)&TIGAREQNAME)		\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_dstbm(a,b,c,d,e)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_DSTBM,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)


#define set_fcolor(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_FCOLOR,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_palet(a,b,c)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_PALET,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_palet_entry(a,b,c,d,e)			\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_PALET_ENTRY,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_patn(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_PATN,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_pensize(a,b)		 		\
((					 		\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_PENSIZE,	\
TIGADATANAME[0] = (LONG)(a),		 		\
TIGADATANAME[1] = (LONG)(b),		 		\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_pmask(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_PMASK,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_ppop(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_PPOP,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_srcbm(a,b,c,d,e)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_SRCBM,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_textattr(a,b,c)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_TEXTATTR,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_videomode(a,b) 				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_VIDEOMODE,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_windowing(a)				\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_WINDOWING,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_wksp(a,b)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_WKSP,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define styled_line(a,b,c,d,e,f)			\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_STYLED_LINE,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define swap_bm()					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SWAP_BM,		\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define synchronize()					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SYNCHRONIZE,	\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define text_out(a,b,c)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_TEXT_OUT, 	\
TIGADATANAME[0] = (LONG)(a), 				\
TIGADATANAME[1] = (LONG)(b), 				\
TIGADATANAME[2] = (LONG)(c),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define text_width(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_TEXT_WIDTH, 	\
TIGADATANAME[0] = (LONG)(a), 				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define transp_off()					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_TRANSP_OFF,	\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define transp_on()					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_TRANSP_ON,	\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define zoom_rect(a,b,c,d,e,f,g,h,i)			\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_ZOOM_RECT,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
TIGADATANAME[4] = (LONG)(e),				\
TIGADATANAME[5] = (LONG)(f),				\
TIGADATANAME[6] = (LONG)(g),				\
TIGADATANAME[7] = (LONG)(h),				\
TIGADATANAME[8] = (LONG)(i),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define see_planes(a)					\
((							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SEE_PLANES,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)


#define set_curs_state(a) 				\
(( 							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_CURS_STATE, 	\
TIGADATANAME[0] = (a),					\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_curs_shape(a)				\
(( 							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_CURS_SHAPE,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_spec_reg(a)					\
(( 							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_SPEC_REG,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_mode_bit(a)					\
(( 							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_MODE_BIT,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_sync_bit(a)					\
(( 							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_SYNC_BIT,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_swap_bit(a)					\
(( 							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_SWAP_BIT,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_ovl_color(a,b,c,d)				\
(( 							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_OVL_COLOR,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
TIGADATANAME[2] = (LONG)(c),				\
TIGADATANAME[3] = (LONG)(d),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define set_curs_xy(a,b)				\
(( 							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_SET_CURS_XY,	\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define cpw(a,b)                    			\
(( 							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_CPW,		\
TIGADATANAME[0] = (LONG)(a),				\
TIGADATANAME[1] = (LONG)(b),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#define wait_scan(a)                    		\
(( 							\
TIGAREQNAME.tiga_Req.io_Command = TIGA_WAIT_SCAN,	\
TIGADATANAME[0] = (LONG)(a),				\
DoIO((struct IORequest *)&TIGAREQNAME)			\
)?TIGAREQNAME.tiga_Return:TIGAREQNAME.tiga_Return)

#endif	/*  TIGA_DEV_MACROS_H */
