#ifndef TIGA_DEVTIGA_H
#define TIGA_DEVTIGA_H
/*
**	$Filename: tiga/devtiga.h $
**	$Release: $$$RELEASE$$$ $
**
**	PUBLIC FILE
**
**	(C) Copyright 1988,1989,1990 University of Lowell
**                    Center for Productivity Enhancement
**      All Rights Reserved
*/

#ifndef EXEC_TYPES_H
#include <exec/types.h>
#endif	/* !EXEC_TYPES_H */

#ifndef EXEC_IO_H
#include <exec/io.h>
#endif	/* !EXEC_IO_H */

#define TIGA_SET_VIDEOMODE		CMD_NONSTD+0		/* core */
#define TIGA_HOST2GSP			CMD_NONSTD+1		/* core */
#define TIGA_GSP2HOST			CMD_NONSTD+2		/* core */
#define TIGA_SYNCHRONIZE		CMD_NONSTD+3  		/* core */
#define TIGA_INSTALL_USERERROR		CMD_NONSTD+4		/* core */
#define TIGA_FIELD_INSERT		CMD_NONSTD+5		/* core */
#define TIGA_FIELD_EXTRACT		CMD_NONSTD+6		/* core */
#define TIGA_SET_TIMEOUT		CMD_NONSTD+7		/* core */
#define TIGA_SET_CURS_XY		CMD_NONSTD+8		/* core */
#define TIGA_GET_ENV			CMD_NONSTD+9		/* core */
#define TIGA_GET_CONFIG			CMD_NONSTD+10		/* core */
#define TIGA_GET_OFFSCREEN_MEMORY	CMD_NONSTD+11		/* core */
#define TIGA_CD_IS_ALIVE		CMD_NONSTD+12 		/* core */   
#define TIGA_GET_FONTINFO		CMD_NONSTD+13 		/* core */
#define TIGA_SET_CONFIG			CMD_NONSTD+14 		/* core */
#define TIGA_GET_VIDEOMODE		CMD_NONSTD+15 		/* core */
#define TIGA_GET_PALET_ENTRY		CMD_NONSTD+16		/* core */
#define TIGA_HOST2GSPXY			CMD_NONSTD+17 		/* core */
#define TIGA_GSP2HOSTXY			CMD_NONSTD+18 		/* core */
#define TIGA_COP2GSP			CMD_NONSTD+19		/* core */
#define TIGA_GET_MODEINFO		CMD_NONSTD+20		/* core */	
#define TIGA_GET_PALET			CMD_NONSTD+21		/* core */	
#define TIGA_GET_VECTOR			CMD_NONSTD+22		/* core */
#define TIGA_GM_IS_ALIVE		CMD_NONSTD+23		/* core */
#define TIGA_GSP2COP			CMD_NONSTD+24		/* core */
#define TIGA_GSP_EXECUTE		CMD_NONSTD+25		/* core */
#define TIGA_GSP_HALT			CMD_NONSTD+26		/* core */	
#define TIGA_SET_VECTOR			CMD_NONSTD+27		/* core */
#define TIGA_SET_CURS_SHAPE		CMD_NONSTD+28		/* core */ 	
#define TIGA_CLEAR_FRAME_BUFFER		CMD_NONSTD+29		/* core */
#define TIGA_CLEAR_PAGE			CMD_NONSTD+30		/* core */
#define TIGA_CLEAR_SCREEN		CMD_NONSTD+31  		/* core */
#define TIGA_GSP2GSP			CMD_NONSTD+32		/* core */
#define TIGA_INIT_PALET			CMD_NONSTD+33		/* core */	
#define TIGA_POKE_BREG			CMD_NONSTD+34		/* core */	
#define TIGA_SET_BCOLOR			CMD_NONSTD+35		/* core */	
#define TIGA_SET_FCOLOR			CMD_NONSTD+36		/* core */
#define TIGA_SET_COLORS			CMD_NONSTD+37		/* core */
#define TIGA_SET_CLIP_RECT		CMD_NONSTD+38		/* core */	
#define TIGA_SET_CURS_STATE		CMD_NONSTD+39		/* core */	
#define TIGA_SET_PMASK			CMD_NONSTD+40		/* core */
#define TIGA_SET_PPOP			CMD_NONSTD+41		/* core */
#define TIGA_SET_TRANSP			CMD_NONSTD+42		/* core */
#define TIGA_SET_WINDOWING		CMD_NONSTD+43		/* core */
#define TIGA_SET_WKSP			CMD_NONSTD+44		/* core */
#define TIGA_GET_NEAREST_COLOR		CMD_NONSTD+45		/* core */
#define TIGA_LMO			CMD_NONSTD+46		/* core */
#define TIGA_PEEK_BREG			CMD_NONSTD+47		/* core */	
#define TIGA_RMO			CMD_NONSTD+48		/* core */
#define TIGA_SET_PALET_ENTRY		CMD_NONSTD+49		/* core */	
#define TIGA_CPW			CMD_NONSTD+50		/* core */
#define TIGA_GSP_MINIT			CMD_NONSTD+51		/* core */	
#define TIGA_PAGE_FLIP			CMD_NONSTD+52		/* core */	
#define TIGA_TRANSP_OFF			CMD_NONSTD+53		/* core */	
#define TIGA_TRANSP_ON			CMD_NONSTD+54		/* core */
#define TIGA_DEL_ALL_MODULES		CMD_NONSTD+55		/* core */	
#define TIGA_FLUSH_EXTENDED		CMD_NONSTD+56		/* core */	
#define TIGA_INIT_TEXT			CMD_NONSTD+57		/* core */	
#define TIGA_ADD_INTERRUPT		CMD_NONSTD+58		/* core */
#define TIGA_DEL_INTERRUPT		CMD_NONSTD+59		/* core */
#define TIGA_SET_INTERRUPT		CMD_NONSTD+60		/* core */
#define TIGA_FUNCTION_IMPLEMENTED	CMD_NONSTD+61		/* core */
#define TIGA_GSP_MAXHEAP		CMD_NONSTD+62		/* core */	
#define TIGA_GET_PMASK			CMD_NONSTD+63		/* core */
#define TIGA_GET_PPOP			CMD_NONSTD+64		/* core */
#define TIGA_GET_TRANSP			CMD_NONSTD+65		/* core */
#define TIGA_GET_WINDOWING		CMD_NONSTD+66		/* core */
#define TIGA_GSP_CALLOC			CMD_NONSTD+67		/* core */	
#define TIGA_GSP_FREE			CMD_NONSTD+68		/* core */
#define TIGA_GSP_MALLOC			CMD_NONSTD+69		/* core */
#define TIGA_GSP_REALLOC		CMD_NONSTD+70		/* core */
#define TIGA_INIT_CURSOR		CMD_NONSTD+71		/* core */	
#define TIGA_DEL_MODULE			CMD_NONSTD+72		/* core */
#define TIGA_WAIT_SCAN			CMD_NONSTD+73		/* core */	
#define TIGA_GET_CURS_STATE		CMD_NONSTD+74		/* core */
#define TIGA_PAGE_BUSY			CMD_NONSTD+75		/* core */	
#define TIGA_GET_COLORS			CMD_NONSTD+76		/* core */
#define TIGA_GET_ISR_PRIORITIES		CMD_NONSTD+77		/* core */
#define TIGA_GET_CURS_XY		CMD_NONSTD+78		/* core */	
#define TIGA_GET_WKSP			CMD_NONSTD+79		/* core */
#define TIGA_SET_PALET			CMD_NONSTD+80		/* core */	
#define TIGA_TEXT_OUT			CMD_NONSTD+81		/* core */
#define TIGA_ADD_MODULE			CMD_NONSTD+82
#define TIGA_DMA16_GSP2GSP		CMD_NONSTD+83		/* Amiga-specific */
#define TIGA_DMA_HOST2GSPXY		CMD_NONSTD+84		/* Amiga-specific */
#define TIGA_DMA_GSP2HOSTXY		CMD_NONSTD+85		/* Amiga-specific */
#define TIGA_SET_SPEC_REG		CMD_NONSTD+86		/* Amiga-specific */	
#define TIGA_SET_MODE_BIT		CMD_NONSTD+87		/* Amiga-specific */	
#define TIGA_SET_SYNC_BIT		CMD_NONSTD+88		/* Amiga-specific */	
#define TIGA_SET_SWAP_BIT		CMD_NONSTD+89		/* Amiga-specific */	
#define TIGA_DRAW_PLANE			CMD_NONSTD+90		/* Amiga-specific */	
#define TIGA_SEE_PLANES			CMD_NONSTD+91		/* Amiga-specific */	
#define TIGA_SET_OVL_COLOR		CMD_NONSTD+92		/* Amiga-specific */	
#define TIGA_SET_PATN			CMD_NONSTD+93		/* extended */
#define TIGA_BITBLT			CMD_NONSTD+94		/* extended */	
#define TIGA_DRAW_LINE			CMD_NONSTD+95		/* extended */	
#define TIGA_DRAW_OVAL			CMD_NONSTD+96		/* extended */	
#define TIGA_DRAW_OVALARC		CMD_NONSTD+97		/* extended */	
#define TIGA_DRAW_PIEARC		CMD_NONSTD+98		/* extended */	
#define TIGA_DRAW_POINT			CMD_NONSTD+99		/* extended */	
#define TIGA_DRAW_RECT			CMD_NONSTD+100		/* extended */	
#define TIGA_FILL_OVAL			CMD_NONSTD+101		/* extended */	
#define TIGA_FILL_PIEARC		CMD_NONSTD+102		/* extended */	
#define TIGA_FILL_RECT			CMD_NONSTD+103		/* extended */	
#define TIGA_FRAME_OVAL			CMD_NONSTD+104		/* extended */	
#define TIGA_FRAME_RECT			CMD_NONSTD+105		/* extended */	
#define TIGA_PATNFILL_OVAL		CMD_NONSTD+106		/* extended */	
#define TIGA_PATNFILL_PIEARC		CMD_NONSTD+107		/* extended */	
#define TIGA_PATNFILL_RECT		CMD_NONSTD+108		/* extended */	
#define TIGA_PATNFRAME_OVAL		CMD_NONSTD+109		/* extended */	
#define TIGA_PATNFRAME_RECT		CMD_NONSTD+110		/* extended */	
#define TIGA_PATNPEN_LINE		CMD_NONSTD+111		/* extended */	
#define TIGA_PATNPEN_OVALARC		CMD_NONSTD+112		/* extended */	
#define TIGA_PATNPEN_PIEARC		CMD_NONSTD+113		/* extended */	
#define TIGA_PATNPEN_POINT		CMD_NONSTD+114		/* extended */	
#define TIGA_PEN_LINE			CMD_NONSTD+115		/* extended */	
#define TIGA_PEN_OVALARC		CMD_NONSTD+116		/* extended */	
#define TIGA_PEN_PIEARC			CMD_NONSTD+117		/* extended */	
#define TIGA_PEN_POINT			CMD_NONSTD+118		/* extended */	
#define TIGA_SEED_FILL			CMD_NONSTD+119		/* extended */	
#define TIGA_SEED_PATNFILL		CMD_NONSTD+120		/* extended */	
#define TIGA_SET_DRAW_ORIGIN		CMD_NONSTD+121		/* extended */  
#define TIGA_SET_PENSIZE		CMD_NONSTD+122		/* extended */
#define TIGA_ZOOM_RECT			CMD_NONSTD+123		/* extended */	
#define TIGA_GET_PIXEL			CMD_NONSTD+124		/* extended */
#define TIGA_DRAW_POLYLINE		CMD_NONSTD+125		/* extended */	
#define TIGA_FILL_CONVEX		CMD_NONSTD+126		/* extended */	
#define TIGA_FILL_POLYGON		CMD_NONSTD+127		/* extended */	
#define TIGA_PATNFILL_CONVEX		CMD_NONSTD+128		/* extended */
#define TIGA_PATNFILL_POLYGON		CMD_NONSTD+129		/* extended */	
#define TIGA_PATNPEN_POLYLINE		CMD_NONSTD+130		/* extended */	
#define TIGA_PEN_POLYLINE		CMD_NONSTD+131		/* extended */	
#define TIGA_SET_DSTBM			CMD_NONSTD+132 		/* extended */	
#define TIGA_SET_SRCBM			CMD_NONSTD+133	 	/* extended */	
#define TIGA_SWAP_BM			CMD_NONSTD+134		/* extended */	
#define TIGA_STYLED_LINE		CMD_NONSTD+135		/* extended */	
#define TIGA_INSTALL_FONT		CMD_NONSTD+136		/* extended */	
#define TIGA_SELECT_FONT		CMD_NONSTD+137		/* extended */	
#define TIGA_DELETE_FONT		CMD_NONSTD+138		/* extended */	
#define TIGA_SET_TEXTATTR		CMD_NONSTD+139		/* extended */	
#define TIGA_TEXT_WIDTH			CMD_NONSTD+140		/* extended */	
#define TIGA_GET_TEXTATTR		CMD_NONSTD+141		/* extended */	
#define TIGA_DRAW_POLYLINE_A		CMD_NONSTD+142		/* extended */	
#define TIGA_FILL_CONVEX_A		CMD_NONSTD+143		/* extended */	
#define TIGA_FILL_POLYGON_A		CMD_NONSTD+144		/* extended */	
#define TIGA_PATNFILL_CONVEX_A		CMD_NONSTD+145		/* extended */	
#define TIGA_PATNFILL_POLYGON_A		CMD_NONSTD+146		/* extended */	
#define TIGA_PATNPEN_POLYLINE_A		CMD_NONSTD+147		/* extended */	
#define TIGA_PEN_POLYLINE_A		CMD_NONSTD+148		/* extended */	

#define TIGA_ADD_COMMANDS		CMD_NONSTD+153
#define TIGA_DEL_COMMANDS		CMD_NONSTD+154
#define TIGA_GET_STATE			CMD_NONSTD+155

/* ====================================================================== */
/* = Legal Video Modes ================================================== */
/* ====================================================================== */
#define TIGA             -2      /* do not change mode  */
#define PREVIOUS         -1      /* change mode to previous mode, if valid*/
#define MODE_1024x768_NI  0
#define MODE_800x600_NI   1
#define MODE_640x400_I    2
#define MODE_1024x768_I   3
#define MODE_1024x1024_NI 4
#define MODE_736x480_NI   5
#define MODE_1024x1024_NI_67point88MHz 6

#define OSC1		0x4000	/* Oscillator #1 */
#define OSC2		0x8000  /* Oscillator #2 */
#define MODE_MASK	0x3fff


/* ====================================================================== */
/* = Legal Styles ======================================================= */
/* ====================================================================== */
#define NO_INIT         0        /* generate entry to device only */
#define INIT_GLOBALS    1        /* initialize global variables, retain heap */
#define INIT            3        /* initialize globals and free all heap...  */
                                 /* including downloaded functions           */
#define CLR_SCREEN      0x8000   /* clear the screen on entry to the mode    */


/* ====================================================================== */
/* = Default TIGA palet colors ========================================== */
/* ====================================================================== */
#define  BLACK          0
#define  BLUE           1
#define  GREEN          2
#define  CYAN           3
#define  RED            4
#define  MAGENTA        5
#define  BROWN          6
#define  LIGHT_GRAY     7
#define  DARK_GRAY      8
#define  LIGHT_BLUE     9
#define  LIGHT_GREEN    10
#define  LIGHT_CYAN     11
#define  LIGHT_RED      12
#define  LIGHT_MAGENTA  13
#define  YELLOW         14
#define  WHITE          15

/* ====================================================================== */
/* = TIGA Device Request structure ====================================== */
/* ====================================================================== */
/***************************************************************************
** NOTICE: If you use the TIGA device, you MUST use an IOExtTiga sized    **
** IO request or you may overwrite innocent memory!!!                     **
***************************************************************************/
/* !!! THIS REPLACES struct TigaIOReq !!! 12/06/90 - AKO */
struct IOExtTiga {
   struct IOStdReq tiga_Req;
   LONG            tiga_Return;
};



#define LOCK_UNIT  0x00000001
#define TIGA_DATA_SIZE  100

#define TIGADEVICENAME "a2410.device"
#define TIGADATANAME    _TIGADATA_
#define TIGAREQNAME     _TIGAREQUEST_
#define TIGAPORTNAME    _TIGAPORT_



extern LONG             TIGADATANAME[TIGA_DATA_SIZE];	/* TIGA data block */
extern struct IOExtTiga TIGAREQNAME;          		/* TIGA IO block */



#endif	/*  TIGA_DEVTIGA_H */
