/* 
	TIGA main module 
	$Header: Devel:Tiga/TIGA_DEVEL/Allan/wb/RCS/tigamain.c,v 1.1 91/05/08 16:26:46 havemose Exp Locker: havemose $

	This module contains various small (and helpful) support routines.
	Compile with -dTIGA_MAC if you don't want to use A2410.lib
*/
#include <lattice/stdio.h>
#include <a2410/typedefs.h>
#include <a2410/devtiga.h>
#include <a2410/ti_function_nums.h>
#ifdef	TIGA_MAC
#include <a2410/dev_macros.h>
#else
#include <clib/a2410_protos.h>
#endif
#include <lattice/math.h>

LONG TIGADATANAME[TIGA_DATA_SIZE];	/* data area for macros */
struct IOExtTiga TIGAREQNAME;          /* TIGA IORequest for macros */

/* =================================================================================== */

BOOL	TIGA_Init(void)
{
	int	unit=0;
	/* setup the IORequest */
   	TIGAREQNAME.tiga_Req.io_Message.mn_Node.ln_Succ	=	NULL;
   	TIGAREQNAME.tiga_Req.io_Message.mn_Node.ln_Pred	=	NULL;
	TIGAREQNAME.tiga_Req.io_Message.mn_Node.ln_Type = 	NT_MESSAGE;
   	TIGAREQNAME.tiga_Req.io_Message.mn_Node.ln_Pri	=	0;
   	TIGAREQNAME.tiga_Req.io_Message.mn_Node.ln_Name=NULL;
   	TIGAREQNAME.tiga_Req.io_Message.mn_Length=0;
   	TIGAREQNAME.tiga_Req.io_Device=NULL;
   	TIGAREQNAME.tiga_Req.io_Unit=NULL;
   	TIGAREQNAME.tiga_Req.io_Command=CMD_INVALID;
   	TIGAREQNAME.tiga_Req.io_Flags=0;
   	TIGAREQNAME.tiga_Req.io_Error=0;
   	TIGAREQNAME.tiga_Req.io_Actual=0;
   	TIGAREQNAME.tiga_Req.io_Length=-1;
   	TIGAREQNAME.tiga_Req.io_Data=(APTR)TIGADATANAME;
   	TIGAREQNAME.tiga_Req.io_Offset=0;
   	TIGAREQNAME.tiga_Return=0;

	TIGAREQNAME.tiga_Req.io_Message.mn_ReplyPort = (struct Port *)CreatePort(NULL,0);
	if (TIGAREQNAME.tiga_Req.io_Message.mn_ReplyPort == NULL)
	 {
		printf("Can't create the reply port\n");
		return FALSE;
 	 }

	/* open the device */
	if ((OpenDevice(TIGADEVICENAME,unit,&TIGAREQNAME,LOCK_UNIT)) != NULL)
	 {
		printf("can't open a2410 device\n");
		DeletePort(TIGAREQNAME.tiga_Req.io_Message.mn_ReplyPort);
		return FALSE;
	 }

	/* get TIGA going */
	if  (!set_videomode(TIGA, CLR_SCREEN|INIT))
	 {
		printf("FATAL ERROR - unable to initialize TIGA ...\n");
		CloseDevice(&TIGAREQNAME);
		DeletePort(TIGAREQNAME.tiga_Req.io_Message.mn_ReplyPort);
		return FALSE;
	 }
	return TRUE;
}
/* -------------------------------------------------------------------------------- */

void	TIGA_Close(void)
{
	CloseDevice(&TIGAREQNAME);
	DeletePort(TIGAREQNAME.tiga_Req.io_Message.mn_ReplyPort);
	TIGAREQNAME.tiga_Req.io_Message.mn_ReplyPort = NULL;
}
/* -------------------------------------------------------------------------------- */
void	TIGA_Break(void)
{
	TIGA_Close();
	exit(0);
}
/* -------------------------------------------------------------------------------- */
void	TIGA_SetRandPalet(void)
{
	int	i;
	CONFIG	config;

	get_config(&config);
	if(function_implemented(SET_PALET_ENTRY))
	{
	  for (i=1; i<config.mode.palet_size; i++)
	   {
		set_palet_entry(i, rand() & 0xff,
		  		   rand() & 0xff,
				   rand() & 0xff,
				   rand() & 0xff);
	   }
	}
}
/* -------------------------------------------------------------------------------- */

#if 0

Typical TIGA application struture:

void main(int argc, char **argv)
{
	if (TIGA_Init())
	 {
	    	YourFunction();
		TIGA_Close();
	 }
}

or if you want to install CTRL-C break

void main(int argc, char **argv)
{
	if (TIGA_Init())
	 {
		onbreak(TIGA_Break);
	    	YourFunction();	/* check for CTRL-C by using chkabort() */
		TIGA_Close();
	 }
}

#endif
