#include <stdio.h>
#include <a2410/typedefs.h>
#include <a2410/devtiga.h>
#include <clib/a2410_protos.h>
#include <math.h>

BOOL TIGA_Init(void);
void TIGA_Close(void);
void TIGA_Break(void);
void TIGA_SetRandPalet(void);

void	LinesDemo(void);
/* ================================================================================ */
void main(int argc, char **argv)
{
	if (TIGA_Init())
	 {
		onbreak(TIGA_Break);
		TIGA_SetRandPalet();
		LinesDemo();
		TIGA_Close();
	 }
}

/* ------------------------------------------------------------------------------- */

void	LinesDemo()
{
	int x1,y1,x2,y2;
	int x1v,y1v,x2v,y2v;
	int i,c;
	CONFIG	config;
	
	get_config(&config);

	c = 0;
	x1v = y1v = x2v = y2v = 0;
	x1 = x2 = config.mode.disp_hres/2;
	y1 = y2 = config.mode.disp_vres/2;

	for (;;)
	{
		c = ((c)%(config.mode.palet_size-1))+1;
		set_fcolor(c);

		x1v = x1v/2 + (rand() & 15) - 7;
		y1v = y1v/2 + (rand() & 15) - 7;
		x2v = x2v/2 + (rand() & 15) - 7;
		y2v = y2v/2 + (rand() & 15) - 7;

		i = 300;

		while(i--)
		{
			chkabort();
			x1 += x1v;
			y1 += y1v;
			x2 += x2v;
			y2 += y2v;

			if (x1 < 0)
				{
				x1 = - x1;
				x1v = - x1v;
				y1v += (rand() % 5) - 2;
				}

			if (y1 < 0)
				{
				y1 = - y1;
				y1v = - y1v;
				x1v += (rand() % 5) - 2;
				}

			if (x1 >= config.mode.disp_hres)
				{
				x1 = 2*config.mode.disp_hres - x1 - 2;
				x1v = - x1v;
				y1v += (rand() % 5) - 2;
				}

			if (y1 >= config.mode.disp_vres)
				{
				y1 = 2*config.mode.disp_vres - y1 - 2;
				y1v = -y1v;
				x1v += (rand() % 5) - 2;
				}

			if (x2 < 0)
				{
				x2 = - x2;
				x2v = - x2v;
				y2v += (rand() % 5) - 2;
				}

			if (y2 < 0)
				{
				y2 = - y2;
				y2v = - y2v;
				x2v += (rand() % 5) - 2;
				}

			if (x2 >= config.mode.disp_hres)
				{
				x2 = 2*config.mode.disp_hres - x2 - 2;
				x2v = - x2v;
				y2v += (rand() % 5) - 2;
				}

			if (y2 >= config.mode.disp_vres)
				{
				y2 = 2*config.mode.disp_vres - y2 - 2;
				y2v = - y2v;
				x2v += (rand() % 5) - 2;
				}

			draw_line(x1, y1, x2, y2);

			/* synchronize(); */
		}
	}
}
/* --------------------------------------------------------------------------------- */
