#include <exec/types.h>
#include <exec/devices.h>
#include <intuition/intuition.h>
#include <dos.h>

#include <a2410/typedefs.h>
#include <a2410/devtiga.h>
#include <clib/a2410_protos.h>

struct	GfxBase		*GfxBase;
struct	IntuitionBase	*IntuitionBase;
struct	Window		*Window;

/* pack the color 00redbluegreen */
CURSOR pencil = 
{
0x0000,0x001B,0x0011,0x001C,0x0020,0x00FF0000,1,8,0L
};

UBYTE pencil_data[]={
0xFF,0x87,0x03,0x00,0xFF,0x03,0x03,0x00,
0xFF,0x03,0x02,0x00,0xFF,0x01,0x02,0x00,0xFF,0x01,0x03,0x00,0xFF,0x00,0x03,0x00,
0xFF,0x80,0x03,0x00,0x7F,0x80,0x03,0x00,0x7F,0xC0,0x03,0x00,0x3F,0xC0,0x03,0x00,
0x3F,0xE0,0x03,0x00,0x1F,0xE0,0x03,0x00,0x1F,0xF0,0x03,0x00,0x0F,0xF0,0x03,0x00,
0x0F,0xF8,0x03,0x00,0x07,0xF8,0x03,0x00,0x07,0xFC,0x03,0x00,0x03,0xFC,0x03,0x00,
0x03,0xFE,0x03,0x00,0x01,0xFE,0x03,0x00,0x01,0xFF,0x03,0x00,0x00,0xFF,0x03,0x00,
0x80,0xFF,0x03,0x00,0xC0,0xFF,0x03,0x00,0xE0,0xFF,0x03,0x00,0xF0,0xFF,0x03,0x00,
0xF8,0xFF,0x03,0x00,0xFD,0xFF,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x00,
0x00,0xF8,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x72,0x00,0x00,
0x00,0x26,0x00,0x00,0x00,0x39,0x00,0x00,0x00,0x11,0x00,0x00,0x80,0x10,0x00,0x00,
0x80,0x08,0x00,0x00,0x40,0x08,0x00,0x00,0x40,0x04,0x00,0x00,0x20,0x04,0x00,0x00,
0x20,0x02,0x00,0x00,0x10,0x02,0x00,0x00,0x10,0x01,0x00,0x00,0x08,0x01,0x00,0x00,
0x88,0x00,0x00,0x00,0x84,0x00,0x00,0x00,0x44,0x00,0x00,0x00,0x4E,0x00,0x00,0x00,
0x3E,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,0x06,0x00,0x00,0x00,
0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};




struct NewWindow NW = {
   0,0,200, 100,         /*LeftEdge,TopEdge,Width,Height*/
   -1,-1,
   MOUSEBUTTONS|MOUSEMOVE|CLOSEWINDOW,	/*IDCMP */
   REPORTMOUSE|SMART_REFRESH|ACTIVATE|WINDOWDRAG|WINDOWCLOSE|WINDOWDEPTH, /*FLAGS */
   NULL,   /* i MuteColor : (struct Gadget *)&GraphicGadget[0] FirstGadget*/
   NULL,                 /*  CheckMark   */
   "TIGA Window",                 /*Title*/
   NULL,                 /*  Screen: Kan foerst saettes naar screen er OK */
   NULL,                 /* BitMap */
   100, 25, 640 ,512 ,   /*MinWidth,MinHeight,MaxWidth,MaxHeight */
   (UWORD) WBENCHSCREEN };        /* Screen Type */

/* -------------------------------------------------------------------------------- */

void install_cursor(type)
short type;  	/* 0=default(arrow), 1=user(pencil)		*/
{
	/* Address of user cursor in GSP mem			*/
	PTR UserCursData = 0L;
	PTR UserCurs = 0L;

	if (type)
	{ 	/* User cursor type specified			*/
	    /* Execute this block 1st time only    */
	    UserCursData = (PTR) gsp_malloc(sizeof(pencil_data));
            if (UserCursData == 0)
		{ printf("Error allocating pencil data\n"); return;}
            pencil.data = UserCursData;
            UserCurs = (PTR)gsp_malloc(sizeof(pencil));
	    if (UserCurs==0)
		{ printf("Error allocating user cursor data structure\n");
		  gsp_free(UserCursData);
		  return;
		}
	    /*try first sending down first 5 elements of the header*/
            host2gsp ((char*)&pencil, UserCurs, 10, 0);
	    /* now send down the color ,which is a long */
	    host2gsp((char*)&(pencil.color),(UserCurs+0x50L),4,2);
	    /* now send down the two raster ops  */ 
	    host2gsp((char*)&(pencil.mask_rop),(UserCurs+0x70L),4,0); 
            /* and the data pointer */
	    host2gsp((char*)&(pencil.data),(UserCurs+0x90L),4,2);
	    /* now send down the data  itself*/
	    host2gsp(pencil_data,UserCursData,sizeof(pencil_data),1);
	    printf("Setting the shape to UserCurs\n");
            set_curs_shape(UserCurs);
	}
       else
	{
	     printf("Setting the shape to default cursor\n");
	     set_curs_shape( (PTR) 0);	/* Use default if type==0 */
	}
	set_curs_state(1);	/* enable */
}   

void	remove_cursor()
{
	set_curs_state(0);
}
/* ================================================================================ */
void InitGraphics()
{

  GfxBase = (struct GfxBase *) OpenLibrary("graphics.library", 33 );
  if ( GfxBase == NULL ) return;

  IntuitionBase = (struct IntuitionBase *)  OpenLibrary("intuition.library", 33 );
  if ( IntuitionBase == NULL) return;

  if (( Window = (struct Window *)OpenWindow(&NW)) == NULL)
     return;
}/* END InitrGraphic() */
/* ----------------------------------------------------------------- */
void	CloseGraphics(void)
{
  if (Window) CloseWindow(Window);
  if (IntuitionBase) CloseLibrary(IntuitionBase);
  if (GfxBase) CloseLibrary(GfxBase);
}


void	GetInput()
{   	/* waits for closegadg event */
  ULONG  class;
  UWORD  code,stop,x_coor,y_coor,old_x,old_y;
  struct IntuiMessage  *message;
  int  	 WakeupMask;

  stop = FALSE;
  old_x = Window->MouseX;	/* start where pointer is right now */
  old_y = Window->MouseY;
  while (!stop)
  { 
     WakeupMask = Wait( (1<<Window->UserPort->mp_SigBit) );
     if ( WakeupMask & ((1<<Window->UserPort->mp_SigBit)) )
      {
          while ( message = (struct IntuiMessage *)    
                GetMsg( Window -> UserPort ) )      
          {
            class = message -> Class;
            code  = message -> Code;
	    x_coor = message->MouseX;
	    y_coor = message->MouseY;	
            ReplyMsg( message );

            switch (class)
            {
              case MOUSEMOVE:
		set_curs_xy(x_coor,y_coor);
		draw_line(old_x,old_y,x_coor,y_coor);
		old_x = x_coor;
		old_y = y_coor;
		break;
              case MOUSEBUTTONS :
              case GADGETDOWN : 
              case GADGETUP   : 
              case MENUPICK   : break;
	      case CLOSEWINDOW: stop = TRUE;break;
              default         : break;
            }
          }
      }
  }
} /* END:  GetInput() */
/* --------------------------------------------------------------------------------- */

main()
{
	if (TIGA_Init())
	 {
		InitGraphics();
		install_cursor(0);
		GetInput();
		install_cursor(1);
		GetInput();
		remove_cursor();
		CloseGraphics();
		TIGA_Close();
	 }
}

/* ===================================================================================== */
