#include <a2410/typedefs.h>
#include <a2410/devtiga.h>
#include <a2410/ti_function_nums.h>
#include <clib/a2410_protos.h>
#include <lattice/math.h>

void	GetConfig();
void 	PrintMode(MODEINFO *modeinfo);

main()
{
	if (TIGA_Init())
	{
		GetConfig();
		TIGA_Close();
	}
	else
	 printf("\nTIGA_Init() failed");
}

void	GetConfig()
{
	int	i;
	CONFIG	config;
	MODEINFO modeinfo;	
	
	get_config(&config);

	printf("\n");
	printf("CONFIG\n");
	printf("    version_number     = %d\n",   config.version_number    );
	printf("    comm_buff_size     = %ld\n",  config.comm_buff_size    );
	printf("    sys_flags          = %lx\n",  config.sys_flags         );
	printf("    device_rev         = %ld\n",  config.device_rev        );
	printf("    num_modes          = %d\n",   config.num_modes         );
	printf("    current_mode       = %d\n",   config.current_mode      );
	printf("    program_mem_start  = %8lx\n", config.program_mem_start );
	printf("    program_mem_end    = %8lx\n", config.program_mem_end   );
	printf("    display_mem_start  = %8lx\n", config.display_mem_start );
	printf("    display_mem_end    = %8lx\n", config.display_mem_end   );
	printf("    stack_size         = %ld\n",  config.stack_size        );
	printf("    shared_mem_size    = %ld\n",  config.shared_mem_size   );
	printf("    shared_host_addr   = %8lx\n", config.shared_host_addr  );
	printf("    shared_gsp_addr    = %8lx\n", config.shared_gsp_addr   );

	printf("\n Default mode\n");
	PrintMode(&config.mode);
	printf("\nList of all valid modes: ");
	
	for (i=0; i<=config.num_modes; i++)
		{
		if (get_modeinfo(i, &modeinfo))
			{
			printf("\nmode = %d\n", i);
			PrintMode(&modeinfo);
			}
		}


}


void PrintMode(MODEINFO *modeinfo)
{
	printf("    disp_pitch         = %ld\n",   modeinfo->disp_pitch        );
	printf("    disp_vres          = %d\n",    modeinfo->disp_vres         );
	printf("    disp_hres          = %d\n",    modeinfo->disp_hres         );
	printf("    screen_wide        = %d\n",    modeinfo->screen_wide       );
	printf("    screen_high        = %d\n",    modeinfo->screen_high       );
	printf("    disp_psize         = %d\n",    modeinfo->disp_psize        );
	printf("    pixel_mask         = %ld\n",   modeinfo->pixel_mask        );
	printf("    palet_gun_depth    = %d\n",    modeinfo->palet_gun_depth   );
	printf("    palet_size         = %ld\n",   modeinfo->palet_size        );
	printf("    palet_inset        = %d\n",    modeinfo->palet_inset       );
	printf("    num_pages          = %d\n",    modeinfo->num_pages         );
	printf("    num_offscrn_areas  = %d\n",    modeinfo->num_offscrn_areas );
	printf("    wksp_addr          = %8lx\n",  modeinfo->wksp_addr         );
	printf("    wksp_pitch         = %8lx\n",  modeinfo->wksp_pitch        );

}
