/*
 * maxdepthlores.c by Christian Ludwig (CATS)
 * (91.08.02)
 */

#include <intuition/intuition.h>
#include <graphics/gfxbase.h>
#include <graphics/displayinfo.h>
#include <intuition/screens.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>
#include <clib/intuition_protos.h>
#include <clib/graphics_protos.h>

#include <stdio.h>
#include <stdlib.h>

struct IntuitionBase *IntuitionBase;
struct GfxBase *GfxBase;
extern struct ExecBase *SysBase;


void Quit(char whytext[],UBYTE failcode)
{
	if (IntuitionBase) CloseLibrary((struct Library *) IntuitionBase);

	if (GfxBase) CloseLibrary((struct Library *) GfxBase);

	printf("%s\n",whytext);

	Delay(50*10);

	exit(failcode);
}

void main(void)
{
	ULONG modeID = LORES_KEY;
	DisplayInfoHandle displayhandle;
	struct DimensionInfo dimensioninfo;

	UWORD maxdepth, maxcolors;

	ULONG soerror = NULL,colornum;

	struct Screen *screen;

	if ((GfxBase=
	(struct GfxBase *) OpenLibrary("graphics.library",36))==NULL)
		Quit("graphics.library is too old <V36",25);

	if ((IntuitionBase=
	(struct IntuitionBase *) OpenLibrary("intuition.library",36))==NULL)
		Quit("intuition.library is too old <V36",25);

	if ((displayhandle=FindDisplayInfo(modeID))==NULL)
		Quit("modeID not found in display database",25);

	if (GetDisplayInfoData(displayhandle,(UBYTE *) &dimensioninfo,
	sizeof(struct DimensionInfo),DTAG_DIMS,NULL)==0)
		Quit("mode dimension info not available",25);

	maxdepth=dimensioninfo.MaxDepth;
	printf("dimensioninfo.MaxDepth=%d\n",(int) maxdepth);


	if (screen=OpenScreenTags(NULL,SA_DisplayID		,modeID,
								   SA_Depth			,(UBYTE) maxdepth,
								   SA_Title			,"MaxDepth LORES",
								   SA_ErrorCode		,&soerror,
								   SA_FullPalette	,TRUE,
								   TAG_END))
		{
			/* Zowee! we actually got the screen open!
			 *
			 * now let's try drawing into it.
			 */

			maxcolors=1<<maxdepth;

			printf("maxcolors=%d\n",(int) maxcolors);

			for(colornum=0;colornum<maxcolors;++colornum)
			{
				SetAPen(&(screen->RastPort),colornum);
				Move(&(screen->RastPort),colornum,screen->BarHeight + 2);
				Draw(&(screen->RastPort),colornum,199);
			}

			Delay(50*1*6);

			CloseScreen(screen);
		}

	else
		{
			/*
			 * Hmmm.  Couldn't open the screen.  maybe not
			 * enough CHIP RAM? Maybe not enough chips! ;-)
			 */

			switch(soerror)
			{
				case OSERR_NOCHIPS:
					Quit("Bummer! You need new chips dude!",25);
					break;

				case OSERR_UNKNOWNMODE:
					Quit("Bummer! Unknown screen mode.",25);
					break;

				case OSERR_NOCHIPMEM:
					Quit("Not enough CHIP memory.",25);
					break;

				case OSERR_NOMEM:
					Quit("Not enough FAST memory.",25);
					break;

				default:
					printf("soerror=%d\n",soerror);
					Quit("Screen opening error.",25);
					break;
			}

			Quit("Couldn't open screen.",25);
		}

	Quit("Done.",0);
}
