/*
 * attachedsc.c
 *
 * Demonstrates opening attached screens.
 *
 * This program functions fine under Kickstart V36/V37, but the two
 * screens remain independent.
 *
 * (C) Copyright 1991, Commodore-Amiga, Inc.
 *
 * Executables based on this information may be used in software
 * for Commodore Amiga computers.  All other rights reserved.
 * This information is provided "as is"; no warranties are made.  All
 * use is at your own risk. No liability or responsibility is assumed.
 *
 */

/*----------------------------------------------------------------------*/

#include <exec/types.h>
#include <graphics/displayinfo.h>
#include <intuition/intuition.h>

#include <clib/exec_protos.h>
#include <clib/graphics_protos.h>
#include <clib/intuition_protos.h>
#include <pragmas/exec_pragmas.h>
#include <pragmas/graphics_pragmas.h>
#include <pragmas/intuition_pragmas.h>

/* These definitions will appear in V39 include files.  Until then,
 * they're available locally
 */

#ifndef SA_Attach
#define SA_Attach	(SA_Dummy + 0x001D)
#endif

extern struct Library *SysBase;

/*----------------------------------------------------------------------*/

void error_exit(STRPTR errorstring);

/*----------------------------------------------------------------------*/

struct GfxBase *GfxBase = NULL;
struct IntuitionBase *IntuitionBase = NULL;
struct Screen *parent = NULL;
struct Screen *child = NULL;
struct Window *parentwin = NULL;
struct Window *childwin = NULL;

UWORD Pens[] =
{
	~0,
};

/*----------------------------------------------------------------------*/

main()

{
    int i,w;

    if (!( GfxBase = (struct GfxBase *)
	OpenLibrary("graphics.library", 36L) ))
    {
	error_exit("Couldn't open Gfx V36\n");
    }

    if (!( IntuitionBase = (struct IntuitionBase *)
	OpenLibrary("intuition.library", 36L) ))
    {
	error_exit("Couldn't open Intuition V36\n");
    }

    if (!(parent = OpenScreenTags(NULL,
	SA_DisplayID, HIRES_KEY,
	SA_Overscan, OSCAN_TEXT,
	SA_Depth, 2,
	SA_AutoScroll, 1,
	SA_Pens, Pens,
	SA_Title, "Parent",
	TAG_DONE )))
    {
	error_exit("Couldn't open screen");
    }
    if (!( parentwin = OpenWindowTags(NULL,
	WA_Title, "Peter's Window",
	WA_SizeGadget, TRUE,
	WA_DragBar, TRUE,
	WA_CloseGadget, TRUE,
	WA_DepthGadget, TRUE,
	WA_IDCMP, CLOSEWINDOW,
	WA_NoCareRefresh, TRUE,
	WA_Activate, TRUE,
	WA_SmartRefresh, TRUE,
	WA_CustomScreen, parent,
	WA_Top, 10,
	WA_Height, 190,
	WA_MinWidth, 100,
	WA_MinHeight, 50,
	WA_MaxWidth, -1,
	WA_MaxHeight, -1,
	TAG_DONE ) ))
    {
	error_exit("Couldn't open window");
    }

    if (!(child = OpenScreenTags(NULL,
	SA_DisplayID, LORES_KEY,
	SA_Overscan, OSCAN_TEXT,
	SA_Depth, 5,
	SA_Top, 150,
	SA_Height, 50,
	SA_AutoScroll, 1,
	SA_Attach, parent,
	SA_Pens, Pens,
	SA_Title, "Child",
	TAG_DONE )))
    {
	error_exit("Couldn't open screen");
    }

    if (!( childwin = OpenWindowTags(NULL,
	WA_IDCMP, CLOSEWINDOW,
	WA_NoCareRefresh, TRUE,
	WA_Activate, TRUE,
	WA_SmartRefresh, TRUE,
	WA_CustomScreen, child,
	WA_Top, 0,
	TAG_DONE ) ))
    {
	error_exit("Couldn't open window");
    }

    w = childwin->Width - 8;

    for (i=0; i < 31; i++)
	{
	SetAPen( childwin->RPort, i );
	RectFill( childwin->RPort, (i*w)/32+4,2,((i+1)*w)/32+3, 47 );
	}

    Move(parentwin->RPort, 50,50);
    Text(parentwin->RPort, "Hello", 5);

    WaitPort( parentwin->UserPort );

    error_exit(NULL);
}


/*----------------------------------------------------------------------*/

void error_exit(STRPTR errorstring)

    {
    if (childwin)
	{
	CloseWindow(childwin);
	}

    if (parentwin)
	{
	CloseWindow(parentwin);
	}

    if (child)
	{
	CloseScreen(child);
	}

    if (parent)
	{
	CloseScreen(parent);
	}

    if (IntuitionBase)
	{
	CloseLibrary(IntuitionBase);
	}

    if (GfxBase)
	{
	CloseLibrary(GfxBase);
	}

    if (errorstring)
	{
	printf(errorstring);
	exit(20);
	}

    exit(0);
    }


/*----------------------------------------------------------------------*/
