
   /***********************************************************************
   *                                                                      *
   *                            COPYRIGHTS                                *
   *                                                                      *
   *   Copyright (c) 1990  Commodore-Amiga, Inc.  All Rights Reserved.    *
   *                                                                      *
   ***********************************************************************/

#include "app.h"
#include <intuition/intuitionbase.h>

#define CYCLE        1L
#define CYCLEBACK    2L
#define MAKEBIG      3L
#define MAKESMALL    4L
#define CYCLESCREEN  5L
#define ZIPWINDOW    6L

#define   IMINWIDTH   40
#define   IMINHEIGHT   30
#define   MIN(A,B)   (((A)<(B))?(A):(B))
#define   MAX(A,B)   (((A)>(B))?(A):(B))

void makesize(LONG);
void cyclebackward(void);
void cycleforward(void);
void cyclescreen(void);
void zipwindow(void);

BOOL setupIHelp()
{
   LONG         error;

   AttachCxObj(broker,
      HotKey( ArgString(ttypes, "CYCLE", "f1"), cxport, CYCLE) );
   AttachCxObj(broker,
      HotKey( ArgString(ttypes, "MAKEBIG", "f2"),  cxport, MAKEBIG) );
   AttachCxObj(broker,
      HotKey( ArgString(ttypes, "MAKESMALL", "f3"), cxport, MAKESMALL) );
   AttachCxObj(broker,
      HotKey( ArgString(ttypes, "CYCLESCREEN", "f4"), cxport, CYCLESCREEN) );
   AttachCxObj(broker,
      HotKey( ArgString(ttypes, "ZIPWINDOW", "f5"), cxport, ZIPWINDOW) );

   if (error = CxObjError(broker))
   {
      D( printf("accumulated broker error %ld\n", error) );
      return(0);
   }
   return(1);
}
VOID MyHandleCXMsg(id)
ULONG id;
{
   switch(id)
   {
      case CYCLE:
            D( printf("cycleforward\n") );
            cycleforward();
            break;
      case MAKEBIG:
            D( printf("makebig\n") );
            makesize((int) MAKEBIG);
            break;
      case MAKESMALL:
            D( printf("makesmall\n") );
            makesize((int) MAKESMALL);
            break;
      case CYCLESCREEN:
            cyclescreen();
            break;
      case ZIPWINDOW:
            zipwindow();
            break;
   }
}

void makesize(command)
LONG command;
{
   ULONG         ilock;
   struct Window   *awindow;
   struct Screen   *ascreen;
   SHORT         deltaw;
   SHORT         deltah;
   ULONG         Sizing;

   ilock = LockIBase(0L);
   awindow = IntuitionBase->ActiveWindow;
   ascreen = awindow->WScreen;

   switch (command)
   {
      case MAKESMALL:
            deltaw = MAX(awindow->MinWidth, IMINWIDTH) - awindow->Width;
            deltah = MAX(awindow->MinHeight, IMINHEIGHT) - awindow->Height;
            break;
      case MAKEBIG:
            deltaw =MIN(ascreen->Width - awindow->LeftEdge, (unsigned) awindow->MaxWidth) - awindow->Width;
            deltah =MIN(ascreen->Height-awindow->TopEdge, (unsigned) awindow->MaxHeight) - awindow->Height;
            break;
      default:
            deltaw = 0;
            deltah = 0;
   }
   if(awindow->Flags & WINDOWSIZING)
      Sizing=TRUE;
   else Sizing=FALSE;

   UnlockIBase(ilock);

   if(Sizing)
      SizeWindow(awindow, (LONG) deltaw, (LONG) deltah);
}

void cycleforward()
{
   LONG         ilock;
   struct Window   *awindow;
   struct Screen   *ascreen;
   struct Layer   *rearlayer;      /* rearmost so far      */
   struct Layer   *layer;         /* runs through layers   */
   struct Window   *lwindow;      /* layer->Window      */


   ilock = LockIBase(0L);
   awindow = IntuitionBase->ActiveWindow;
   ascreen = awindow->WScreen;

   D( printf("active window/screen: %lx/%lx\n", awindow, ascreen) );

   /* for now, only pull this stuff on the workbench   */
   if ((ascreen->Flags & SCREENTYPE) != WBENCHSCREEN)
   {
      D( printf("not wbscreen\n") );
      UnlockIBase(ilock);
      goto OUT;
   }

   /* find rearmost layer which is not a backdrop window,
    * nor the bar layer, nor a WBENCHWINDOW
    */
   rearlayer = NULL;
   for (layer = ascreen->LayerInfo.top_layer;layer; layer = layer->back)
   {
      lwindow = (struct Window *) layer->Window;
      D( printf("layer %lx window %lx\n",layer, lwindow) );
      if (layer == ascreen->BarLayer)   
      {
         D( printf("is bar layer\n") );
         continue;
      }
      if (layer->Flags & LAYERBACKDROP)
      {
         D( printf("backdrop layer\n") );
         continue;
      }
      if (lwindow->Flags & WBENCHWINDOW)
      {
         D( printf("skipping wbench window\n") );
         continue;
      }

      rearlayer = layer;
   }
   D( printf("let's try it\n") );
   UnlockIBase(ilock);
   D( printf("unlocked\n") );

   if (rearlayer)
   {
      lwindow = (struct Window *) rearlayer->Window;
      D( printf("window of choice: %lx\n") );
      WindowToFront(lwindow);
      if (lwindow != awindow) ActivateWindow(lwindow);
   }

OUT:
   D( printf("cycleback done\n") );
   return;

}

void cyclescreen()
{
   ULONG         ilock;

   D( printf("cyclescreen()\n") );
   ScreenToBack(IntuitionBase->FirstScreen);
}

void zipwindow(void)
{
   ULONG         ilock;
   struct Window   *awindow;

   awindow = IntuitionBase->ActiveWindow;

   ZipWindow(awindow);
}
