;/* asltest.c - Execute me to compile me with Lattice 5.04
LC -b1 -cfistq -v -y -j73 asltest.c
Blink FROM LIB:c.o,asltest.o TO asltest LIBRARY LIB:LC.lib,LIB:Amiga.lib
quit
*/

/*	asltest.c
 *
 *	This test program demonstrates usage of asl.library
 *	File and Font request functions for V2.0 of AmigaDOS.
 *
 *	Revised 90/8/31 by cdh
 *	Revised 90/9/19 by cas
 *	Revised 90/12/19, 91/1/20, 91/1/24, 3/3/91 by cas
 *
 */


#include <intuition/intuition.h>
#include <utility/tagitem.h>
#include <utility/hooks.h>
#include <libraries/asl.h>

#ifdef LATTICE
#include <clib/exec_protos.h>
#include <clib/dos_protos.h>
#include <clib/graphics_protos.h>
#include <clib/intuition_protos.h>
#include <clib/diskfont_protos.h>
#include <clib/asl_protos.h>
#include <stdlib.h>
#include <string.h>

int CXBRK(void) { return(0); }  /* Disable Lattice CTRL/C handling */
int chkabort(void) { return(0); }  /* really */
#endif

char VERSTAG[]="\0$VER: asltest 37.2";

/***********************************************************************/

struct Library  *AslBase;
struct Library  *IntuitionBase;
struct Library	*GfxBase;
struct Library	*DiskfontBase;

struct Screen	*MyScreen;
struct Window	*MyWindow;

struct TextFont	*MyFont,*OldFont;

struct FileRequester *FileRequester;
struct FontRequester *FontRequester;

/************************************************************************/

void punt( int );
int main(int,char **);


ULONG FontHook(ULONG, CPTR, struct FontRequester *);

ULONG FileHook(ULONG, CPTR, struct FileRequester * );

void exit( int );
void printf(char *,...);

/************************************************************************/

struct TextAttr	MyTextAttr = { "topaz.font",TOPAZ_EIGHTY,0,0 };

struct NewScreen MyNewScreen = 
	{
	0,50,320,200,5,
	1,2,
	0,CUSTOMSCREEN,&MyTextAttr,
	"My Custom Screen",
	0,0
	};

struct NewWindow MyNewWindow =
	{
	10,10,300,150,
	1,2,
	REFRESHWINDOW|NEWSIZE|ACTIVEWINDOW|CLOSEWINDOW|VANILLAKEY,
	ACTIVATE|SMART_REFRESH|WINDOWDEPTH|WINDOWSIZING|WINDOWDRAG|WINDOWCLOSE,
	0,0,
	"My Window",
	0,			/* Custom screen later...	*/
	0,
	20,20,1000,1000,
	CUSTOMSCREEN
	};

/************************************************************************/


struct TagItem MultiTags[] = {
	ASL_FuncFlags,FILF_MULTISELECT | FILF_PATGAD,
	ASL_Pattern,(ULONG)"#?",
	ASL_Hail,(ULONG)"MultiSelect",
	TAG_DONE,
	};

struct TagItem SaveTags[] = {
	ASL_Hail,(ULONG)"Save test",
	ASL_FuncFlags,FILF_SAVE | FILF_PATGAD,
	ASL_OKText,(ULONG)"Saveit",
	TAG_DONE,
	};

struct TagItem FileTags2[] = {
	ASL_Window,NULL,
	ASL_HookFunc,(ULONG)FileHook,
	ASL_FuncFlags,FILF_DOMSGFUNC | FILF_DOWILDFUNC,
	ASL_Hail,(ULONG)"CustomScreen test",
	TAG_DONE
	};

struct TagItem FontTags[] = {
	ASL_FuncFlags,FONF_FIXEDWIDTH | FONF_DOMSGFUNC,
	ASL_MinHeight,8,
	ASL_MaxHeight,9,
	ASL_HookFunc,(ULONG)FontHook,
	TAG_DONE
	};

char *ModeList[] = {
	"MyModes",
	"MyJam1",
	"MyJam2",
	"MyComp",
	"MyInverse1",
	"MyInverse2",
	NULL
	};
	

struct TagItem FontTags2[] = {
	ASL_Window,NULL,
	ASL_Hail,(ULONG)"ASLib Font Test",
	ASL_OKText,(ULONG)"MyOK",
	ASL_MaxHeight,30,
	ASL_FuncFlags,FONF_STYLES|FONF_BACKCOLOR|FONF_FRONTCOLOR|
			FONF_DRAWMODE|FONF_DOMSGFUNC|FONF_DOWILDFUNC,
	ASL_ModeList,&ModeList,
	TAG_DONE
	};

/************************************************************************/

main(argc,argv)
int	argc;
char	*argv[];
{
struct IntuiMessage *msg;
ULONG	class,code;

struct WBArg	*p_wbargs;
int	i;

/* First get some libraries open.	*/
IntuitionBase = OpenLibrary("intuition.library",36);
if ( IntuitionBase == NULL ) {
	punt(30);
	}

GfxBase = OpenLibrary("graphics.library",36);
if ( GfxBase == NULL ) {
	punt(31);
	}

if ( (DiskfontBase = OpenLibrary("diskfont.library",36)) == 0 ) {
	printf("Can't open diskfont.library\n");
	punt(32);
	}

if ( (AslBase = OpenLibrary(AslName,36)) == 0 ) {
	printf("Can't open asl.library\n");
	punt(33);
	}

/**********************************************************************
 *
 * The following code implements the simplest possible file requester.
 *
 **********************************************************************/

FileRequester = AllocFileRequest();
if ( FileRequester == NULL ) {
	printf("Failed to allocate file request\n");
	punt(34);
	}
	
if ( RequestFile(FileRequester) )
	printf("User requested dir (%s) file (%s)\n",FileRequester->rf_Dir,FileRequester->rf_File);
else
	printf("User cancelled filerequest\n");

FreeFileRequest( FileRequester );

/**********************************************************************
 *
 * Now do another more complex file requester call, with tagitems.
 * This test case allows multiple selections.
 *
 **********************************************************************/

FileRequester = AllocAslRequest(ASL_FileRequest, NULL);
if ( FileRequester == NULL ) {
	printf("Failed to allocate file request\n");
	punt(34);
	}

if (AslRequest(FileRequester,MultiTags)) {
	if ( i = FileRequester->rf_NumArgs ) {
		printf("Selected %d multiargs\n",i);
		p_wbargs = FileRequester->rf_ArgList;
		while ( i-- ) {
			printf("MultiSel lock $%lx name %s\n",p_wbargs->wa_Lock,p_wbargs->wa_Name);
			p_wbargs++;
			}
		}
	else	printf("No multiarg - dir (%s) file (%s)\n",FileRequester->rf_Dir,FileRequester->rf_File);
	}
else
	printf("User canned file request\n");


/**********************************************************************
 *
 * Next use the SAME FileRequester structure for a SAVE operation.
 * See the different tag values for info.
 *
 * NOTE, we will eventually call FreeAslRequest() to free FileRequester!
 *
 **********************************************************************/

if ( AslRequest( FileRequester, SaveTags ) )
	printf("User requested dir (%s) file (%s)\n",FileRequester->rf_Dir,FileRequester->rf_File);
else
	printf("User cancelled filerequest\n");


/* You can abort the test after the first file requests by typing
 * something on the command line when you run ASLTEST.
 */
if ( argc > 1 )	punt( 0 );


/**********************************************************************
 *
 * Next allocate a FontRequester, and make a simple font request.
 *
 **********************************************************************/

FontRequester = (struct FontRequester *)AllocAslRequest(ASL_FontRequest,FontTags);

if ( FontRequester == NULL ) {
	printf("Failed to allocate font request\n");
	punt(35);
	}

if ( AslRequest(FontRequester, NULL) )
	printf("User requested font (%s) size %d style %x flags %x\n	FrontPen: %d BackPen: %d Mode %d\n",
		FontRequester->fo_Attr.ta_Name,
		FontRequester->fo_Attr.ta_YSize,
		FontRequester->fo_Attr.ta_Style,
		FontRequester->fo_Attr.ta_Flags,
		FontRequester->fo_FrontPen,
		FontRequester->fo_BackPen,
		FontRequester->fo_DrawMode );

else	printf("CANCELLED:     ");

/**********************************************************************
 *
 * Now do some tests on a custom screen.  First, open up
 * a custom screen and window.
 *
 **********************************************************************/

MyScreen = OpenScreen(&MyNewScreen);
if ( MyScreen == 0L )
	{
	printf("Can't open custom screen, Oh No!!!!\n");
	punt(1);
	}

MyNewWindow.Screen = MyScreen;
MyWindow = OpenWindow(&MyNewWindow);
if ( MyWindow == 0L )
	{
	printf("Can't open custom window, Oh Doubleno!!!\n");
	punt(2);
	}

OldFont = MyWindow->RPort->Font;


/**********************************************************************
 *
 * Do a file request on the custom screen, still using the previously
 * allocated FileRequester.
 *
 **********************************************************************/

FileTags2[0].ti_Data = (ULONG)MyWindow;
if ( AslRequest( FileRequester, FileTags2 ) )
	printf("User requested dir (%s) file (%s)\n",FileRequester->rf_Dir,FileRequester->rf_File);
else
	printf("User cancelled filerequest\n");


/**********************************************************************
 *
 * The following test is a more complex font request test.  Most of
 * this code is not actually related to ASL, but rather is used to
 * open a font and display that font.  The test will loop until the
 * user enters CANCEL.
 *
 **********************************************************************/

Again:
FontTags2[0].ti_Data = (ULONG)MyWindow;
if ( ! AslRequest(FontRequester, FontTags2) ) {
	printf("CANCELLED Font Request\n");
	punt(0);
	}

printf("User requested font (%s) size %d style %x flags %x\n	FrontPen: %d BackPen: %d Mode %d\n",
	FontRequester->fo_Attr.ta_Name,
	FontRequester->fo_Attr.ta_YSize,
	FontRequester->fo_Attr.ta_Style,
	FontRequester->fo_Attr.ta_Flags,
	FontRequester->fo_FrontPen,
	FontRequester->fo_BackPen,
	FontRequester->fo_DrawMode );

ActivateWindow(MyWindow);

MyFont = (struct TextFont *)OpenFont(&FontRequester->fo_Attr);

if ( MyFont == NULL ) {
	printf("Font not in memory, checking disk...\n");
	}

else if ( MyFont->tf_YSize != FontRequester->fo_Attr.ta_YSize )
	{
	printf("Font not of requested size - reopening via disk!!!\n");
	CloseFont(MyFont);
	MyFont = NULL;
	}

if ( MyFont == NULL ) {
	MyFont = (struct TextFont *)OpenDiskFont(&FontRequester->fo_Attr);
	if ( MyFont == NULL ) {
		printf("Not on disk either.  Wieird\n");
		punt(51);
		}
	}

printf("Got font!\n");

Move(MyWindow->RPort,100,100);
SetFont(MyWindow->RPort,MyFont);
SetSoftStyle(MyWindow->RPort,FontRequester->fo_Attr.ta_Style,-1);

SetAPen(MyWindow->RPort,FontRequester->fo_FrontPen);
SetBPen(MyWindow->RPort,FontRequester->fo_BackPen);
SetDrMd(MyWindow->RPort,FontRequester->fo_DrawMode);

Text(MyWindow->RPort,"Abcdefg!!!12345",15);

CloseFont(MyFont);
MyFont = NULL;

while ( TRUE ) {
	WaitPort( MyWindow->UserPort );
	msg = (struct IntuiMessage *) GetMsg(MyWindow->UserPort);
	class = msg->Class;
	code = msg->Code;
	ReplyMsg((struct Message *)msg);
	if ( class == CLOSEWINDOW )
		punt( 0 );
	if ( class == VANILLAKEY ) {
		if ( code == 'Q' ) punt(0);
		else goto	Again;
		}
	}

}


/************************************************************************/


BOOL	FontSelectToggle = TRUE;		/* 

/************************************************************************
 *
 *	ULONG FontHook( ULONG Type, CPTR Object, CPTR AslRequester)
 *
 *	This is an ASL_HookFunc which is used to allow the font requester
 *	to interact with the application program.
 *
 *      Note that the DOMSG hook must return the Object (message) pointer
 *      passed to it.  Asl.library will reply the object.
 *	Also note that a font requester DOWILDFUNC must return non-ZERO
 *      to accept a TextAttr.
 *
 ************************************************************************/

ULONG FontHook( Type, Object, fr )
ULONG	Type;
CPTR	Object;
struct FontRequester *fr;
{

switch ( Type ) {
	case FONF_DOMSGFUNC:
		printf("Font domsgfunc: IDCMP class $%lx\n",((struct IntuiMessage *)Object)->Class);
		return( (ULONG) Object );
		break;

	case FONF_DOWILDFUNC:
		printf( "Font dowildfunc: %s %ld\n",
			((struct TextAttr *)Object)->ta_Name,
			((struct TextAttr *)Object)->ta_YSize);

/* This line would cause every 2nd font to be rejected
 		FontSelectToggle = ! FontSelectToggle;
*/
		return( (ULONG) FontSelectToggle );
		break;

	default:
		printf( "Font hook %ld\n",Type);
	}
}

/************************************************************************
 *
 *	ULONG FileHook( ULONG Type, CPTR Object, CPTR AslRequester)
 *
 *	This is an ASL_HookFunc which is used to allow the file requester
 *	to interact with the application program.
 *
 *      Note that the DOMSG hook must return the Object (message) pointer
 *      passed to it.  Asl.library will reply the object.
 *	Also note that the file requester's DOWILDFUNC must return
 *	ZERO to accept a file (opposite of font DOWILDFUNC)
 *
 ************************************************************************/

ULONG FileHook( Type, Object, fr )
ULONG	Type;
CPTR	Object;
struct FileRequester *fr;
{
switch ( Type ) {
	case FILF_DOMSGFUNC:
		printf("File domsgfunc: IDCMP class $%lx\n",((struct IntuiMessage *)Object)->Class);
		return( (ULONG) Object );
		break;

	case FILF_DOWILDFUNC:
		printf( "File dowildfunc: %s\n",
			((struct AnchorPath *)Object)->ap_Info.fib_FileName);
		return(NULL);	/* accept the file */
		break;
	default:
		printf( "File hook %ld\n",Type);
	}
}

/************************************************************************/
/* punt(rc) is a cleanup function which frees all resources and		*/
/*	then exits.							*/
/************************************************************************/

void punt(rc)
int	rc;
{
if ( FileRequester ) {
	FreeAslRequest(FileRequester);
	printf("Freed File Request!\n");
	}

if ( FontRequester ) {
	FreeAslRequest(FontRequester);
	printf("Freed Font Request!\n");
	}

if (MyFont)	CloseFont(MyFont);

if (MyWindow) {
	SetFont(MyWindow->RPort,OldFont);
	CloseWindow(MyWindow);
	}
if (MyScreen)	CloseScreen(MyScreen);

if (DiskfontBase)	CloseLibrary(DiskfontBase);
if (AslBase)		CloseLibrary(AslBase);
if (GfxBase)		CloseLibrary(GfxBase);
if (IntuitionBase)	CloseLibrary(IntuitionBase);

exit (rc);
}




