/*
 * Example 2 - Based on the UI code for FontMover 2.0 by Michael Sinz
 *
 * Copyright (c) 1989,90 - MKSoft Development
 *
 ************************************************************************
 *                                                                      *
 *                            DISCLAIMER                                *
 *                                                                      *
 *   THIS SOFTWARE IS PROVIDED "AS IS".                                 *
 *   NO REPRESENTATIONS OR WARRANTIES ARE MADE WITH RESPECT TO THE      *
 *   ACCURACY, RELIABILITY, PERFORMANCE, CURRENTNESS, OR OPERATION      *
 *   OF THIS SOFTWARE, AND ALL USE IS AT YOUR OWN RISK.                 *
 *   NEITHER COMMODORE NOR THE AUTHORS ASSUME ANY RESPONSIBILITY OR     *
 *   LIABILITY WHATSOEVER WITH RESPECT TO YOUR USE OF THIS SOFTWARE.    *
 *                                                                      *
 ************************************************************************
 */

/*
 * This file contains the global strings IDs.
 */

#ifndef	FONTMOVERSTRINGS_H
#define	FONTMOVERSTRINGS_H

#include	<exec/types.h>
#include	<intuition/intuition.h>

enum	{
/*
 * These strings are for the main gadgets...
 */
	TXT_CopyRightString=0,
	TXT_CopyLeftString,
	TXT_CopyGadgetString,

	TXT_RemoveGadgetString,
	TXT_ShowGadgetString,
	TXT_HelpGadgetString,
	TXT_AboutGadgetString,

/*
 * This is tha last string that is used in any way for
 * scaling the display.  This is the string between the
 * arrows that let you select the font directory.
 */
	TXT_DirSelectGadget,

/*
 * These are strings that are used in various places
 * in the program.  (Note that these are not really used
 * in the example but are here for educational use...)
 */
	TXT_Window_Title,
	TXT_AboutFontMover,

	TXT_MakeDirPrompt,
	TXT_DirectoryTitleString,

	TXT_CopyFontOpenError,
	TXT_CopyFontCopyError1,
	TXT_CopyFontCopyError2,

	TXT_AskRemove1,
	TXT_AskRemove2,
	TXT_AskRemove3,

	TXT_RemoveFontError,

/*
 * These strings are used in the AlertUser calls
 * and *MUST* be under 60 characters in length  (Should be 50 or less)
 */
	TXT_OpenLayersError,
	TXT_OpenGraphicsError,
	TXT_OpenDiskfontError,
	TXT_OpenConsoleError,
	TXT_GeneralMemoryError,
	TXT_WindowOpenError,

	TXT_PressButtonToContinue,

/*
 * If things go too far...
 *
 * This way, if any of the text display code has an error, the text
 * it displays will be ERROR!
 */
	STRING_TOO_FAR
	};

/*
 * This function returns the string asked for...
 */
char *Get_String(short);

/*
 * This routine returns the maximum size of all of
 * the text gadget strings given the TextAttr
 */
short Max_Gadget_Length(struct TextAttr *);

#endif	/* FONTMOVERSTRINGS_H */
