/*
 * Example 2 - Based on the UI code for FontMover 2.0 by Michael Sinz
 *
 * Copyright (c) 1989,90 - MKSoft Development
 *
 ************************************************************************
 *                                                                      *
 *                            DISCLAIMER                                *
 *                                                                      *
 *   THIS SOFTWARE IS PROVIDED "AS IS".                                 *
 *   NO REPRESENTATIONS OR WARRANTIES ARE MADE WITH RESPECT TO THE      *
 *   ACCURACY, RELIABILITY, PERFORMANCE, CURRENTNESS, OR OPERATION      *
 *   OF THIS SOFTWARE, AND ALL USE IS AT YOUR OWN RISK.                 *
 *   NEITHER COMMODORE NOR THE AUTHORS ASSUME ANY RESPONSIBILITY OR     *
 *   LIABILITY WHATSOEVER WITH RESPECT TO YOUR USE OF THIS SOFTWARE.    *
 *                                                                      *
 ************************************************************************
 */

#include	<exec/types.h>
#include	<intuition/intuition.h>

#include	<proto/intuition.h>

#include	<string.h>

#include	"Example2Strings.h"

/*
 * This file contains the global strings.  It may, at some point be set up
 * for internationalization.
 */

static	char	*All_Strings[STRING_TOO_FAR+1]=
{

/*
 * These strings are for the main gadgets...
 */
/* TXT_CopyRightString			*/	"Copy >",
/* TXT_CopyLeftString			*/	"< Copy",
/* TXT_CopyGadgetString			*/	"Copy",

/* TXT_RemoveGadgetString		*/	"Remove",
/* TXT_ShowGadgetString			*/	"Show",
/* TXT_HelpGadgetString			*/	"Help",
/* TXT_AboutGadgetString		*/	"About",

/*
 * This is tha last string that is used in any way for
 * scaling the display.  This is the string between the
 * arrows that let you select the font directory.
 */
/* TXT_DirSelectGadget			*/	"Select",

/*
 * These are strings that are used in various places
 * in the program.  (Note that these are not really used
 * in the example but are here for educational use...)
 */
/* TXT_Window_Title			*/	"Font UI Example 2",
/* TXT_AboutFontMover			*/	"\rFont UI Example 2\n\rby\n\rMichael Sinz",

/* TXT_MakeDirPrompt			*/	"Enter new directory name:",
/* TXT_DirectoryTitleString		*/	"Directory",

/* TXT_CopyFontOpenError		*/	"\rCould not open source font file",
/* TXT_CopyFontCopyError1		*/	"\rError during generation of '",
/* TXT_CopyFontCopyError2		*/	"' destination",

/* TXT_AskRemove1			*/	"\rAre you sure you wish to remove the '",
/* TXT_AskRemove2			*/	"' font family?",
/* TXT_AskRemove3			*/	"' size?",

/* TXT_RemoveFontError			*/	"\rYou must select a font before you can REMOVE it",

/*
 * These strings are used in the AlertUser calls
 * and *MUST* be under 60 characters in length  (Should be 50 or less)
 */
/* TXT_OpenLayersError			*/	"Could not open V33 layers.library",
/* TXT_OpenGraphicsError		*/	"Could not open V33 graphics.library",
/* TXT_OpenDiskfontError		*/	"Could not open V33 diskfont.library",
/* TXT_OpenConsoleError			*/	"Could not open console.device",
/* TXT_GeneralMemoryError		*/	"Out of memory",
/* TXT_WindowOpenError			*/	"Could not open FontMover window",

/* TXT_PressButtonToContinue		*/	"Press right mouse button to continue",

/*
 * If things go too far...
 *
 * This way, if any of the text display code has an error, the text
 * it displays will be ERROR!
 */
/* STRING_TOO_FAR			*/	"ERROR!"
};

/*
 * This function returns the string asked for...
 *
 * If you had various stings based on the language, this function
 * would be used to return the correct language string.
 */
char *Get_String(short StringNum)
{
	if ((StringNum<0)||(StringNum>STRING_TOO_FAR)) StringNum=STRING_TOO_FAR;
	return(All_Strings[StringNum]);
}

/*
 * This routine returns the maximum size of all of
 * the text gadget strings given the TextAttr
 *
 * Note that this is used to make sure that all of my gadget buttons
 * are the same size.  In some displays you may need a few of these
 * functions as you will have different button sizes.
 */
short Max_Gadget_Length(struct TextAttr *ta)
{
register	short		Width=0;
register	short		loop;
register	short		tmp;
	struct	IntuiText	IText;

	memset(&IText,0,sizeof(struct IntuiText));

	IText.ITextFont=ta;
	for (loop=TXT_CopyRightString;loop<TXT_DirSelectGadget;loop++)
	{
		IText.IText=Get_String(loop);
		if ((tmp=IntuiTextLength(&IText)) > Width) Width=tmp;
	}
	return(Width);
}
