/* :Programming/DevCon/Gadgets.C

History:
1.000 May 14, 1990  Jim2 - Stripped down from RTStock/Player.c

Description:
      An example of sizing gadgets at run time.
 *
 *      Copyright (c) 1990 by MKSoft Development, James Barkley, Jr
 *
 ************************************************************************
 *									*
 * Permission is hereby granted to distribute this program's source	*
 * executable, and documentation for non-commercial purposes, so long	*
 * as the copyright notices are not removed from the sources, 		*
 * executable or documentation.  This program may not be distributed	*
 * for a profit without the express written consent of the author James	*
 * Barkley, Jr.		      						*
 *									*
 * This program is not in the public domain.				*
 *									*
 * Fred Fish is expressly granted permission to distribute this 	*
 * program's source and executable as part of the "Fred Fish freely 	*
 * redistributable Amiga software library."				*
 *									*
 * Permission is expressly granted for this program and it's source to 	*
 * be distributed as part of the Amicus Amiga software disks, and the	*
 * First Amiga User Group's Hot Mix disks.				*
 *									*
 ************************************************************************

   ************************************************************************
   *                                                                      *
   *                            DISCLAIMER                                *
   *                                                                      *
   *   THIS SOFTWARE IS PROVIDED "AS IS".                                 *
   *   NO REPRESENTATIONS OR WARRANTIES ARE MADE WITH RESPECT TO THE      *
   *   ACCURACY, RELIABILITY, PERFORMANCE, CURRENTNESS, OR OPERATION      *
   *   OF THIS SOFTWARE, AND ALL USE IS AT YOUR OWN RISK.                 *
   *   NEITHER COMMODORE NOR THE AUTHORS ASSUME ANY RESPONSIBILITY OR     *
   *   LIABILITY WHATSOEVER WITH RESPECT TO YOUR USE OF THIS SOFTWARE.    *
   *                                                                      *
   ************************************************************************

									*/
#include <math.h>
#include <exec/types.h>
#include <exec/memory.h>
#include <string.h>
#include "renderinfo.h"

#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/graphics.h>

struct RenderInfo *PenColors;

struct TextAttr Default_Font;

struct TextFont *Default_Text;


UWORD Default_Font_Height;

struct Screen WBScrData;

#define STATI extern
#define EXTERN extern

#define TEXTPEN0 1

#define XSKIP 12
#define YSKIP  8
#define X_ARROWS 25
#define Y_ARROWS 14
#define X_ARROW  15
#define Y_ARROW  Y_ARROWS

#define ITICK_INTIAL_SKIP   3
#define ITICK_REPEAT_SKIP   0
#define ITICK_REPEAT_OFFSET (ITICK_INTIAL_SKIP - ITICK_REPEAT_SKIP)

#define UDATA_IS_FUNCTION 0
#define UP_ARROW_FCN	  1
#define DOWN_ARROW_FCN	  2

#define STOCK_NAME_DISPLAY_SIZE 6

#define MAXPOTLONG 0x0FFFFL
#define ALMOST_MAXPOT (MAXPOTLONG -1)

#define PLAYER_PTR(X)  ((struct Player *) ((X)-> IDCMPWindow-> UserData))
#define ACT_REQ_PTR(X) (PLAYER_PTR(X)-> Active_Req)

#define STR_INFO(X) ((struct StringInfo)((X)-> SpecialInfo))

#define HIT_GAD(X) ((struct Gadget *) (X-> IAddress))

typedef VOID (*GadgFun) (struct IntuiMessage *);

struct My_Gad
   {
   struct Gadget	Gad;
   GadgFun		Fun;
   struct IntuiText	*Select, *Deselect;
   LONG			LineHeight;
   };

struct Local_Name
   {
   struct Node	LN_Node;
   UBYTE	Name [4];
   };

struct Stock_List
   {
   struct MinList	List_Of;
   struct Local_Name	*Top_Line;
   LONG			List_Length, Top_Line_Num;
   };

struct Player
   {
   LONG			Continue, ITick_Cnt;
   struct Window 	*Window;
   struct Gadget	*Stock, *Price, *Share, *Day;
   struct My_Gad	*ITick_Select;
   struct Stock_List    Stocks;
   struct Requester     Req_List[4], *Active_Req;
   } ;

static UBYTE STOCK[]		= "Stock";
static UBYTE SELL[]		= "Sell";
static UBYTE BUY[]		= "Buy";
static UBYTE SHARES[]		= "Shares";
static UBYTE AT_MARKET[]	= "At Market";
static UBYTE AT[]		= "Price";
static UBYTE IMMEDIATE[]	= "Immediate";
static UBYTE OPTION[]		= "Option";
static UBYTE LAST_TRADE[]	= "Last Trade";
static UBYTE ACCT_BAL[]		= "Acct Bal";
static UBYTE COST[]		= "Cost";
static UBYTE REVENUE[]		= "Revenue";
static UBYTE NO_MARGIN[]	= "No Margin";
static UBYTE MARGINED[]		= "Margined";
static UBYTE EXECUTE[]		= "Execute";
static UBYTE QUIT[]		= "Quit";
static UBYTE GRAPH[]		= "Graph";
static UBYTE PRICE[]		= "Price";
static UBYTE DAYS[]		= "Days";

static struct IntuiText ITSell		= {1, 0, JAM1, 0, 0, &Default_Font, SELL, NULL};
static struct IntuiText ITBuy		= {1, 0, JAM1, 0, 0, &Default_Font, BUY, NULL};
static struct IntuiText ITAt_Market	= {1, 0, JAM1, 0, 0, &Default_Font, AT_MARKET, NULL};
static struct IntuiText ITAt		= {1, 0, JAM1, 0, 0, &Default_Font, AT, NULL};
static struct IntuiText ITImmediate	= {1, 0, JAM1, 0, 0, &Default_Font, IMMEDIATE, NULL};
static struct IntuiText ITOption	= {1, 0, JAM1, 0, 0, &Default_Font, OPTION, NULL};
static struct IntuiText ITCost		= {1, 0, JAM1, 0, 0, &Default_Font, COST, &ITBuy};
static struct IntuiText ITRevenue	= {1, 0, JAM1, 0, 0, &Default_Font, REVENUE, &ITSell};
static struct IntuiText ITNo_Margin	= {1, 0, JAM1, 0, 0, &Default_Font, NO_MARGIN, NULL};
static struct IntuiText ITMargined	= {1, 0, JAM1, 0, 0, &Default_Font, MARGINED, NULL};
static struct IntuiText ITExecute	= {1, 0, JAM1, 0, 0, &Default_Font, EXECUTE, NULL};
static struct IntuiText ITQuit		= {1, 0, JAM1, 0, 0, &Default_Font, QUIT, NULL};
static struct IntuiText ITGraph		= {1, 0, JAM1, 0, 0, &Default_Font, GRAPH, NULL};

static struct IntuiText ITBlank		= {1, 0, JAM1, 0, 0, &Default_Font, NULL, NULL};

static struct IntuiText ITStock		= {1, 0, JAM1, 0, 0, &Default_Font, STOCK, NULL};
static struct IntuiText ITShares	= {1, 0, JAM1, 0, 0, &Default_Font, SHARES, &ITStock};
static struct IntuiText ITLast_Trade	= {1, 0, JAM1, 0, 0, &Default_Font, LAST_TRADE, &ITShares};
static struct IntuiText ITAcct_Bal	= {1, 0, JAM1, 0, 0, &Default_Font, ACCT_BAL, &ITLast_Trade};

static struct IntuiText IT_Values [] =
	{{1, 0, JAM1, 0, 0, &Default_Font, NULL, NULL},				/*  0 */
	 {1, 0, JAM1, 0, 0, &Default_Font, NULL, &(IT_Values [0])},		/*  1 */
	 {1, 0, JAM1, 0, 0, &Default_Font, NULL, &(IT_Values [1])},		/*  2 */
	 {1, 0, JAM1, 0, 0, &Default_Font, NULL, &(IT_Values [2])}};		/*  3 */

static USHORT Up_Arrow [] =
   {4, 9,
    4, 0,
    3, 1,
    5, 1,
    7, 2,
    1, 2,
    0, 3,
    8, 3};
static USHORT Down_Arrow [] =
   {4, 0,
    4, 9,
    3, 8,
    5, 8,
    7, 7,
    1, 7,
    0, 6,
    8, 6};
static USHORT Box_Arrow_Upper [] =
   {23,  0,
     0,  0,
     0, 13,
     1, 12,
     1,  1};
static USHORT Box_Arrow_Lower [] =
   { 1, 13,
    24, 13,
    24,  0,
    23,  1,
    23, 12};
static USHORT Box_List [] =
   {2,  0, 0,  0, 0,  1, 1,  2, 1,  1,	/*   0 Day Requester Top */
    1,  1, 1,  1, 1,  0, 2,  1, 2,  1,	/*  10 Day Requester Bottom */
    2,  0, 0,  0, 0,  1, 1,  2, 1,  1,	/*  20 Price Requester Top */
    1,  1, 1,  1, 1,  0, 2,  1, 2,  1,	/*  30 Price Requester Bottom */
    2,  0, 0,  0, 0,  1, 1,  2, 1,  1,	/*  40 Share Requester Top */
    1,  1, 1,  1, 1,  0, 2,  1, 2,  1,	/*  50 Share Requester Bottom */
    2,  0, 0,  0, 0,  1, 1,  2, 1,  1,	/*  60 Stock Requester Top */
    1,  1, 1,  1, 1,  0, 2,  1, 2,  1,	/*  70 Stock Requester Bottom */
    2,  0, 0,  0, 0,  1, 1,  2, 1,  1,	/*  80 Day IntuiText Top */
    1,  1, 1,  1, 1,  0, 2,  1, 2,  1,	/*  90 Day IntuiText Bottom */
    2,  0, 0,  0, 0,  1, 1,  2, 1,  1,	/* 100 Price IntuiText Top */
    1,  1, 1,  1, 1,  0, 2,  1, 2,  1,	/* 110 Price IntuiText Bottom */
    2,  0, 0,  0, 0,  1, 1,  2, 1,  1,	/* 120 Share IntuiText Top */
    1,  1, 1,  1, 1,  0, 2,  1, 2,  1,	/* 130 Share IntuiText Bottom */
    2,  0, 0,  0, 0, 13, 1, 12, 1,  1,	/* 140 Day Arrow Top */
    1, 13, 1, 13, 1,  0, 2,  1, 2, 12,	/* 150 Day Arrow Bottom */
    2,  0, 0,  0, 0, 13, 1, 12, 1,  1,	/* 160 Price Arrow Top */
    1, 13, 1, 13, 1,  0, 2,  1, 2, 12,	/* 170 Price Arrow Bottom */
    2,  0, 0,  0, 0, 13, 1, 12, 1,  1,	/* 180 Share Arrow Top */
    1, 13, 1, 13, 1,  0, 2,  1, 2, 12,	/* 190 Share Arrow Bottom */
    2,  0, 0,  0, 0, 13, 1, 12, 1,  1,	/* 200 Price Arrow Odd Ball Top */
    1, 13, 1, 13, 1,  0, 2,  1, 2, 12,	/* 210 Price Arrow Odd Ball Bottom */
    2,  0, 0,  0, 0, 13, 1, 12, 1,  1,	/* 220 Stock Arrow Top */
    1, 13, 1, 13, 1,  0, 2,  1, 2, 12, 	/* 230 Stock Arrow Bottom */
    2,  0, 0,  0, 0, 13, 1, 12, 1,  1,	/* 240 Stock Listing Top */
    1, 13, 1, 13, 1,  0, 2,  1, 2, 12,	/* 250 Stock Listing Bottom */
    2,  0, 0,  0, 0,  1, 1,  2, 1,  1,	/* 260 Gadget Box Top */
    1,  1, 1,  1, 1,  0, 2,  1, 2,  1,	/* 270 Gadget Box Bottom */
    2,  1, 2,  0, 3,  1, 3,  1, 1,  1,	/* 280 Inner-gadget box Top */
    1,  1, 1,  1, 1,  2, 2,  1, 3,  1};	/* 290 Inner-gadget box Bottom */

static struct Border Border_LA_Up = {0, 0, 1, 0, JAM1, 5, Box_Arrow_Lower, NULL};
static struct Border Border_Arrow_Up = {0, 0, 1, 0, JAM1, 5, Box_Arrow_Upper, &Border_LA_Up};
static struct Border Border_LA_Down = {0, 0, 1, 0, JAM1, 5, Box_Arrow_Lower, NULL};
static struct Border Border_Arrow_Down = {0, 0, 1, 0, JAM1, 5, Box_Arrow_Upper, &Border_LA_Down};

static struct Border Border_UA_Double_Up = {4, 2, 1, 0, JAM1, 8, Up_Arrow, &Border_Arrow_Up};
static struct Border Border_Arrow_Double_Up = {12, 2, 1, 0, JAM1, 8, Down_Arrow, &Border_UA_Double_Up};
static struct Border Border_Up_Arrow_Up = {7, 2, 1, 0, JAM1, 8, Up_Arrow, &Border_Arrow_Up};
static struct Border Border_Down_Arrow_Up = {7, 2, 1, 0, JAM1, 8, Down_Arrow, &Border_Arrow_Down};

static struct Border Border_UA_Double_Down = {4, 2, 1, 0, JAM1, 8, Up_Arrow, &Border_Arrow_Down};
static struct Border Border_Arrow_Double_Down = {12, 2, 1, 0, JAM1, 8, Down_Arrow, &Border_UA_Double_Down};
static struct Border Border_Up_Arrow_Down = {7, 2, 1, 0, JAM1, 8, Up_Arrow, &Border_Arrow_Down};
static struct Border Border_Down_Arrow_Down = {7, 2, 1, 0, JAM1, 8, Down_Arrow, &Border_Arrow_Down};

/* High 27 = Up single		High 29 = Up Double
   High 28 = Down Single	Shad 29 = Down Double			*/

static struct Border Highlight_Borders [];

static struct Border Shadow_Borders [] =
   {{-4, -2, 1, 0, JAM1, 5, &(Box_List[270]), NULL},			/*  0 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[260]), &(Highlight_Borders[13])},/*  1 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[260]), &(Shadow_Borders[7])},	/*  2 Used */
    {-2, -1, 1, 0, JAM1, 5, &(Box_List[250]), NULL},			/*  3 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[260]), &(Shadow_Borders[2])},	/*  4 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[260]), &(Shadow_Borders[4])},	/*  5 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[220]), NULL,},			/*  6 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[280]), &(Highlight_Borders[17])},/*  7 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[230]), NULL},			/*  8 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[150]), NULL},			/*  9 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[180]), NULL,},			/* 10 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[140]), NULL},			/* 11 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[190]), NULL},			/* 12 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[200]), NULL,},			/* 13 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[170]), NULL},			/* 14 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[160]), NULL},			/* 15 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[210]), NULL},			/* 16 Used */
    { 0,  0, 1, 0, JAM1, 5, Box_List, NULL},				/* 17 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[120]), NULL},			/* 18 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[20]), NULL},			/* 19 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[100]), NULL},			/* 20 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[40]), NULL},			/* 21 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[130]), NULL},			/* 22 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[80]), NULL},			/* 23 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[60]), NULL},			/* 24 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[110]), NULL},			/* 25 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[90]), NULL},			/* 26 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[260]), NULL},			/* 27 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[270]), NULL},			/* 28 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[280]), &(Highlight_Borders[30])},/* 29 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[290]), &(Highlight_Borders[27])},/* 30 Used */
    {-2, -1, 1, 0, JAM1, 5, &(Box_List[240]), NULL}};			/* 31 Used */

static struct Border Highlight_Borders [] =
   {{ 0,  0, 1, 0, JAM1, 5, &(Box_List[100]), &Shadow_Borders[25]},	/*  0 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[120]), &Shadow_Borders[22]},	/*  1 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[90]), &(Shadow_Borders[23])},	/*  2 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[110]), &(Shadow_Borders[20])},	/*  3 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[130]), &(Shadow_Borders[18])},	/*  4 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[200]), &(Shadow_Borders[16])},	/*  5 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[210]), &(Shadow_Borders[13])},	/*  6 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[180]), &(Shadow_Borders[12])},	/*  7 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[190]), &(Shadow_Borders[10])},	/*  8 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[220]), &(Shadow_Borders[8])},	/*  9 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[230]), &(Shadow_Borders[6])},	/* 10 Used */
    {-2, -1, 1, 0, JAM1, 5, &(Box_List[240]), &(Shadow_Borders[3])},	/* 11 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[260]), &(Shadow_Borders[0])},	/* 12 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[270]), &(Highlight_Borders[27])},/* 13 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[270]), &(Shadow_Borders[5])},	/* 14 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[270]), &(Highlight_Borders[14])},/* 15 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[270]), &(Highlight_Borders[15])},/* 16 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[290]), &(Highlight_Borders[12])},/* 17 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[140]), &(Shadow_Borders[9])},	/* 18 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[150]), &(Shadow_Borders[11])},	/* 19 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[160]), &(Shadow_Borders[14])},	/* 20 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[170]), &(Shadow_Borders[15])},	/* 21 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[10]), &(Shadow_Borders[17])},	/* 22 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[30]), &(Shadow_Borders[19])},	/* 23 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[50]), &(Shadow_Borders[21])},	/* 24 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[70]), &(Shadow_Borders[24])},	/* 25 Used */
    { 0,  0, 1, 0, JAM1, 5, &(Box_List[80]), &Shadow_Borders[26]},	/* 26 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[260]), &(Shadow_Borders[28])},	/* 27 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[270]), &(Shadow_Borders[27])},	/* 28 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[280]), &(Shadow_Borders[30])},	/* 29 Used */
    {-4, -2, 1, 0, JAM1, 5, &(Box_List[290]), &(Highlight_Borders[28])},/* 30 Used */
    {-2, -1, 1, 0, JAM1, 5, &(Box_List[250]), &(Shadow_Borders[31])}};	/* 31 Used */

static UBYTE Stock_String[4], Price_String[8];

static UBYTE Share_String[8]  = "0",
	     Option_String[4] = "0",
	     Price_String[8]  = "0.00";

static struct StringInfo Stock_SInfo = {Stock_String, NULL, 0, 4, 0, 0, 0, 0, 0, 3, NULL, 0};
static struct StringInfo Share_SInfo = {Share_String, NULL, 0, 8, 0, 0, 0, 0, 0, 0, NULL, 0};
static struct StringInfo Price_SInfo = {Price_String, NULL, 0, 8, 0, 0, 0, 0, 0, 0, NULL, 0};
static struct StringInfo Option_SInfo = {Option_String, NULL, 0, 4, 0, 0, 0, 0, 0, 0, NULL, 0};

static struct Image Back_Option_Execute, Back_Option_Quit, Back_Option_Graph;

static struct Image Image_List [] =
   {{0, 63, 5, 29, 0, NULL, 0x0000, 0x0000, NULL}};	/*  0 */

static struct PropInfo PI_List [] =
   {{AUTOKNOB | FREEVERT, -1, 0, -1, MAXBODY}};	/*  0 */

static struct My_Gad Rate; /* forward reference */

static struct My_Gad Fill_Back =
   {NULL, 0, 0, 0, 0, GADGHNONE | GADGIMAGE, 0, BOOLGADGET, (APTR) &Back_Option_Execute,
    NULL, &ITAcct_Bal, 0, NULL, 0, NULL, NULL} ;

static struct My_Gad Option_Execute =
   {NULL, 0, 0, 0, 0, GADGHIMAGE, RELVERIFY, BOOLGADGET, (APTR) &(Highlight_Borders[29]),
    (APTR) &(Shadow_Borders[29]), &ITExecute, 0, NULL, 0, NULL, NULL};

static struct My_Gad Option_Quit =
   {NULL, 0, 0, 0, 0, GADGHIMAGE, RELVERIFY, BOOLGADGET, (APTR) &(Highlight_Borders[29]),
    (APTR) &(Shadow_Borders[29]), &ITQuit, 0, NULL, 0, NULL, NULL};

static struct My_Gad Option_Graph =
   {NULL, 0, 0, 0, 0, GADGHIMAGE, RELVERIFY, BOOLGADGET, (APTR) &(Highlight_Borders[29]),
    (APTR) &(Shadow_Borders[29]), &ITGraph, 0, NULL, 0, NULL, NULL};

static struct My_Gad Stock_Name =
   {NULL, 0, 0, 0, 0, GADGHCOMP, RELVERIFY | STRINGCENTER, STRGADGET, (APTR) &Highlight_Borders[16],
    NULL, &(IT_Values[2]), 0, (APTR) &Stock_SInfo, 0, NULL, NULL};

static struct My_Gad Share_Num =
   {NULL, 0, 0, 0, 0, GADGHCOMP, RELVERIFY | STRINGRIGHT | LONGINT, STRGADGET,
    (APTR) &(Shadow_Borders[7]), NULL, NULL, 0,
    (APTR) &Share_SInfo, 0, (APTR) &Rate, NULL};

static struct My_Gad Price_Num =
   {NULL, 0, 0, 0, 0, GADGHCOMP, RELVERIFY | STRINGRIGHT, STRGADGET,
    (APTR) &(Shadow_Borders[7]), NULL, NULL, 0,
    (APTR) &Price_SInfo, 0, (APTR) &Share_Num, NULL};

static struct My_Gad Option_Num =
   {NULL, 0, 0, 0, 0, GADGHCOMP, RELVERIFY | STRINGRIGHT | LONGINT, STRGADGET,
    (APTR) &(Shadow_Borders[7]), NULL, NULL, 0,
    (APTR) &Option_SInfo, 0, NULL, NULL};

static struct My_Gad Buy_Sell =
   {NULL, 0, 0, 0, 0, GADGHNONE | SELECTED, GADGIMMEDIATE | TOGGLESELECT,
    BOOLGADGET, (APTR) &(Shadow_Borders [1]), NULL, &ITCost, 0, NULL, 0, NULL, NULL, &ITCost, &ITRevenue};

static struct My_Gad Acct_Type =
   {NULL, 0, 0, 0, 0, GADGHNONE | SELECTED, GADGIMMEDIATE | TOGGLESELECT,
    BOOLGADGET, (APTR) &(Highlight_Borders[27]), NULL, &ITNo_Margin, 0, NULL, 0, NULL, NULL, &ITNo_Margin, &ITMargined};

static struct My_Gad Rate =
   {NULL, 0, 0, 0, 0, GADGHNONE | SELECTED, GADGIMMEDIATE | TOGGLESELECT,
    BOOLGADGET, (APTR) &(Highlight_Borders[27]), NULL, &ITAt_Market, 0, NULL, 0, NULL, NULL, &ITAt_Market, &ITAt};

static struct My_Gad When =
   {NULL, 0, 0, 0, 0, GADGHNONE | SELECTED, GADGIMMEDIATE | TOGGLESELECT,
    BOOLGADGET, (APTR) &(Highlight_Borders[27]), NULL, &ITImmediate, 0, NULL, 0, NULL, NULL, &ITImmediate, &ITOption};

/* ClearGadget

History:
1.000 Apr 23, 1990  Jim2 - Written based on My_RemoveGadget

Description:
      Removes a gadget from the window and clears the hit box of the
      gadget.  The color and drawing mode are assume to be set already.
Globals:  NONE
Modules:  NONE
Parameters:
      Here	Pointer to the window where the gadget is displayed.
      This	Pointer to the gadget to be removed and cleared.
Locals:  NONE
									*/
STATI LONG ClearGadget (struct Window * Here, struct Gadget * This)

   {
   RectFill (Here-> RPort, This-> LeftEdge, This-> TopEdge, This-> LeftEdge
	+ This-> Width - 1, This-> TopEdge + This-> Height - 1);
   return (RemoveGadget (Here, This));
   } /* ClearGadget */

#define GAD_BORDER(x) ((struct Border *) (x-> GadgetRender))

/* My_RemoveGadget

History:
1.100 Apr 23, 1990  Jim2
      Commented, clear the hit box and the border assuming that the border
      is symmetric about the gadget.

Description:
      Removes a gadget from the window and attempt to clear the hit box
      area as well as the border.  The color is assumed to be set already.
Globals:  NONE
Modules:  NONE
Parameters:
      Here	Pointer to the window where the gadget is displayed.
      This	Pointer to the gadget to be removed and cleared.
Locals:  NONE
									*/
STATI LONG My_RemoveGadget (struct Window * Here, struct Gadget * This)

   {
   SetDrMd (Here-> RPort, JAM1);
   if (This-> GadgetRender == NULL)
      return (ClearGadget (Here, This));
   if ((GAD_BORDER(This)-> LeftEdge >= 0) || (GAD_BORDER(This)-> TopEdge >= 0))
      return (ClearGadget (Here, This));
      RectFill (Here-> RPort, This-> LeftEdge + GAD_BORDER (This)-> LeftEdge,
	This-> TopEdge + GAD_BORDER (This)-> TopEdge, This-> LeftEdge + This->
	Width - (GAD_BORDER (This)-> LeftEdge + 1), This-> TopEdge + This->
	Height - (GAD_BORDER (This)-> TopEdge + 1));
   return (RemoveGadget (Here, This));
   } /* My_RemoveGadget */

/* Change_IText

History:
1.100 Jan 16, 1990  Jim2
      Keep the gadget at the same position in the list.
1.000 Jan 12, 1990  Jim2 - Written.

Description:
      Changes the IntuiText displayed on a gadget.
Globals:  NONE
Modules:  NONE
Parameters:
      Here	Pointer to the window upon which the gadget is displayed.
      This	Pointer to the gadget.
      Swapped	Pointer to the new IntuiText.
Locals:
      Pos	Position of the gadget in the gadget list.
									*/
STATI VOID Change_IText (struct Window * Here, struct Gadget * This, struct IntuiText * Swapped)

   {
   register LONG Pos;

   SetAPen (Here-> RPort, Swapped-> BackPen);
   if ((Pos = ClearGadget (Here, This)) != -1)
      {
      This-> GadgetText = Swapped;
      AddGadget (Here, This, Pos);
      RefreshGList (This, Here, NULL, 1);
      }
   } /* Change_IText */

/* Alternate_Single

History:
2.000 Apr 20, 1990  Jim2
      Augumented the gadget structure to include the Select and NoSelect
      IntuiTexts
1.000 Jan 11, 1990  Jim2 - Written.

Description
      Changes the IntuiText of a gadget based on the select flag of the
      gadget.
Globals:  NONE
Modules:  NONE
Parameters:
      This_Win	Pointer to the window where the gadget is displayed.
      This	Pointer to the augmented gadget.
Locals:  NONE
									*/
STATI VOID Alternate_Single (struct Window *This_Win, struct My_Gad *This)

   {
   if (((This-> Gad. Flags) & SELECTED) != 0)
      Change_IText (This_Win, (struct Gadget *) This, This-> Select);
   else
      Change_IText (This_Win, (struct Gadget *) This, This-> Deselect);
   } /* Alternate_Single */



/* Hit_Buy_Sell

History:
2.100 Apr 27, 1990  Jim2
      To prevent autorepeating, clear the ITick_Select value in the player
      structure.
2.000 Apr 20, 1990  Jim2
      Changed to support new Alternate Single.  Reduced the use of Module
      level variables.
1.110 Feb 13, 1990  Jim2 - Clear out the lower intuitext.
1.100 Jan 16, 1990  Jim2
      What the heck, lets link the IntuiText and make a new border type
      and only use a single gadget here.
      Added parameter as a beginning to remove references to Modules level
      variables.  This will allow for the possiblity of multiple player.
1.000 Jan 11, 1990  Jim2 - Written.

Description:
      Swaps the IntuiTexts for the Buy_Sell gadget based on the selected
      state of the Buy_Sell gadget.
Globals:  NONE
Modules:
      Referenced:  ITBuy, ITSell, ITCost, ITRevenue.
Parameters:
      Mess	Pointer to the message recieved when this gadget was
		hit.  All information can be accessed from here.
Locals:
      This	Pointer to the extended gadget structure that was hit.
									*/
STATI VOID Hit_Buy_Sell (struct IntuiMessage * Mess)

   {
   register struct Gadget * This;

   This = (struct Gadget *) Mess-> IAddress;
   SetAPen (Mess-> IDCMPWindow-> RPort, This-> GadgetText-> BackPen);
   RectFill (Mess-> IDCMPWindow-> RPort, This-> GadgetText-> LeftEdge + This->
	LeftEdge, This-> GadgetText-> TopEdge + This-> TopEdge, This-> GadgetText->
	LeftEdge + This-> Width + This-> LeftEdge, This-> GadgetText-> TopEdge
	+ Default_Font_Height + This-> TopEdge);
   Alternate_Single (Mess-> IDCMPWindow, (struct My_Gad *) This);
   ((struct Player *) Mess-> IDCMPWindow-> UserData)-> ITick_Select = NULL;
   } /* Hit_Buy_Sell */

/* Get_Last_Price

History:
1.000 Apr 18, 1990  Jim2 - Primative version written.

Description:
      Checks to see if the stock name passed is still a viable stock.
      If so the monitoring port for this task is added to the monitor
      list and the last trade value is added.  If the Rate gadget is
      set to immediate the price is changed to last price.
Globals:  NONE
Modules:
Parameters:
      Stock	Pointer to the string of the stock name.
      Price	Pointer to the Intuitext structure where the last price is
		displayed.
Locals:  NONE
									*/
STATI LONG Get_Last_Price (UBYTE Stock[], struct IntuiText * Price, struct Window *Win)

   {
      {
      if (Price-> IText[2] == '0')
	 Price-> IText[2] = '5';
      else
	 {
	 Price-> IText[2] = '0';
	 if (Price-> IText[0] == '9')
	    Price-> IText[0] = '1';
	 else
	    (Price-> IText[0])++;
	 }
      SetAPen (Win-> RPort, Price-> BackPen);
      RectFill (Win-> RPort, Stock_Name. Gad. LeftEdge, Stock_Name. Gad. TopEdge + Price-> TopEdge, Stock_Name. Gad. LeftEdge + Stock_Name. Gad. Width - 1, Stock_Name. Gad. TopEdge + Price->
TopEdge + Win-> RPort-> TxHeight);
      Price-> LeftEdge = Stock_Name. Gad. Width - IntuiTextLength (Price);
      return (TRUE);
      }
   } /* Get_Last_Price */

/* Release_Stock_String

History:
1.001 Apr 10, 1990  Jim2 - Renamed.
1.000 Mar  6, 1990  Jim2 - Wrote stub.

Description:
      Check the stock name for validity lock main lock main semaphore and
      do find.  Send monitoring message to stock task.  Recalculate cost
      and account balance (this should include reseting shares number if
      acct_Bal < 0).
Globals:  NONE
Modules:  NONE
Parameters:
      Mess	Pointer to the message recieved when this gadget was hit.
		All information can be accessed from here.
Locals:  NONE
									*/
STATI VOID Release_Stock_String (struct IntuiMessage * Mess)
   {
   if (Get_Last_Price (((struct StringInfo *) ((struct Gadget *) Mess-> IAddress)-> SpecialInfo)-> Buffer, ((struct Gadget *) Mess-> IAddress)-> GadgetText, Mess-> IDCMPWindow))
      RefreshGList ((struct Gadget *) Mess-> IAddress, Mess-> IDCMPWindow, NULL, 1);
   } /* Release_Stock_String */

/* Hit_Acct_Type

History:
2.100 Apr 27, 1990  Jim2
      To prevent autorepeating, clear the ITick_Select filed of the player
      structure.
2.000 Apr 20, 1990  Jim2
      Removed use of module level variables and support a revised
      Alternate_Single.
1.100 Jan 16, 1990  Jim2
      Added parameter as a beginning to remove references to Modules level
      variables.  This will allow for the possiblity of multiple player.
1.000 Jan 11, 1990  Jim2 - Written.

Description:
      Changes the IntuiText message in the Acct_Type gadget.
Globals:  NONE
Modules:  NONE
Parameters:
      Mess	Pointer to the message recieved when this gadget was
		hit.  All information can be accessed from here.
Locals:  NONE
									*/
STATI VOID Hit_Alternate (struct IntuiMessage * Mess)

   {
   Alternate_Single (Mess-> IDCMPWindow, (struct My_Gad *) Mess-> IAddress);
   ((struct Player *) Mess-> IDCMPWindow-> UserData)-> ITick_Select = NULL;
   } /* Hit_Acct_Type */

/* Hit_Option_Execute

History:
1.200 Jan 16, 1990  Jim2
      Added parameter to make this routine match the other Hit_?? routines.
1.100 Jan 15, 1990  Jim2
      Saw some code that actually used an Alert.
      Use backslahes, not foward slashes.
1.000 Jan 11, 1990  Jim2 - Wrote stub that does a DisplayAlert.

Description:
      Takes the action for the execute option.
Globals:  NONE
Modules:  NONE
Parameters:
      Mess	Pointer to the message recieved when this gadget was
		hit.  All information can be accessed from here.
Locals:  NONE
									*/
STATI VOID Hit_Option_Execute (struct IntuiMessage * Mess)

   {
   DisplayAlert (RECOVERY_ALERT, "\000\360\020 Hit Execute button\00", 44L);
   } /* Hit_Option_Execute */

/* Hit_Option_Quit

History:
1.200 Jan 16, 1990  Jim2
      Added parameter to make this routine match the other Hit_?? routines.
1.000 Jan 11, 1990  Jim2 - Wrote stub that does a DisplayAlert.

Description:
      Takes the action for the quit option.
Globals:  NONE
Modules:  NONE
Parameters:
      Mess	Pointer to the message recieved when this gadget was
		hit.  All information can be accessed from here.
Locals:  NONE
									*/
STATI VOID Hit_Option_Quit (struct IntuiMessage * Mess)

   {
   ((struct Player *) (Mess-> IDCMPWindow-> UserData))-> Continue = FALSE;
   } /* Hit_Option_Quit */

/* Hit_Option_Graph

History:
1.200 Jan 16, 1990  Jim2
      Added parameter to make this routine match the other Hit_?? routines.
1.000 Jan 11, 1990  Jim2 - Wrote stub that does a DisplayAlert.

Description:
      Takes the action for the graph option.
Globals:  NONE
Modules:  NONE
Parameters:
      Mess	Pointer to the message recieved when this gadget was
		hit.  All information can be accessed from here.
Locals:  NONE
									*/
STATI VOID Hit_Option_Graph (struct IntuiMessage * Mess)

   {
   DisplayAlert (RECOVERY_ALERT, "\x00\xF0\x0A This function is not yet implemented\x00", 18L);
   } /* Hit_Option_Graph */

/* Center

History:
2.000 Apr 16, 1990  Jim2 - Only need the TxHeight, not the whole RastPort.
1.000 Jan 11, 1990  Jim2 - Written.

Description:
      Centers an IntuiText string in a box of size X, Y.
Globals:  NONE
Modules:  NONE
Parameters:
      Text	Pointer to the IntuiText to be centered.
      TxHeight	Height of the font of the text.
      X, Y	Box size.
Locals:  NONE
									*/
STATI VOID Center (struct IntuiText *Text, LONG TxHeight, LONG X, LONG Y)

   {
   Text-> TopEdge = (Y - TxHeight)/ 2;
   Text-> LeftEdge = (X - IntuiTextLength (Text)) / 2;
   }

/* Initialize_Borders

History:
2.000 Apr 11, 1990  Jim2
      The vector arrays for the boxes have been moved in the module
      variable, Box_List.  The fixed values are initialized by the
      system.  Since half of the indicies for the double box are the
      indicies for a single box they are not repeated.  Instead, an
      addition border structure will be used.  This will allow for
      the two tone string gadget borders.
1.000 Jan 11, 1990  Jim2 - Written.

Description:
      Sets up the vector arrays so they make an X by Y box.
Globals:  NONE
Modules:
      Altered:	Box_List
Parameters:
      X_Size, Y_Size  the outer dimensions of the box.
Locals:  NONE
									*/
STATI VOID Initialize_Borders (LONG X_Size, LONG Y_Size)
   {
   Y_Size += 3;
   Box_List[271] = Box_List[273] = Box_List[265] = Y_Size--;
   Box_List[267] = Box_List[279] = Box_List[291] = Box_List[297] = Box_List[299]
	=  Box_List[283] = Y_Size--;
   Box_List[285] = Y_Size;

   X_Size += 7;
   Box_List[272] = Box_List[274] = X_Size--;
   Box_List[276] = Box_List[278] = Box_List[260] = X_Size--;
   Box_List[290] = Box_List[292] = X_Size--;
   Box_List[294] = Box_List[296] = Box_List[288] = X_Size;
   } /* Initialize_Borders */

/* Size_Boxes

History:
2.100 Apr 23, 1990  Jim2
      Don't include the borders in the size of the boxes.
2.000 Apr 17, 1990  Jim2
      The boxes should be sized before the window is opened to determine
      the size the window needs to me.  Therefore add the parameters that
      pass the width of the top and left border and return the size of
      the window less the bottom and right border.  Also we need the
      height of the font being used.
1.000 Jan 11, 1990  Jim2 - Written.

Description:
      Sizes the boxes and intializes the border structures so the boxes
      box the largest string based on the users defualt font type.

Globals:
      Referenced:  Default_Font_Height.
Modules:
      Altered:	   ITSell, ITBuy, ITAt_Market, ITAt, ITImmediate, ITOption,
		   ITCost, ITRevenue, ITNo_Margin, ITMargined, ITExecute,
		   ITQuit, ITGraph.
      Referenced:  STOCK, SHARES, LAST_TRADE, ACCT_BAL.
Parameters:
      BorderTop		Height of the top border of the window where the
			gadgets are to be rendered.
      BorderLeft	Width of the left border of the window where the
			gadgets are to be rendered.
      Height		Height required of the window to allow the gadgets
			to be rendered.  Included is the height of the top,
			but not the bottom border.
      Width		Width required of the window to allow the gadgets
			to be rendered.  Included is the width of the left,
			but not the right border.
Locals:
      I			Loop Control;
      X, Y		Size of the box.
      X_Pos, Y_Pos	Position of the Gadget in the window.
      Text_Offset	Additional offset needed to center text.
									*/
STATI VOID Size_Boxes (LONG BorderTop, BYTE BorderLeft, SHORT * Height, SHORT
	* Width)

   {
   register LONG 	    I, X, Y, X_Pos, Y_Pos, Text_Offset;

#define V_POS_GAD(G) (G). Gad. TopEdge = Y_Pos; Y_Pos += Y + YSKIP
#define V_POS_TEXT_GAD(G) (G). Gad. TopEdge = Y_Pos + Text_Offset; Y_Pos += Y + YSKIP


   Y = Default_Font_Height;
   Y += max (Y / 10, 2);
   X = max (0, IntuiTextLength (&ITSell));
   X = max (X, IntuiTextLength (&ITBuy));
   X = max (X, IntuiTextLength (&ITAt_Market));
   X = max (X, IntuiTextLength (&ITAt));
   X = max (X, IntuiTextLength (&ITImmediate));
   X = max (X, IntuiTextLength (&ITOption));
   X = max (X, IntuiTextLength (&ITCost));
   X = max (X, IntuiTextLength (&ITRevenue));
   X = max (X, IntuiTextLength (&ITNo_Margin));
   X = max (X, IntuiTextLength (&ITMargined));
   X = max (X, IntuiTextLength (&ITGraph));
   X = max (X, IntuiTextLength (&ITExecute));
   X = max (X, IntuiTextLength (&ITQuit));
   X = max (X, IntuiTextLength (&ITStock));
   X = max (X, IntuiTextLength (&ITShares));
   X = max (X, IntuiTextLength (&ITLast_Trade));
   X = max (X, IntuiTextLength (&ITAcct_Bal));
   X += max (X / 10, 2);
   Initialize_Borders (X, Y);
   Center (&ITSell, Default_Font_Height, X, Y);
   Center (&ITBuy, Default_Font_Height, X, Y);
   Center (&ITAt_Market, Default_Font_Height, X, Y);
   Center (&ITAt, Default_Font_Height, X, Y);
   Center (&ITImmediate, Default_Font_Height, X, Y);
   Center (&ITOption, Default_Font_Height, X, Y);
   Center (&ITCost, Default_Font_Height, X, Y);
   Center (&ITRevenue, Default_Font_Height, X, Y);
   Center (&ITNo_Margin, Default_Font_Height, X, Y);
   Center (&ITMargined, Default_Font_Height, X, Y);
   Center (&ITExecute, Default_Font_Height, X, Y);
   Center (&ITQuit, Default_Font_Height, X, Y);
   Center (&ITGraph, Default_Font_Height, X, Y);
   Center (&ITStock, Default_Font_Height, X, Y);
   Center (&ITLast_Trade, Default_Font_Height, X, Y);
   Center (&ITAcct_Bal, Default_Font_Height, X, Y);
   Center (&ITShares, Default_Font_Height, X, Y);

   Buy_Sell. Gad. Width = Rate. Gad. Width = When. Gad. Width = Acct_Type.
	Gad. Width = Option_Execute. Gad. Width = Back_Option_Execute. Width
	= Option_Quit. Gad. Width = Back_Option_Quit. Width = Option_Graph.
	Gad. Width = Back_Option_Graph. Width = X;

   Buy_Sell. Gad. Height = Rate. Gad. Height = When. Gad. Height = Acct_Type.
	Gad. Height = Option_Execute. Gad. Height = Back_Option_Execute. Height
	= Option_Quit. Gad. Height = Back_Option_Quit. Height = Option_Graph.
	Gad. Height = Back_Option_Graph. Height = Y;

   Stock_Name. Gad. Height = Share_Num. Gad. Height = Price_Num. Gad. Height
	= Option_Num. Gad. Height = Default_Font_Height;

   Text_Offset = (Y - Default_Font_Height) / 2;
   Shadow_Borders[0]. TopEdge = Shadow_Borders[7]. TopEdge = Highlight_Borders[12]. TopEdge
	= Highlight_Borders[17]. TopEdge -= Text_Offset;

   X_Pos = BorderLeft + XSKIP;
   Y_Pos = BorderTop + YSKIP;

   Buy_Sell. Gad. LeftEdge = Rate. Gad. LeftEdge = When. Gad. LeftEdge = X_Pos;

   ITStock. LeftEdge += X_Pos;
   ITStock. TopEdge += Y_Pos;
   Y_Pos += YSKIP + Y;
   V_POS_GAD (Buy_Sell);
   ITShares. LeftEdge += X_Pos;
   ITShares. TopEdge += Y_Pos;
   Y_Pos += YSKIP + Y;
   V_POS_GAD (Rate);
   V_POS_GAD (When);
   ITLast_Trade. LeftEdge += X_Pos;
   ITLast_Trade. TopEdge += Y_Pos;
   Y_Pos += YSKIP + Y;
   ITAcct_Bal. LeftEdge += X_Pos;
   ITAcct_Bal. TopEdge += Y_Pos;
   Y_Pos += YSKIP + Y;
   Shadow_Borders[1]. TopEdge = Highlight_Borders[13]. TopEdge += Y_Pos - Buy_Sell. Gad. TopEdge;
   ITRevenue. TopEdge = ITCost. TopEdge += (Highlight_Borders[13]. TopEdge + 2);
   *Height = Y_Pos + YSKIP + Y;

   X_Pos += XSKIP + X;
   Y_Pos = BorderTop + YSKIP;

   X_Pos += XSKIP + X_ARROWS;
   Y_Pos = BorderTop + YSKIP;

   Stock_Name. Gad. LeftEdge = Acct_Type. Gad. LeftEdge = Share_Num. Gad. LeftEdge =
	Price_Num. Gad. LeftEdge = Option_Num. Gad. LeftEdge = X_Pos;

   Stock_Name. Gad. Width = Share_Num. Gad. Width = Price_Num. Gad. Width =
   	Option_Num. Gad. Width = X;

   V_POS_TEXT_GAD (Stock_Name);
   Stock_String[0] = '\0';
   V_POS_GAD (Acct_Type);
   V_POS_TEXT_GAD (Share_Num);
   V_POS_TEXT_GAD (Price_Num);
   V_POS_TEXT_GAD (Option_Num);
   Shadow_Borders[5]. TopEdge = Highlight_Borders[16]. TopEdge += Y_Pos - Stock_Name. Gad. TopEdge;
   Shadow_Borders[4]. TopEdge = Highlight_Borders[15]. TopEdge = Highlight_Borders[16]. TopEdge + Y + YSKIP;
   Shadow_Borders[2]. TopEdge = Highlight_Borders[14]. TopEdge = Highlight_Borders[15]. TopEdge + Y + YSKIP;
   I = IT_Values[2]. TopEdge = Shadow_Borders[5]. TopEdge + ITSell. TopEdge + 2;
   IT_Values[1]. TopEdge = I += (Y + YSKIP);
   IT_Values[0]. TopEdge = I + Y + YSKIP;

   X_Pos += XSKIP + XSKIP + X;
   Y_Pos = BorderTop + YSKIP + (3 * Y) / 2;

   Option_Execute. Gad. LeftEdge = Back_Option_Execute. LeftEdge = Option_Quit.
	Gad. LeftEdge = Back_Option_Quit. LeftEdge = Option_Graph. Gad. LeftEdge
	= Back_Option_Graph. LeftEdge = X_Pos;

   Option_Execute. Gad. TopEdge = Back_Option_Execute. TopEdge = Y_Pos;
   Option_Quit. Gad. TopEdge = Back_Option_Quit. TopEdge = Y_Pos += 2 * (Y
	+ YSKIP);
   Option_Graph. Gad. TopEdge = Back_Option_Graph. TopEdge = Y_Pos += 2 * (Y
	+ YSKIP);

   Back_Option_Execute.TopEdge-=BorderTop;
   Back_Option_Quit.TopEdge-=BorderTop;
   Back_Option_Graph.TopEdge-=BorderTop;

   ITStock.TopEdge-=BorderTop;
   ITShares.TopEdge-=BorderTop;
   ITLast_Trade.TopEdge-=BorderTop;
   ITAcct_Bal.TopEdge-=BorderTop;

   Back_Option_Execute.LeftEdge-=BorderLeft;
   Back_Option_Quit.LeftEdge-=BorderLeft;
   Back_Option_Graph.LeftEdge-=BorderLeft;

   ITStock.LeftEdge-=BorderLeft;
   ITShares.LeftEdge-=BorderLeft;
   ITLast_Trade.LeftEdge-=BorderLeft;
   ITAcct_Bal.LeftEdge-=BorderLeft;

   Fill_Back.Gad.LeftEdge=BorderLeft;
   Fill_Back.Gad.TopEdge=BorderTop;

   Back_Option_Execute. Depth = Back_Option_Execute. PlanePick = Back_Option_Quit.
	Depth = Back_Option_Quit. PlanePick = Back_Option_Graph. Depth = Back_Option_Graph.
	PlanePick = 0;

   Back_Option_Execute. NextImage = &Back_Option_Quit;
   Back_Option_Quit. NextImage = &Back_Option_Graph;

   Back_Option_Execute. ImageData = Back_Option_Quit. ImageData = Back_Option_Graph.
	ImageData = NULL;
   Back_Option_Graph. NextImage = NULL;

   *Width = X_Pos + X + XSKIP;
   } /* Size_Boxes*/

#define NORMAL_TEXT(X,Y)    (X). FrontPen = TEXTPEN0; (X). BackPen = 0
#define REVERSE_TEXT(X,Y)   (X). FrontPen = 0; (X). BackPen = TEXTPEN0

/* Initial_Player_Window_Structures

History:
1.000 Jan 16, 1990  Jim2 - Written.

Description:
      Sets up all of the defaults for the information which will be
      constant regardless of the number of players.
Globals:
      Referenced:  PenColors
Modules:
      Altered:	Border_LS_Up, Border
Parameters:  NONE
Locals:
      I	Loop Control
									*/

EXTERN VOID Initial_Player_Window_Structures (VOID)

   {
   register LONG I;

   Border_LA_Up. FrontPen = PenColors-> Shadow;
   Border_Arrow_Up. FrontPen = PenColors-> Highlight;
   Border_LA_Down. FrontPen = PenColors-> Highlight;
   Border_Arrow_Down. FrontPen = PenColors-> Shadow;

   Border_UA_Double_Up. FrontPen = TEXTPEN0;
   Border_Arrow_Double_Up. FrontPen = TEXTPEN0;
   Border_Up_Arrow_Up. FrontPen = TEXTPEN0;
   Border_Down_Arrow_Up. FrontPen = TEXTPEN0;

   Border_UA_Double_Down. FrontPen = TEXTPEN0;
   Border_Arrow_Double_Down. FrontPen = TEXTPEN0;
   Border_Up_Arrow_Down. FrontPen = TEXTPEN0;
   Border_Down_Arrow_Down. FrontPen = TEXTPEN0;

   for (I = 0; I <= sizeof (Shadow_Borders) / sizeof (struct Border);)
      Shadow_Borders[I++]. FrontPen = PenColors-> Shadow;
   for (I = 0; I <= sizeof (Highlight_Borders)/ sizeof (struct Border);)
      Highlight_Borders[I++]. FrontPen = PenColors-> Highlight;

   NORMAL_TEXT (ITSell, PenColors);
   NORMAL_TEXT (ITBuy, PenColors);
   NORMAL_TEXT (ITAt_Market, PenColors);
   NORMAL_TEXT (ITAt, PenColors);
   NORMAL_TEXT (ITImmediate, PenColors);
   NORMAL_TEXT (ITOption, PenColors);
   NORMAL_TEXT (ITCost, PenColors);
   NORMAL_TEXT (ITRevenue, PenColors);
   NORMAL_TEXT (ITNo_Margin, PenColors);
   NORMAL_TEXT (ITMargined, PenColors);

   REVERSE_TEXT (ITExecute, PenColors);
   REVERSE_TEXT (ITQuit, PenColors);
   REVERSE_TEXT (ITGraph, PenColors);

   NORMAL_TEXT (ITStock, PenColors);
   NORMAL_TEXT (ITShares, PenColors);
   NORMAL_TEXT (ITLast_Trade, PenColors);
   NORMAL_TEXT (ITAcct_Bal,PenColors);

   Back_Option_Execute. PlaneOnOff = TEXTPEN0;
   Back_Option_Quit. PlaneOnOff = TEXTPEN0;
   Back_Option_Graph. PlaneOnOff = TEXTPEN0;

   Buy_Sell. Fun = Hit_Buy_Sell;
   Acct_Type. Fun= Hit_Alternate;
   Rate. Fun = Hit_Alternate;
   When. Fun = Hit_Alternate;

   Option_Execute. Fun = Hit_Option_Execute;
   Option_Quit. Fun =  Hit_Option_Quit;
   Option_Graph. Fun = Hit_Option_Graph;


   Stock_Name. Fun = Release_Stock_String;


   } /* Initial_Player_Window_Structures */

/*  Run_Player

History:
1.200 May  7, 1990  Jim2
      Intialize the new elements in the Player record.
1.100 Apr 18, 1990  Jim2
      Handle extended gadget structures.  Size the window and position
      it at the bottom of the screen.  Display the Stock requester forcing
      the user to choose a stock at the start.  Don't forget to free the
      string for the cost.
1.000 Jan 17, 1990  Jim2 - Written as a subroutine.

Description:
      This task handles the interactions for a single player of the
      stock market game.
Globals:  NONE
Modules:  NONE
Parameters:
      Player	Pointer to the information for this player.
Locals:
      Info1
      Temp
									*/
EXTERN VOID Run_Player (struct Player * Player)

   {
#define WINDOW (Player-> Window)

   register struct IntuiMessage *Info1;
   register APTR		Temp;

   struct NewWindow nw = {0, 0, 640, 200, 0, 1, GADGETUP | GADGETDOWN| CLOSEWINDOW | NOCAREREFRESH | INTUITICKS,
    WINDOWDEPTH | WINDOWCLOSE | WINDOWDRAG,
    NULL, NULL, (UBYTE *) "Trial GUI by Jim2, MKSoft", NULL, NULL, 0, 0, -1, -1, WBENCHSCREEN};

   Player-> ITick_Select = NULL;
   Player-> ITick_Cnt = 0;
   NewList ((struct List *) &Player-> Stocks. List_Of);

   nw. DetailPen = PenColors-> TextPen;
   nw. BlockPen = PenColors-> BackPen;
   Size_Boxes (WBScrData. BarHeight + WBScrData. WBorTop, WBScrData. WBorLeft,
	 &(nw. Height), &(nw. Width));

   nw. Height += WBScrData. WBorBottom;
   nw. Width += WBScrData. WBorRight;
   if ((nw. Height <= WBScrData. Height) && (nw. Width <=  WBScrData. Width))
      {
      nw. TopEdge = WBScrData. Height - nw. Height;
      WINDOW = OpenWindow (&nw);
      SetFont (WINDOW-> RPort, Default_Text);
      WINDOW-> UserData = (BYTE *) Player;

      SetAPen (WINDOW->RPort, PenColors->TextPen);
      SetBPen (WINDOW->RPort, PenColors->BackPen);

      Player-> Stock = (struct Gadget *) &Stock_Name;
      Player-> Price = (struct Gadget *) &Price_Num;
      Player-> Share = (struct Gadget *) &Share_Num;
      Player-> Day = (struct Gadget *) &Option_Num;
      AddGadget (WINDOW, (struct Gadget *) &Buy_Sell, -1);
      AddGadget (WINDOW, (struct Gadget *) &Acct_Type, -1);
      AddGadget (WINDOW, (struct Gadget *) &Rate, -1);
      AddGadget (WINDOW, (struct Gadget *) &When, -1);
      AddGadget (WINDOW, (struct Gadget *) &Option_Execute, -1);
      AddGadget (WINDOW, (struct Gadget *) &Option_Quit, -1);
      AddGadget (WINDOW, (struct Gadget *) &Option_Graph, -1);
      AddGadget (WINDOW, Player-> Stock, -1);
      AddGadget (WINDOW, Player-> Share, -1);
      AddGadget (WINDOW, Player-> Price, -1);
      AddGadget (WINDOW, Player-> Day, -1);
      AddGadget (WINDOW, (struct Gadget *) &Fill_Back, -1);
      RefreshGList (WINDOW-> FirstGadget, WINDOW, NULL, -1);
      Player-> Continue = TRUE;
      do
	 {
	 WaitPort (WINDOW-> UserPort);
	 while ((Info1 = (struct IntuiMessage *) GetMsg (WINDOW-> UserPort)) != NULL)
	    {
	    if (Player-> Continue)
	       switch (Info1-> Class)
		  {
		  case CLOSEWINDOW :
		     Player-> Continue = FALSE;
		     break;
		  case GADGETDOWN  :
		     {
		     Player-> ITick_Select = (struct MyGad *) Info1-> IAddress;
		     Player-> ITick_Cnt = 0;
		     if (((struct My_Gad *) Info1-> IAddress)-> Fun != NULL)
			(((struct My_Gad *) Info1-> IAddress)-> Fun) (Info1);
		     }
		     break;
		  case GADGETUP    :
		     if (((struct My_Gad *) Info1-> IAddress)-> Fun != NULL)
			(((struct My_Gad *) Info1-> IAddress)-> Fun) (Info1);
		     break;
		  case INTUITICKS   :
		     if (Player-> ITick_Cnt < ITICK_INTIAL_SKIP)
			(Player-> ITick_Cnt)++;
		     else
			if (Player-> ITick_Select != NULL)
			   if (((Player-> ITick_Select-> Gad. Flags) & SELECTED) != 0)
				{
				    if (Player-> ITick_Select-> Fun)
				       {
				       Temp = Info1-> IAddress;
				       Info1-> IAddress = (APTR) Player-> ITick_Select;
				       Player-> ITick_Select-> Fun (Info1);
				       Info1-> IAddress = Temp;
				       }
				}
			   else
			      Player-> ITick_Select = NULL;
		     break;
		  }
	    ReplyMsg ((struct Message *) Info1);
	    }
	 }
      while (Player-> Continue);
      CloseWindow (WINDOW);
      }
   }


main (VOID)

{
struct Player *Player;

IntuitionBase = (struct InuitionBase *) OpenLibrary ("intuition.library", 33L);
GfxBase = (struct GfxBase *) OpenLibrary ("graphics.library", 33L);
GetScreenData ((char *) &WBScrData, sizeof (struct Screen), WBENCHSCREEN, NULL);
Forbid ();
Default_Font. ta_Name = WBScrData. Font-> ta_Name;
Default_Font. ta_YSize = WBScrData. Font-> ta_YSize;
Default_Font. ta_Style = WBScrData. Font-> ta_Style;
Default_Font. ta_Flags = WBScrData. Font-> ta_Flags;
Default_Text = OpenFont (&Default_Font);
Permit ();
Default_Font_Height = Default_Text-> tf_YSize;
Player = (struct Player *) AllocMem (sizeof (struct Player), MEMF_CLEAR | MEMF_PUBLIC);
if (PenColors=Get_RenderInfo(&WBScrData))
   {
   IT_Values[2]. IText = AllocMem (4L, MEMF_CLEAR);
   strcpy (IT_Values[2]. IText, "1.00");

   Initial_Player_Window_Structures ();

   Run_Player (Player);

   CleanUp_RenderInfo(PenColors);
   }

FreeMem (Player, sizeof (struct Player));
CloseFont (Default_Text);
CloseLibrary ((struct Library *) GfxBase);
CloseLibrary ((struct Library *) IntuitionBase);
}
