/*
 * Copyright (C) 1990 Commodore-Amiga, Inc.
 * All rights reserved
 */

/* locale.library example.
 * Compiled with lc -cfist -v -L getmsg.c
 *
 * Usage:
 * 
 * 1> catgen catexample.src <catalogue> ; Generate catalogue
 * 1> getmsg <catalogue> <msg_number>   ; get local message
 *
 * See Readme.
 */

#include <exec/types.h>
#include <exec/lists.h>
#include <exec/libraries.h>
#include <clib/exec_protos.h>

#include <locale/localebase.h>
#include <locale/locale.h>
#include "protos/locale_protos.h"
#include "pragmas/locale_pragmas.h"

#include <stdio.h>
#include <stdlib.h>

int main(int, char **);

int main(int argc, char *argv[])
{
	APTR *LocaleBase;
	char *str;
	struct Catalogue *catalogue;

	LocaleBase = (APTR)OpenLibrary("locale.library",NULL);

	if (LocaleBase == NULL)
	{
		printf("Could not open locale.library!\n");
		exit(10);
	}

	if (!(catalogue = CatOpen(argv[1],NULL)))
	{
		printf("Could not open catalogue '%s'\n",argv[1]);
	}
	str = CatGets(catalogue,1,atoi(argv[2]),"This is a default message\n");
	printf(str);
	CatClose(catalogue);
	CloseLibrary((struct Library *)LocaleBase);
	return(NULL);
}

