*\ :ts=8 bk=0
*
* iffparse.i:	Assembly include file for iffparse.library.
*		Generated by hand from iffparse.h (9006.04)
*
* Leo L. Schwab						9006.04
*/
		IFND	IFF_IFFPARSE_I
IFF_IFFPARSE_I	SET	1

		IFND	EXEC_TYPES_I
		include 'exec/types.i'
		ENDC

		IFND	EXEC_LISTS_I
		include 'exec/lists.i'
		ENDC

		IFND	EXEC_PORTS_I
		include 'exec/ports.i'
		ENDC

		IFND	DEVICES_CLIPBOARD_I
		include 'devices/clipboard.i'
		ENDC

*\
* Struct associated with an active IFF stream.
* "iff_Stream" is a value used by the client's read/write/seek functions -
* it will not be accessed by the library itself and can have any value
* (could even be a pointer or a BPTR).
*/
	STRUCTURE IFFHandle,0
		ULONG	iff_Stream
		ULONG	iff_Flags
		LONG	iff_Depth	; Depth of context stack.
* There are private fields hiding here.
	LABEL	iff_SIZEOF

*\
* Bit masks for "iff_Flags" field.
*/
IFFF_READ	EQU	0			; read mode - default
IFFF_WRITE	EQU	1			; write mode
IFFF_RWBITS	EQU	IFFF_READ!IFFF_WRITE	; read/write bits
IFFF_FSEEK	EQU	1<<1			; forward seek only
IFFF_RSEEK	EQU	1<<2			; random seek
IFFF_RESERVED	EQU	$FFFF0000		; Don't touch these bits.

*\
* When the library calls your stream handler, you'll be passed a pointer
* to this structure as the "message packet".
*/
	STRUCTURE IFFStreamCmd,0
		LONG	sc_Command	; Operation to be performed (IFFCMD_)
		APTR	sc_Buf		; Pointer to data buffer
		LONG	sc_NBytes	; Number of bytes to be affected
	LABEL	sc_SIZEOF

*\
* A node associated with a context on the iff_Stack.  Each node
* represents a chunk, the stack representing the current nesting 
* of chunks in the open IFF file.  Each context node has associated
* local context items in the (private) LocalItems list.  The ID, type,
* size and scan values describe the chunk associated with this node.
*/
	STRUCTURE ContextNode,MLN_SIZE	; cn_Node
		LONG	cn_ID
		LONG	cn_Type
		LONG	cn_Size		; Size of this chunk
		LONG	cn_Scan		; # of bytes read/written so far
* There are private fields hiding here.
	LABEL	cn_SIZEOF

*\
* Local context items live in the ContextNode's.  Each class is identified
* by its lci_Ident code and has a (private) purge vector for when the
* parent context node is popped.
*/
	STRUCTURE LocalContextItem,MLN_SIZE	; lci_Node
		ULONG	lci_ID
		ULONG	lci_Type
		ULONG	lci_Ident
* There are private fields hiding here.
	LABEL	lci_SIZEOF

*\
* StoredProperty: a local context item containing the data stored
* from a previously encountered property chunk.
*/
	STRUCTURE StoredProperty,0
		LONG	sp_Size
		APTR	sp_Data
	LABEL	sp_SIZEOF

*\
* Collection Item: the actual node in the collection list at which
* client will look.  The next pointers cross context boundaries so
* that the complete list is accessable.
*/
	STRUCTURE CollectionItem,0
		APTR	ci_Next
		LONG	ci_Size
		APTR	ci_Data
	LABEL	ci_SIZEOF

*\
* Structure returned by OpenClipboard().  You may do CMD_POSTs and such
* using this structure.  However, once you call OpenIFF(), you may not
* do any more of your own I/O to the clipboard until you call CloseIFF().
*/
	STRUCTURE ClipboardHandle,iocr_SIZEOF	; cbh_Reg
		STRUCT	cbh_CBport,MP_SIZE
		STRUCT	cbh_SatisfyPort,MP_SIZE
	LABEL	cbh_SIZEOF

*\
* IFF return codes.  Most functions return either zero for success or
* one of these codes.  The exceptions are the read/write functions which
* return positive values for number of bytes or records read or written,
* or a negative error code.  Some of these codes are not errors per sae,
* but valid conditions such as EOF or EOC (End of Chunk).
*/
IFFERR_EOF		EQU	-1	; Reached logical end of file
IFFERR_EOC		EQU	-2	; About to leave context
IFFERR_NOSCOPE		EQU	-3	; No valid scope for property
IFFERR_NOMEM		EQU	-4	; Internal memory alloc failed
IFFERR_READ		EQU	-5	; Stream read error
IFFERR_WRITE		EQU	-6	; Stream write error
IFFERR_SEEK		EQU	-7	; Stream seek error
IFFERR_MANGLED		EQU	-8	; Data in file is corrupt
IFFERR_SYNTAX		EQU	-9	; IFF syntax error
IFFERR_NOTIFF		EQU	-10	; Not an IFF file
IFFERR_NOHOOK		EQU	-11	; No call-back hook provided
IFF_RETURN2CLIENT	EQU	-12	; Client handler normal return

*\
* Universal IFF identifiers.
*/
ID_FORM			EQU	'FORM'
ID_LIST			EQU	'LIST'
ID_CAT			EQU	'CAT '
ID_PROP			EQU	'PROP'
ID_NULL			EQU	'    '

*\
* Ident codes for universally recognized local context items.
*/
IFFLCI_PROP		EQU	'prop'
IFFLCI_COLLECTION	EQU	'coll'
IFFLCI_ENTRYHANDLER	EQU	'enhd'
IFFLCI_EXITHANDLER	EQU	'exhd'

*\
* Control modes for ParseIFF() function.
*/
IFFPARSE_SCAN		EQU	0
IFFPARSE_STEP		EQU	1
IFFPARSE_RAWSTEP	EQU	2

*\
* Control modes for StoreLocalItem().
*/
IFFSLI_ROOT		EQU	1	; Store in default context
IFFSLI_TOP		EQU	2	; Store in current context
IFFSLI_PROP		EQU	3	; Store in topmost FORM or LIST

*\
* "Flag" for writing functions.  If you pass this value in as a size
* to PushChunk() when writing a file, the parser will figure out the
* size of the chunk for you.  (Chunk sizes >= 2**31 are forbidden by the
* IFF specification, so this works.)
*/
IFFSIZE_UNKNOWN		EQU	-1

*\
* Possible call-back command values.  (Gee, it would be nice if there was an
* ENUM macro.)
*/
IFFCMD_INIT		EQU	0	; Prepare your stream for a session
IFFCMD_CLEANUP		EQU	1	; Terminate stream session
IFFCMD_READ		EQU	2	; Read bytes from stream
IFFCMD_WRITE		EQU	3	; Write bytes to stream
IFFCMD_SEEK		EQU	4	; Seek on stream
IFFCMD_ENTRY		EQU	5	; You just entered a new context
IFFCMD_EXIT		EQU	6	; You're about to leave a context
IFFCMD_PURGELCI		EQU	7	; Purge a LocalContextItem

* Backward compatibility.  Don't use these in new code.
IFFSCC_INIT		EQU	IFFCMD_INIT
IFFSCC_CLEANUP		EQU	IFFCMD_CLEANUP
IFFSCC_READ		EQU	IFFCMD_READ
IFFSCC_WRITE		EQU	IFFCMD_WRITE
IFFSCC_SEEK		EQU	IFFCMD_SEEK

		ENDC	; IFF_IFFPARSE_I
