/*  :ts=8 bk=0
 *
 * wiff2.c:	Test IFF write program.  Writes junk, really.
 *
 * Usage: wiff <file | "-c">
 *
 * Writes a demo IFF file to the specified stream -- either a DOS file or
 * the clipboard's primary clip.
 *
 * Stuart Ferguson (created)				8809.01
 * ewhac: Fixed bugs, added testing/illustration of
 *	  client-supplied sizes.			8811.02
 * ewhac: Updated to 1.4 Beta.				8912.06
 * ewhac: Latticeification				9005.31
 */
#include <exec/types.h>
#include <libraries/dos.h>
#include <libraries/iffparse.h>
#include <clib/exec_protos.h>
#include <clib/dos_protos.h>
#include "iffparse_protos.h"
#include "iffparse.p"

#define	ID_ILBM	MAKE_ID('I','L','B','M')
#define	ID_BMHD	MAKE_ID('B','M','H','D')
#define	ID_BODY	MAKE_ID('B','O','D','Y')
#define	ID_CRNG	MAKE_ID('C','R','N','G')
#define	ID_TEST	MAKE_ID('T','E','S','T')


/*
 * Forward function declarations.  (I hate ANSI.)
 */
LONG PropOut (struct IFFHandle *);
LONG FormOut1 (struct IFFHandle *);
LONG FormOut2 (struct IFFHandle *);


struct Library	*IFFParseBase;


main (argc, argv)
int	argc;
char	**argv;
{
	struct IFFHandle	*iff = NULL;
	long			error;
	short			cbio;

	if (argc < 2) {
		printf ("usage: %s <outfile | \"-c\">\n", argv[0]);
		goto die;
	}

	cbio = (argv[1][0] == '-' && argv[1][1] == 'c');

	if (!(IFFParseBase = OpenLibrary ("iffparse.library", 0L))) {
		puts ("Cannot open library.");
		goto die;
	}

	if (!(iff = AllocIFF())) {
		puts ("AllocIFF() failed.");
		goto die;
	}

	if (cbio) {
		if (!(iff->iff_Stream =
				(ULONG) OpenClipboard (PRIMARY_CLIP)))
		{
			puts ("Clipboard open failed.");
			goto die;
		}
		InitIFFasClip (iff);
	} else {
		if (!(iff->iff_Stream = Open (argv[1], MODE_NEWFILE))) {
			puts ("File open failed.");
			goto die;
		}
		InitIFFasDOS (iff);
	}

	if (error = OpenIFF (iff, IFFF_WRITE)) {
		puts ("OpenIFF failed.");
		goto die;
	}

	if (error = PushChunk (iff, ID_TEST, ID_LIST, IFFSIZE_UNKNOWN)) {
		puts ("Initial PushChunk() failed.");
		goto die;
	}
	if (error = PropOut (iff)) {
		puts ("PROP out failed.");
		goto die;
	}
	if (error = FormOut1 (iff)) {
		puts ("First FORM out died.");
		goto die;
	}
	if (error = FormOut2 (iff)) {
		puts ("Second FORM out died.");
		goto die;
	}
	if (error = PopChunk (iff))
		puts ("Final PopChunk() failed.");

die:
	if (error)
		printf ("error code: %ld\n", error);

	if (iff) {
		CloseIFF (iff);

		if (iff->iff_Stream)
			if (cbio)
				CloseClipboard ((struct ClipboardHandle *)
						iff->iff_Stream);
			else
				Close (iff->iff_Stream);

		FreeIFF (iff);
	}

	if (IFFParseBase)	CloseLibrary (IFFParseBase);
}


LONG
PropOut (iff)
struct IFFHandle *iff;
{
	LONG	error;

	if (error = PushChunk (iff, ID_ILBM, ID_PROP, IFFSIZE_UNKNOWN))
		return (error);

	if (error = PushChunk (iff, 0L, ID_BMHD, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, (APTR) "This is the BMHD.......", 20L) != 20)
		return (10);
	if (error = PopChunk (iff))
		return (error);

	if (error = PushChunk (iff, 0L, ID_CRNG, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, (APTR) "a", 1L) != 1)
		return (11);
	if (error = PopChunk (iff))
		return (error);

	if (error = PushChunk (iff, 0L, ID_CRNG, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, (APTR) "ab", 2L) != 2)
		return (12);
	if (error = PopChunk (iff))
		return (error);

	return (PopChunk (iff));
}


LONG
FormOut1 (iff)
struct IFFHandle *iff;
{
	LONG	error;

	if (error = PushChunk (iff, ID_ILBM, ID_FORM, IFFSIZE_UNKNOWN))
		return (error);

	if (error = PushChunk (iff, 0L, ID_BODY, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, (APTR) "I'm the Body.  Hi.", 18L) != 18)
		return (20);
	if (error = PopChunk (iff))
		return (error);

	if (error = PushChunk (iff, 0L, ID_CRNG, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, (APTR) "abc", 3L) != 3)
		return (21);
	if (error = PopChunk (iff))
		return (error);

	if (error = PushChunk (iff, 0L, ID_CRNG, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, (APTR) "abcd", 4L) != 4)
		return (22);
	if (error = PopChunk (iff))
		return (error);

	return (PopChunk (iff));
}


LONG
FormOut2 (iff)
struct IFFHandle *iff;
{
	LONG	error;

	if (error = PushChunk (iff, ID_ILBM, ID_FORM, IFFSIZE_UNKNOWN))
		return (error);

	if (error = PushChunk (iff, 0L, ID_CRNG, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, (APTR) "abcde", 5L) != 5)
		return (30);
	if (error = PopChunk (iff))
		return (error);

	if (error = PushChunk (iff, 0L, ID_CRNG, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, (APTR) "abcdef", 6L) != 6)
		return (31);
	if (error = PopChunk (iff))
		return (error);

	if (error = PushChunk (iff, 0L, ID_BODY, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, (APTR) "I'm the Body.  Hi.", 18L) != 18)
		return (32);
	if (error = PopChunk (iff))
		return (error);

	return (PopChunk (iff));
}

/*
 * Disable Lattice's default ^C trap.
 */
chkabort ()
{
	return (0);
}

CXBRK ()
{
	return (0);
}
