/*  :ts=8 bk=0
 *
 * wiff.c:	Test IFF write program.  Writes junk, really.
 *
 * Usage: wiff [-c] [file]
 *
 * Writes a demo IFF file to the specified stream -- either a DOS file or
 * the clipboard's primary clip.
 *
 * Stuart Ferguson (created)				8809.01
 * ewhac: Fixed bugs, added testing/illustration of
 *	  client-supplied sizes.			8811.02
 * shf:   Updated to Dec 88 design revision		8812.15
 * ewhac: Updated to 1.4 Beta				8912.06
 * ewhac: Latticeification				9005.31
 */
#include <exec/types.h>
#include <libraries/dos.h>
#include <libraries/iffparse.h>
#include <clib/exec_protos.h>
#include <clib/dos_protos.h>
#include "iffparse_protos.h"
#include "iffparse.p"

#define	ID_FTXT	MAKE_ID('F','T','X','T')
#define	ID_CHRS	MAKE_ID('C','H','R','S')
#define	ID_FNAM	MAKE_ID('F','N','A','M')
#define	ID_ZOID	MAKE_ID('Z','O','I','D')


/*
 * Forward function declarations.  (I hate ANSI.)
 */
LONG TextChunkOut (struct IFFHandle *, char *);
LONG TestChunkOut (struct IFFHandle *);

struct Library	*IFFParseBase;


main (argc, argv)
int	argc;
char	**argv;
{
	struct IFFHandle	*iff = NULL;
	long			error;
	short			cbio;

	if (argc < 2) {
		printf ("usage: %s <outfile | \"-c\">\n", argv[0]);
		goto die;
	}
	cbio = (argv[1][0] == '-' && argv[1][1] == 'c');

	if (!(IFFParseBase = OpenLibrary ("iffparse.library", 0L))) {
		puts ("Can't get IFF parse library\n");
		goto die;
	}

	if (!(iff = AllocIFF())) {
		puts ("AllocIFF() failed.");
		goto die;
	}

	if (cbio) {
		if (!(iff->iff_Stream =
				(ULONG) OpenClipboard (PRIMARY_CLIP)))
		{
			puts ("Clipboard open failed.");
			goto die;
		}
		InitIFFasClip (iff);
	} else {
		if (!(iff->iff_Stream = Open (argv[1], MODE_NEWFILE))) {
			puts ("File open failed.");
			goto die;
		}
		InitIFFasDOS (iff);
	}

	if (error = OpenIFF (iff, IFFF_WRITE)) {
		puts ("OpenIFF failed.");
		goto die;
	}

	if (error = PushChunk (iff, ID_ZOID, ID_LIST, IFFSIZE_UNKNOWN)) {
		printf ("Initial PushChunk() error %ld\n", error);
		goto die;
	}
	if (error = PushChunk (iff, ID_FTXT, ID_FORM, IFFSIZE_UNKNOWN)) {
		printf ("Initial PushChunk() error %ld\n", error);
		goto die;
	}
	if (error = TestChunkOut (iff)) {
		printf ("Test out error %ld.\n", error);
		goto die;
	}

	if (error = TextChunkOut (iff, "This is a test")) {
		printf ("Text out error %ld.\n", error);
		goto die;
	}
	if (error = TextChunkOut (iff, "And another")) {
		printf ("Text out error %ld.\n", error);
		goto die;
	}
	if (error = PopChunk (iff)) {
		printf ("penFinal PopChunk() error %ld\n", error);
		goto die;
	}
	if (error = PopChunk (iff)) {
		printf ("Final PopChunk() error %ld\n", error);
		goto die;
	}

die:
	if (iff) {
		CloseIFF (iff);

		if (iff->iff_Stream)
			if (cbio)
				CloseClipboard ((struct ClipboardHandle *)
						iff->iff_Stream);
			else
				Close (iff->iff_Stream);

		FreeIFF (iff);
	}

	if (IFFParseBase)	CloseLibrary (IFFParseBase);
}


LONG
TextChunkOut (iff, str)
struct IFFHandle *iff;
char		*str;
{
	LONG	error, size;

	if (error = PushChunk (iff, 0L, ID_CHRS, IFFSIZE_UNKNOWN))
		return (error);

	size = strlen (str);
	if (WriteChunkRecords (iff, (APTR) str, 1L, size) != size)
		return (IFFERR_WRITE);

	printf ("wrote chunk <%s>\n", str);

	return (PopChunk (iff));
}


LONG
TestChunkOut (iff)
struct IFFHandle *iff;
{
	LONG	error, size;

	size = 10;
	if (error = PushChunk (iff, 0L, ID_FNAM, size))
		return (error);

	if (WriteChunkBytes (iff, (APTR) "fname67890", size) != size)
		return (-100);

	return (PopChunk (iff));
}

/*
 * Disable Lattice's default ^C trap.
 */
chkabort ()
{
	return (0);
}

CXBRK ()
{
	return (0);
}
