/*  :ts=8 bk=0
 *
 * simple.c:	Demonstrates the basic steps required in doing the simplest
 *		possible IFF file parsing.  This program doesn't actually
 *		*do* anything; it just illustrates how the rudimentary stuff
 *		is done.
 *	SYNOPSIS:
 *		simple <filename>
 *
 *		WARNING:  Error checking has been deleted for reasons of
 *		clarity.  Do *not* use this as a model of How To Do It
 *		Properly In The Real World.
 *
 * Leo L. Schwab				8902.23
 * Updated for 1.4 Beta				8912.06
 * Latticeification				9005.30
 */
#include <exec/types.h>
#include <libraries/dosextens.h>
#include <libraries/iffparse.h>
#include <clib/exec_protos.h>
#include <clib/dos_protos.h>
#include "iffparse_protos.h"
#include "iffparse.p"


struct Library	*IFFParseBase;


main (argc, argv)
int	argc;
char	**argv;
{
	struct IFFHandle	*iff;
	long			error;

	/*
	 * Let me say it again.  Error checking has been deleted for clarity.
	 * A Real program *MUST* have error checking in it.
	 */
	IFFParseBase = OpenLibrary ("iffparse.library", 2L);

	/*
	 * Allocate the IFFHandle structure.  This is the only supported way
	 * to allocate an IFFHandle structure.  Declaring a static structure
	 * won't do it, since there are private fields not declared in the
	 * iff.h file.  Thus, sizeof (struct IFFHandle), as far as you're
	 * concerned, is wrong.  AllocIFF(), however, will get it right
	 * every time, in all current and future releases.
	 */
	iff = AllocIFF ();

	/*
	 * Set up the iff_Stream field.  This field is not used by the
	 * iffparse.library itself, but is instead passed to the client's
	 * read, write, and seek routines, which the library invokes.  This
	 * means that iff_Stream can represent anything you wish, since it
	 * will be your routines that will interpret it.  In this example,
	 * we're opening an AmigaDOS file.
	 */
	iff->iff_Stream = Open (argv[1], MODE_OLDFILE);

	/*
	 * As a convenience, iffparse.library provides call-back routines for
	 * direct DOS manipulation internally.  This routine points the
	 * IFFHandle's private call-back vectors at those internal routines,
	 * saving you the trouble of having to declare them yourself (in your
	 * own code space).
	 */
	InitIFFasDOS (iff);

	/*
	 * This "opens" the IFFHandle stream for transaction.  This
	 * initializes internal state only; no reading of the file is done.
	 */
	OpenIFF (iff, IFFF_READ);

	/*
	 * This this the biggie.  As used in this example, this routine will
	 * trip happily along through the file, verifying syntax, until it
	 * hits end-of-file, at which point, it will return the value
	 * IFFERR_EOF.
	 */
	error = ParseIFF (iff, IFFPARSE_SCAN);

	/*
	 * If we didn't get IFFERR_EOF back, then something went wrong while
	 * scanning the file.  Print out the error code as a diagnostic.
	 * (A better approach would be to use the error code as an index into
	 * an array of strings, and print the appropriate string.)
	 */
	if (error != IFFERR_EOF)
		printf ("Abnormal termination:  error = %ld\n", error);

	/*
	 * Terminate the transaction with the IFFHandle.  This routine may
	 * be called at any time.  All dynamically allocated structures
	 * are freed by this call (except the IFFHandle structure itself).
	 */
	CloseIFF (iff);

	/*
	 * Close the I/O stream we opened.  (A DOS file in this example.)
	 */
	Close (iff->iff_Stream);

	/*
	 * Free the IFFHandle structure itself.
	 */
	FreeIFF (iff);

	CloseLibrary (IFFParseBase);
}
