#ifndef  CLIB_IFFPARSE_PROTO_H
#define  CLIB_IFFPARSE_PROTO_H
/* "iffparse.library" */
/*------ Basic functions ------*/
struct IFFHandle *AllocIFF( void );
LONG OpenIFF( struct IFFHandle *iff, LONG rwMode );
LONG ParseIFF( struct IFFHandle *iff, LONG control );
void CloseIFF( struct IFFHandle *iff );
void FreeIFF( struct IFFHandle *iff );
/*------ Read/Write functions ------*/
LONG ReadChunkBytes( struct IFFHandle *iff, APTR buf, LONG size );
LONG WriteChunkBytes( struct IFFHandle *iff, APTR buf, LONG size );
LONG ReadChunkRecords( struct IFFHandle *iff, APTR buf, LONG bytesPerRecord,
	LONG nRecords );
LONG WriteChunkRecords( struct IFFHandle *iff, APTR buf, LONG bytesPerRecord,
	LONG nRecords );
/*------ Context entry/exit ------*/
LONG PushChunk( struct IFFHandle *iff, LONG type, LONG id, LONG size );
LONG PopChunk( struct IFFHandle *iff );
/*------ Low-level handler installation ------*/
LONG EntryHandler( struct IFFHandle *iff, LONG type, LONG id, LONG position,
	struct Hook *handler, APTR object );
LONG ExitHandler( struct IFFHandle *iff, LONG type, LONG id, LONG position,
	struct Hook *handler, APTR object );
/*------ Built-in chunk/property handlers ------*/
LONG PropChunk( struct IFFHandle *iff, LONG type, LONG id );
LONG PropChunks( struct IFFHandle *iff, LONG *propArray, LONG nProps );
LONG StopChunk( struct IFFHandle *iff, LONG type, LONG id );
LONG StopChunks( struct IFFHandle *iff, LONG *propArray, LONG nProps );
LONG CollectionChunk( struct IFFHandle *iff, LONG type, LONG id );
LONG CollectionChunks( struct IFFHandle *iff, LONG *propArray, LONG nProps );
LONG StopOnExit( struct IFFHandle *iff, LONG type, LONG id );
/*------ Context utilities ------*/
struct StoredProperty *FindProp( struct IFFHandle *iff, LONG type, LONG id );
struct CollectionItem *FindCollection( struct IFFHandle *iff, LONG type,
	LONG id );
struct ContextNode *FindPropContext( struct IFFHandle *iff );
struct ContextNode *CurrentChunk( struct IFFHandle *iff );
struct ContextNode *ParentChunk( struct ContextNode *contextNode );
/*------ LocalContextItem support functions ------*/
struct LocalContextItem *AllocLocalItem( LONG type, LONG id, LONG ident,
	LONG dataSize );
APTR LocalItemData( struct LocalContextItem *localItem );
void SetLocalItemPurge( struct LocalContextItem *localItem,
	struct Hook *purgeHook );
void FreeLocalItem( struct LocalContextItem *localItem );
struct LocalContextItem *FindLocalItem( struct IFFHandle *iff, LONG type,
	LONG id, LONG ident );
LONG StoreLocalItem( struct IFFHandle *iff, struct LocalItem *localItem,
	LONG position );
void StoreItemInContext( struct IFFHandle *iff, struct LocalItem *localItem,
	struct ContextNode *contextNode );
/*------ IFFHandle initialization ------*/
void InitIFF( struct IFFHandle *iff, LONG flags, struct Hook *streamHook );
void InitIFFasDOS( struct IFFHandle *iff );
void InitIFFasClip( struct IFFHandle *iff );
/*------ Internal clipboard support ------*/
struct ClipboardHandle *OpenClipboard( LONG unitNum );
void CloseClipboard( struct ClipboardHandle *clipboard );
/*------ Miscellaneous ------*/
LONG GoodID( LONG id );
LONG GoodType( LONG type );
char *IDtoStr( LONG id, char *buf );
#endif   /* CLIB_IFFPARSE_PROTO_H */
